/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sapphire.ElementType;

public final class ElementData {
    private final ElementType type;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public ElementData(ElementType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
    }

    public ElementType type() {
        return this.type;
    }

    public Object read(String property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        return this.properties.get(property);
    }

    public void write(String property, Object content) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        if (content != null) {
            this.properties.put(property, content);
        } else {
            this.properties.remove(property);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf, "");
        return buf.toString();
    }

    private void toString(StringBuilder buf, String indent) {
        buf.append(this.type.getQualifiedName()).append('\n');
        buf.append(indent).append("{\n");
        String indentPlusOne = String.valueOf(indent) + "    ";
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            buf.append(indentPlusOne).append(entry.getKey()).append(" = ");
            Object content = entry.getValue();
            if (content instanceof String) {
                buf.append('\"').append((String)content).append('\"');
            } else if (content instanceof ElementData) {
                ((ElementData)content).toString(buf, indentPlusOne);
            } else if (content instanceof List) {
                buf.append('\n');
                buf.append(indentPlusOne).append('[');
                String indentPlusTwo = String.valueOf(indentPlusOne) + "    ";
                boolean first = true;
                for (Object item : (List)content) {
                    if (!first) {
                        buf.append(',');
                    }
                    buf.append('\n');
                    buf.append(indentPlusTwo);
                    ((ElementData)item).toString(buf, indentPlusTwo);
                    first = false;
                }
                buf.append('\n');
                buf.append(indentPlusOne).append(']');
            } else {
                buf.append(content.toString());
            }
            buf.append('\n');
        }
        buf.append(indent).append('}');
    }
}

