/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.ui.def.HtmlContentSourceType;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.HtmlPanelDef;
import org.eclipse.sapphire.ui.forms.HtmlPanelPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.text.SapphireFormText;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class HtmlPanelPresentation
extends FormComponentPresentation {
    @Text(value="Could not initialize embedded browser.")
    private static LocalizableText couldNotInitializeBrowserMessage;

    static {
        LocalizableText.init(HtmlPanelPresentation.class);
    }

    public HtmlPanelPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
    }

    @Override
    public HtmlPanelPart part() {
        return (HtmlPanelPart)super.part();
    }

    @Override
    public void render() {
        final HtmlPanelPart part = this.part();
        HtmlPanelDef def = part.definition();
        boolean scaleVertically = part.getScaleVertically();
        GridData gd = GridLayoutUtil.gdhindent(GridLayoutUtil.gdwhint(GridLayoutUtil.gdhspan(scaleVertically ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), 2), 100), 9);
        if (!scaleVertically) {
            gd = GridLayoutUtil.gdhhint(gd, (Integer)def.getHeight().content());
        }
        int style = (Boolean)def.getShowBorder().content() != false ? 2048 : 0;
        try {
            final Browser browser = new Browser(this.composite(), style);
            browser.setLayoutData((Object)gd);
            this.register((Control)browser);
            if (def.getContentSourceType().content() == HtmlContentSourceType.EMBEDDED) {
                browser.setText(part.content());
                this.attachPartListener((Listener)new FilteredListener<HtmlPanelPart.ContentEvent>(){

                    protected void handleTypedEvent(HtmlPanelPart.ContentEvent event) {
                        browser.setText(part.content());
                    }
                });
            } else {
                browser.setUrl(part.url());
                this.attachPartListener((Listener)new FilteredListener<HtmlPanelPart.ContentEvent>(){

                    protected void handleTypedEvent(HtmlPanelPart.ContentEvent event) {
                        browser.setUrl(part.url());
                    }
                });
            }
        }
        catch (SWTError sWTError) {
            SapphireFormText text = new SapphireFormText(this.composite(), style);
            text.setText(couldNotInitializeBrowserMessage.text(), false, false);
            text.setLayoutData(gd);
            this.register((Control)text);
        }
    }
}

