/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.eclipse.scout.sdk.s2e.nls.NlsCore;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.fields.ISmartFieldModel;
import org.eclipse.swt.graphics.Image;

public class CountrySmartFieldModel
implements ISmartFieldModel {
    private final List<Locale> m_locales;

    public CountrySmartFieldModel() {
        String[] isoCountries = Locale.getISOCountries();
        ArrayList<Locale> locs = new ArrayList<Locale>(isoCountries.length);
        String[] stringArray = isoCountries;
        int n = isoCountries.length;
        int n2 = 0;
        while (n2 < n) {
            String isoCountry = stringArray[n2];
            locs.add(new Locale("", isoCountry));
            ++n2;
        }
        this.m_locales = locs;
    }

    @Override
    public Image getImage(Object item) {
        return NlsCore.getImage("comment");
    }

    @Override
    public List<Object> getProposals(String pattern) {
        LinkedList<Object> props = new LinkedList<Object>();
        for (Locale l : this.m_locales) {
            if (!l.getDisplayCountry().toLowerCase().startsWith(pattern.toLowerCase())) continue;
            props.add(l);
        }
        return props;
    }

    @Override
    public String getText(Object item) {
        if (item == null) {
            return "";
        }
        Locale l = (Locale)item;
        return String.valueOf(l.getDisplayCountry()) + " (" + l.getCountry() + ")";
    }
}

