/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.sdk.core.util.IFilter;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.JavaProjectContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.PackageContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.SourceFolderContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.StrictHierarchyTypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.TypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.resource.ResourceTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextField;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public class FieldToolkit {
    public StyledTextField createStyledTextField(Composite parent, String label, int type) {
        return this.createStyledTextField(parent, label, type, 150);
    }

    public StyledTextField createStyledTextField(Composite parent, String label, int type, int labelWidth) {
        StyledTextField styledTextField = new StyledTextField(parent, type, labelWidth);
        styledTextField.setLabelText(label);
        return styledTextField;
    }

    public ResourceTextField createResourceField(Composite parent, String label, int type) {
        return this.createResourceField(parent, label, type, 150);
    }

    public ResourceTextField createResourceField(Composite parent, String label, int type, int labelWidth) {
        ResourceTextField field = new ResourceTextField(parent, type, labelWidth);
        field.setLabelText(label);
        return field;
    }

    public ProposalTextField createProposalField(Composite parent, String label) {
        return this.createProposalField(parent, label, 1);
    }

    public ProposalTextField createProposalField(Composite parent, String label, int type) {
        return this.createProposalField(parent, label, type, 150);
    }

    public ProposalTextField createProposalField(Composite parent, String label, int type, int labelWidth) {
        ProposalTextField field = new ProposalTextField(parent, type, labelWidth);
        field.setLabelText(label);
        return field;
    }

    public Group createGroupBox(Composite parent, String label) {
        Group group = new Group(parent, 16);
        group.setText(label);
        return group;
    }

    public Button createCheckBox(Composite parent, String label, boolean checkedByDefault) {
        Button btn = new Button(parent, 32);
        btn.setText(label);
        btn.setSelection(checkedByDefault);
        return btn;
    }

    public ProposalTextField createPackageField(Composite parent, String label, IJavaProject project) {
        return this.createPackageField(parent, label, project, 150);
    }

    public ProposalTextField createPackageField(Composite parent, String label, IJavaProject project, int labelWidth) {
        return this.createPackageField(parent, label, project, labelWidth, 1);
    }

    public ProposalTextField createPackageField(Composite parent, String label, IJavaProject project, int labelWidth, int type) {
        ProposalTextField proposalField = this.createProposalField(parent, label, type, labelWidth);
        PackageContentProvider provider = new PackageContentProvider(project);
        proposalField.setContentProvider(provider);
        proposalField.setLabelProvider((IBaseLabelProvider)provider);
        proposalField.setProposalDescriptionProvider(provider);
        return proposalField;
    }

    public ProposalTextField createSourceFolderField(Composite parent, String label, ScoutTier tier) {
        return this.createSourceFolderField(parent, label, tier, 150);
    }

    public ProposalTextField createSourceFolderField(Composite parent, String label, ScoutTier tier, int labelWidth) {
        ProposalTextField proposalField = this.createProposalField(parent, label, 1, labelWidth);
        SourceFolderContentProvider provider = new SourceFolderContentProvider((IFilter<IJavaElement>)tier);
        proposalField.setContentProvider(provider);
        proposalField.setLabelProvider((IBaseLabelProvider)provider);
        return proposalField;
    }

    public ProposalTextField createAbstractTypeProposalField(Composite parent, String label, IJavaProject jp, String baseClassFqn) {
        return this.createAbstractTypeProposalField(parent, label, jp, baseClassFqn, 150);
    }

    public ProposalTextField createAbstractTypeProposalField(Composite parent, String label, IJavaProject jp, String baseClassFqn, int labelWidth) {
        ProposalTextField proposalField = this.createProposalField(parent, label, 2, labelWidth);
        StrictHierarchyTypeContentProvider provider = new StrictHierarchyTypeContentProvider(jp, baseClassFqn);
        provider.setTypeProposalFilter((IFilter<IType>)new S2eUtils.PublicAbstractPrimaryTypeFilter());
        proposalField.setContentProvider(provider);
        proposalField.setLabelProvider((IBaseLabelProvider)provider);
        proposalField.setProposalDescriptionProvider(provider);
        proposalField.addHyperlinkListener((IHyperlinkListener)new JavaElementHyperlinkListener(proposalField));
        return proposalField;
    }

    public ProposalTextField createProjectProposalField(Composite parent, String label) {
        return this.createProjectProposalField(parent, label, null);
    }

    public ProposalTextField createProjectProposalField(Composite parent, String label, IFilter<IJavaProject> filter) {
        return this.createProjectProposalField(parent, label, filter, 150);
    }

    public ProposalTextField createProjectProposalField(Composite parent, String label, IFilter<IJavaProject> filter, int labelWidth) {
        ProposalTextField proposalField = this.createProposalField(parent, label, 1, labelWidth);
        JavaProjectContentProvider provider = new JavaProjectContentProvider();
        provider.setFilter(filter);
        proposalField.setContentProvider(provider);
        proposalField.setLabelProvider((IBaseLabelProvider)provider);
        return proposalField;
    }

    public ProposalTextField createTypeProposalField(Composite parent, String label, IJavaProject jp) {
        return this.createTypeProposalField(parent, label, jp, 150);
    }

    public ProposalTextField createTypeProposalField(Composite parent, String label, IJavaProject jp, int labelWidth) {
        ProposalTextField proposalField = this.createProposalField(parent, label, 2, labelWidth);
        TypeContentProvider provider = new TypeContentProvider(jp);
        provider.setTypeProposalFilter((IFilter<IType>)new S2eUtils.PublicPrimaryTypeFilter());
        proposalField.setContentProvider(provider);
        proposalField.setLabelProvider((IBaseLabelProvider)provider);
        proposalField.setProposalDescriptionProvider(provider);
        proposalField.addHyperlinkListener((IHyperlinkListener)new JavaElementHyperlinkListener(proposalField));
        return proposalField;
    }

    protected static final class JavaElementHyperlinkListener
    extends HyperlinkAdapter {
        private final ProposalTextField m_owner;

        public JavaElementHyperlinkListener(ProposalTextField owner) {
            this.m_owner = owner;
        }

        public void linkActivated(HyperlinkEvent e) {
            Object proposal = this.m_owner.getSelectedProposal();
            if (proposal instanceof IJavaElement) {
                S2eUiUtils.openInEditor((IJavaElement)proposal);
            }
        }
    }
}

