/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields.proposal.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.scout.sdk.core.util.IFilter;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.AbstractContentProviderAdapter;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class JavaProjectContentProvider
extends AbstractContentProviderAdapter {
    private IFilter<IJavaProject> m_filter;

    public String getText(Object element) {
        return ((IJavaProject)element).getElementName();
    }

    @Override
    protected Collection<? extends Object> loadProposals(IProgressMonitor monitor) {
        try {
            IJavaProject[] allJavaProjectsInWorkspace = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
            ArrayList<IJavaProject> allMavenJavaProjects = new ArrayList<IJavaProject>(allJavaProjectsInWorkspace.length);
            IJavaProject[] iJavaProjectArray = allJavaProjectsInWorkspace;
            int n = allJavaProjectsInWorkspace.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject candidate = iJavaProjectArray[n2];
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                if (this.accepts(candidate)) {
                    allMavenJavaProjects.add(candidate);
                }
                ++n2;
            }
            return allMavenJavaProjects;
        }
        catch (CoreException e) {
            SdkLog.error((String)"Unable to get all java projects in the current workspace.", (Object[])new Object[]{e});
            return Collections.emptyList();
        }
    }

    protected boolean accepts(IJavaProject jp) throws CoreException {
        if (!S2eUtils.exists((IJavaElement)jp)) {
            return false;
        }
        IProject project = jp.getProject();
        if (!project.isAccessible()) {
            return false;
        }
        if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
            return false;
        }
        IFile pom = project.getFile("pom.xml");
        if (pom == null || !pom.isAccessible()) {
            return false;
        }
        IFilter<IJavaProject> filter = this.getFilter();
        return filter == null || filter.evaluate((Object)jp);
    }

    public IFilter<IJavaProject> getFilter() {
        return this.m_filter;
    }

    public void setFilter(IFilter<IJavaProject> filter) {
        this.m_filter = filter;
    }
}

