/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ScoutTemplateProposalFactory;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.osgi.framework.Bundle;

public class ScoutTemplateCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!(context instanceof JavaContentAssistInvocationContext)) {
            return Collections.emptyList();
        }
        try {
            IRegion lineInformationOfOffset;
            Bundle bundle = Platform.getBundle((String)"org.eclipse.scout.sdk.s2e.ui");
            if (bundle == null || bundle.getState() != 32) {
                return Collections.emptyList();
            }
            JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
            CompletionContext coreContext = javaContext.getCoreContext();
            if (coreContext == null || !coreContext.isExtended() || coreContext.isInJavadoc() || coreContext.isInJavadocText()) {
                return Collections.emptyList();
            }
            int offset = javaContext.getInvocationOffset();
            if (offset < 0) {
                return Collections.emptyList();
            }
            IJavaElement element = coreContext.getEnclosingElement();
            if (!S2eUtils.exists((IJavaElement)element) || element.getElementType() != 7) {
                return Collections.emptyList();
            }
            IType t = (IType)element;
            if (t.isBinary()) {
                return Collections.emptyList();
            }
            Document d = new Document(t.getCompilationUnit().getSource());
            String lineSource = d.get((lineInformationOfOffset = d.getLineInformationOfOffset(offset)).getOffset(), lineInformationOfOffset.getLength());
            if (lineSource.indexOf(64) >= 0 || lineSource.indexOf(46) >= 0 || lineSource.indexOf(40) >= 0 || lineSource.indexOf(41) >= 0) {
                return Collections.emptyList();
            }
            String prefix = null;
            CharSequence computedPrefix = javaContext.computeIdentifierPrefix();
            if (StringUtils.isNotEmpty((CharSequence)computedPrefix)) {
                prefix = computedPrefix.toString();
            }
            return ScoutTemplateProposalFactory.createTemplateProposals(t, offset, prefix);
        }
        catch (Exception e) {
            SdkLog.error((String)"Error calculating Scout template proposals.", (Object[])new Object[]{e});
            return Collections.emptyList();
        }
    }

    public void sessionStarted() {
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }
}

