/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wizard.lookupcall;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.IFilter;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.CachingJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IProposalListener;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.StrictHierarchyTypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.TypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.internal.wizard.lookupcall.LookupCallNewWizard;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.wizard.CompilationUnitNewWizardPage;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;

public class LookupCallNewWizardPage
extends CompilationUnitNewWizardPage {
    public static final String PROP_SVC_IMPL_SUPER_TYPE_BASE = "svcImplSuperTypeBase";
    public static final String PROP_SVC_IMPL_SUPER_TYPE = "svcImplSuperType";
    public static final String PROP_SERVER_SOURCE_FOLDER = "serverSourceFolder";
    public static final String PROP_KEY_TYPE = "keyType";
    public static final String PROP_SERVER_JAVA_PROJECT = "serverJavaProject";
    private final IJavaEnvironmentProvider m_provider = new CachingJavaEnvironmentProvider();
    protected ProposalTextField m_lookupServiceSuperTypeField;
    protected ProposalTextField m_serverSourceFolder;
    protected ProposalTextField m_keyTypeField;

    public LookupCallNewWizardPage(PackageContainer packageContainer) {
        super(LookupCallNewWizardPage.class.getName(), packageContainer, "LookupCall", "org.eclipse.scout.rt.shared.services.lookup.ILookupCall", "org.eclipse.scout.rt.shared.services.lookup.LookupCall", ScoutTier.Shared);
        this.setTitle("Create a new LookupCall");
        this.setDescription(this.getTitle());
        this.setIcuGroupName("New LookupCall Details");
        this.setServiceImplSuperTypeBaseClassInternal("org.eclipse.scout.rt.shared.services.lookup.ILookupService");
    }

    public LookupCallNewWizard getWizard() {
        return (LookupCallNewWizard)super.getWizard();
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        StrictHierarchyTypeContentProvider superTypeContentProvider = (StrictHierarchyTypeContentProvider)this.getSuperTypeField().getContentProvider();
        superTypeContentProvider.setTypeProposalFilter((IFilter<IType>)new S2eUtils.PublicAbstractPrimaryTypeFilter(){

            public boolean evaluate(IType candidate) {
                if (!S2eUtils.exists((IJavaElement)candidate)) {
                    return false;
                }
                if ("org.eclipse.scout.rt.shared.services.lookup.LookupCall".equals(candidate.getFullyQualifiedName())) {
                    return true;
                }
                return super.evaluate(candidate);
            }
        });
        this.guessServerFolders();
        this.createLookupCallPropertiesGroup(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_lookupcall_page_context");
    }

    protected IType calcServiceImplSuperTypeDefault() {
        return LookupCallNewWizardPage.resolveType(this.getServerJavaProject(), "org.eclipse.scout.rt.server.services.lookup.AbstractLookupService");
    }

    protected void createLookupCallPropertiesGroup(Composite p) {
        Group parent = this.getFieldToolkit().createGroupBox(p, "Lookup Service");
        this.m_serverSourceFolder = this.getFieldToolkit().createSourceFolderField((Composite)parent, "Server Source Folder", ScoutTier.Server, this.getLabelWidth());
        this.m_serverSourceFolder.acceptProposal(this.getServerSourceFolder());
        this.m_serverSourceFolder.addProposalListener(new IProposalListener(){

            @Override
            public void proposalAccepted(Object proposal) {
                LookupCallNewWizardPage.this.setServerSourceFolderInternal((IPackageFragmentRoot)proposal);
                LookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        IType superType = this.calcServiceImplSuperTypeDefault();
        if (S2eUtils.exists((IJavaElement)superType)) {
            this.setServiceImplSuperTypeInternal(superType);
        }
        this.m_lookupServiceSuperTypeField = this.getFieldToolkit().createAbstractTypeProposalField((Composite)parent, "Service Super Class", this.getServerJavaProject(), this.getServiceImplSuperTypeBaseClass(), this.getLabelWidth());
        this.m_lookupServiceSuperTypeField.acceptProposal(this.getServiceImplSuperType());
        this.m_lookupServiceSuperTypeField.setEnabled(S2eUtils.exists((IJavaElement)this.getServerJavaProject()));
        this.m_lookupServiceSuperTypeField.addProposalListener(new IProposalListener(){

            @Override
            public void proposalAccepted(Object proposal) {
                LookupCallNewWizardPage.this.setServiceImplSuperTypeInternal((IType)proposal);
                LookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_keyTypeField = this.getFieldToolkit().createTypeProposalField((Composite)this.getIcuGroupComposite(), "Key Class", this.getJavaProject(), this.getLabelWidth());
        this.m_keyTypeField.addProposalListener(new IProposalListener(){

            @Override
            public void proposalAccepted(Object proposal) {
                LookupCallNewWizardPage.this.setKeyTypeInternal((IType)proposal);
                LookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        GridLayoutFactory.swtDefaults().applyTo((Composite)parent);
        GridDataFactory.defaultsFor((Control)parent).align(4, 0x1000000).grab(true, false).indent(0, 10).applyTo((Control)parent);
        GridDataFactory.defaultsFor((Control)this.m_serverSourceFolder).align(4, 0x1000000).grab(true, false).span(3, 0).applyTo((Control)this.m_serverSourceFolder);
        GridDataFactory.defaultsFor((Control)this.m_lookupServiceSuperTypeField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_lookupServiceSuperTypeField);
        GridDataFactory.defaultsFor((Control)this.m_keyTypeField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_keyTypeField);
        this.syncKeyTypeFieldToSuperType();
    }

    @Override
    protected int getLabelWidth() {
        return 120;
    }

    @Override
    protected void handleSuperTypeChanged() {
        super.handleSuperTypeChanged();
        if (this.isControlCreated()) {
            this.syncKeyTypeFieldToSuperType();
        }
    }

    protected IJavaEnvironment getEnvironment() {
        return this.m_provider.get(this.getJavaProject());
    }

    public IJavaProject getServerJavaProject() {
        return this.getProperty(PROP_SERVER_JAVA_PROJECT, IJavaProject.class);
    }

    protected void setServerJavaProjectInternal(IJavaProject javaProject) {
        if (this.setProperty(PROP_SERVER_JAVA_PROJECT, javaProject)) {
            this.handleServerJavaProjectChanged();
        }
    }

    protected void guessServerFolders() {
        IPackageFragmentRoot sharedSourceFolder = this.getSourceFolder();
        if (!S2eUtils.exists((IJavaElement)sharedSourceFolder)) {
            return;
        }
        try {
            this.setServerSourceFolder(ScoutTier.Shared.convert(ScoutTier.Server, sharedSourceFolder));
        }
        catch (JavaModelException e) {
            SdkLog.info((String)"Unable to calculate server source folder.", (Object[])new Object[]{e});
        }
    }

    protected void handleServerJavaProjectChanged() {
        if (!this.isControlCreated()) {
            return;
        }
        this.m_lookupServiceSuperTypeField.setEnabled(S2eUtils.exists((IJavaElement)this.getServerJavaProject()));
        StrictHierarchyTypeContentProvider superTypeContentProvider = (StrictHierarchyTypeContentProvider)this.m_lookupServiceSuperTypeField.getContentProvider();
        superTypeContentProvider.setJavaProject(this.getServerJavaProject());
        this.m_lookupServiceSuperTypeField.acceptProposal(this.getServiceImplSuperType(), true, true);
        if (this.m_lookupServiceSuperTypeField.getSelectedProposal() == null) {
            this.m_lookupServiceSuperTypeField.acceptProposal(this.calcServiceImplSuperTypeDefault());
        }
    }

    @Override
    protected void handleJavaProjectChanged() {
        super.handleJavaProjectChanged();
        this.guessServerFolders();
        if (!this.isControlCreated()) {
            return;
        }
        ((TypeContentProvider)this.m_keyTypeField.getContentProvider()).setJavaProject(this.getJavaProject());
        this.m_keyTypeField.setEnabled(S2eUtils.exists((IJavaElement)this.getJavaProject()));
    }

    protected void syncKeyTypeFieldToSuperType() {
        IType superType = this.getSuperType();
        if (!S2eUtils.exists((IJavaElement)superType)) {
            this.m_keyTypeField.setEnabled(false);
        } else {
            List typeParameters = S2eUtils.jdtTypeToScoutType((IType)superType, (IJavaEnvironment)this.getEnvironment()).typeParameters();
            boolean typeParamAvailable = typeParameters.size() > 0;
            this.m_keyTypeField.setEnabled(typeParamAvailable);
            if (typeParamAvailable) {
                List bounds = ((ITypeParameter)typeParameters.get(0)).bounds();
                TypeContentProvider typeContentProvider = (TypeContentProvider)this.m_keyTypeField.getContentProvider();
                if (bounds.isEmpty()) {
                    typeContentProvider.setBaseClassFqn(null);
                } else {
                    typeContentProvider.setBaseClassFqn(((org.eclipse.scout.sdk.core.model.api.IType)bounds.get(0)).name());
                }
            }
        }
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        super.validatePage(multiStatus);
        multiStatus.add(this.getStatusServerSourceFolder());
        multiStatus.add(this.getStatusLookupServiceSuperTypeField());
        multiStatus.add(this.getStatusKeyTypeField());
    }

    protected IStatus getStatusServerSourceFolder() {
        if (S2eUtils.exists((IJavaElement)this.getServerSourceFolder()) != S2eUtils.exists((IJavaElement)this.getServiceImplSuperType())) {
            return new Status(2, "org.eclipse.scout.sdk.s2e", "A Lookup Service is only created if a server source folder and a service super class are selected.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusLookupServiceSuperTypeField() {
        org.eclipse.scout.sdk.core.model.api.IType keyType;
        org.eclipse.scout.sdk.core.model.api.IType bound;
        org.eclipse.scout.sdk.core.model.api.IType scoutSuperType;
        List superClassKeyValue;
        IType serviceImplSuperType = this.getServiceImplSuperType();
        if (S2eUtils.exists((IJavaElement)serviceImplSuperType) && S2eUtils.exists((IJavaElement)this.getKeyType()) && !(superClassKeyValue = CoreUtils.getResolvedTypeParamValue((org.eclipse.scout.sdk.core.model.api.IType)(scoutSuperType = S2eUtils.jdtTypeToScoutType((IType)serviceImplSuperType, (IJavaEnvironment)this.m_provider.get(this.getServerJavaProject()))), (String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService", (int)0)).isEmpty() && !"java.lang.Object".equals((bound = (org.eclipse.scout.sdk.core.model.api.IType)superClassKeyValue.get(0)).name()) && !bound.isAssignableFrom(keyType = S2eUtils.jdtTypeToScoutType((IType)this.getKeyType(), (IJavaEnvironment)this.getEnvironment()))) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "The selected service super class cannot be used with the selected key class");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusKeyTypeField() {
        if (!S2eUtils.exists((IJavaElement)this.getKeyType())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose a key class.");
        }
        return Status.OK_STATUS;
    }

    public IType getServiceImplSuperType() {
        return this.getProperty(PROP_SVC_IMPL_SUPER_TYPE, IType.class);
    }

    public void setServiceImplSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setServiceImplSuperTypeInternal(superType);
            if (this.isControlCreated() && this.m_lookupServiceSuperTypeField != null) {
                this.m_lookupServiceSuperTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setServiceImplSuperTypeInternal(IType superType) {
        this.setProperty(PROP_SVC_IMPL_SUPER_TYPE, superType);
    }

    public String getServiceImplSuperTypeBaseClass() {
        return this.getProperty(PROP_SVC_IMPL_SUPER_TYPE_BASE, String.class);
    }

    public void setServiceImplSuperTypeBaseClass(String className) {
        try {
            this.setStateChanging(true);
            this.setServiceImplSuperTypeBaseClassInternal(className);
            if (this.isControlCreated() && this.m_lookupServiceSuperTypeField != null) {
                StrictHierarchyTypeContentProvider superTypeContentProvider = (StrictHierarchyTypeContentProvider)this.m_lookupServiceSuperTypeField.getContentProvider();
                superTypeContentProvider.setBaseClassFqn(className);
                this.m_lookupServiceSuperTypeField.acceptProposal(this.calcServiceImplSuperTypeDefault());
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setServiceImplSuperTypeBaseClassInternal(String className) {
        this.setProperty(PROP_SVC_IMPL_SUPER_TYPE_BASE, className);
    }

    public IPackageFragmentRoot getServerSourceFolder() {
        return this.getProperty(PROP_SERVER_SOURCE_FOLDER, IPackageFragmentRoot.class);
    }

    public void setServerSourceFolder(IPackageFragmentRoot serverSourceFolder) {
        try {
            this.setStateChanging(true);
            this.setServerSourceFolderInternal(serverSourceFolder);
            if (this.isControlCreated() && this.m_serverSourceFolder != null) {
                this.m_serverSourceFolder.acceptProposal(serverSourceFolder);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setServerSourceFolderInternal(IPackageFragmentRoot serverSourceFolder) {
        this.setProperty(PROP_SERVER_SOURCE_FOLDER, serverSourceFolder);
        if (serverSourceFolder != null) {
            this.setServerJavaProjectInternal(serverSourceFolder.getJavaProject());
        } else {
            this.setServerJavaProjectInternal(null);
        }
    }

    public IType getKeyType() {
        return this.getProperty(PROP_KEY_TYPE, IType.class);
    }

    public void setKeyType(IType keyType) {
        try {
            this.setStateChanging(true);
            this.setKeyTypeInternal(keyType);
            if (this.isControlCreated() && this.m_keyTypeField != null) {
                this.m_keyTypeField.acceptProposal(keyType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setKeyTypeInternal(IType keyType) {
        this.setProperty(PROP_KEY_TYPE, keyType);
    }
}

