/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wizard.page;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.sdk.core.util.Filters;
import org.eclipse.scout.sdk.core.util.IFilter;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IProposalListener;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.StrictHierarchyTypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.internal.wizard.page.PageNewWizard;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.wizard.CompilationUnitNewWizardPage;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;

public class PageNewWizardPage
extends CompilationUnitNewWizardPage {
    public static final String PROP_SHARED_SOURCE_FOLDER = "sharedSourceFolder";
    public static final String PROP_SERVER_SOURCE_FOLDER = "serverSourceFolder";
    public static final String PROP_CREATE_ABSTRACT_PAGE = "createAbstractPage";
    protected ProposalTextField m_sharedSourceFolder;
    protected ProposalTextField m_serverSourceFolder;
    private Button m_createAbstractPageButton;
    private boolean m_isPageWithTable;

    public PageNewWizardPage(PackageContainer packageContainer) {
        super(PageNewWizardPage.class.getName(), packageContainer, "TablePage", "org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage", "org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithTable", ScoutTier.Client);
        this.setTitle("Create a new Page");
        this.setDescription(this.getTitle());
        this.setIcuGroupName("New Page Details");
    }

    public PageNewWizard getWizard() {
        return (PageNewWizard)super.getWizard();
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.guessSharedFolders();
        this.createPageServcieGroup(parent);
        this.createOptionsGroup(parent);
        StrictHierarchyTypeContentProvider superTypeContentProvider = (StrictHierarchyTypeContentProvider)this.getSuperTypeField().getContentProvider();
        superTypeContentProvider.setTypeProposalFilter((IFilter<IType>)Filters.and((IFilter[])new IFilter[]{superTypeContentProvider.getTypeProposalFilter(), new IFilter<IType>(){

            public boolean evaluate(IType element) {
                return !"org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPage".equals(element.getFullyQualifiedName());
            }
        }}));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_page_page_context");
    }

    protected void createOptionsGroup(Composite p) {
        Group optionsGroup = this.getFieldToolkit().createGroupBox(p, "Options");
        GridLayoutFactory.swtDefaults().applyTo((Composite)optionsGroup);
        GridDataFactory.defaultsFor((Control)optionsGroup).align(4, 1).applyTo((Control)optionsGroup);
        this.m_createAbstractPageButton = this.getFieldToolkit().createCheckBox((Composite)optionsGroup, "Create an Abstract Super Page", this.isCreateAbstractPage());
        this.m_createAbstractPageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageNewWizardPage.this.setIsCreateAbstractPageInternal(PageNewWizardPage.this.m_createAbstractPageButton.getSelection());
                PageNewWizardPage.this.pingStateChanging();
            }
        });
        GridDataFactory.defaultsFor((Control)this.m_createAbstractPageButton).indent(5, 2).applyTo((Control)this.m_createAbstractPageButton);
    }

    @Override
    protected void handleJavaProjectChanged() {
        super.handleJavaProjectChanged();
        this.guessSharedFolders();
    }

    @Override
    protected void handleSuperTypeChanged() {
        super.handleSuperTypeChanged();
        IType superType = this.getSuperType();
        if (!S2eUtils.exists((IJavaElement)superType)) {
            this.setIsPageWithTable(false);
            return;
        }
        try {
            ITypeHierarchy supertypeHierarchy = superType.newSupertypeHierarchy(null);
            this.setIsPageWithTable(S2eUtils.hierarchyContains((ITypeHierarchy)supertypeHierarchy, (String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable"));
            if (this.isPageWithTable()) {
                this.setReadOnlySuffix("TablePage");
            } else {
                this.setReadOnlySuffix("NodePage");
            }
            if (this.m_serverSourceFolder != null) {
                this.m_serverSourceFolder.setEnabled(this.isPageWithTable());
            }
        }
        catch (JavaModelException e) {
            SdkLog.warning((String)"Unable to calculate super type hierarchy for type '{}'.", (Object[])new Object[]{superType.getFullyQualifiedName(), e});
        }
    }

    protected void guessSharedFolders() {
        IPackageFragmentRoot clientSourceFolder = this.getSourceFolder();
        if (!S2eUtils.exists((IJavaElement)clientSourceFolder)) {
            return;
        }
        try {
            this.setServerSourceFolder(ScoutTier.Client.convert(ScoutTier.Server, clientSourceFolder));
        }
        catch (JavaModelException e) {
            SdkLog.info((String)"Unable to calculate server source folder.", (Object[])new Object[]{e});
        }
        try {
            this.setSharedSourceFolder(ScoutTier.Client.convert(ScoutTier.Shared, clientSourceFolder));
        }
        catch (JavaModelException e) {
            SdkLog.info((String)"Unable to calculate shared source folder.", (Object[])new Object[]{e});
        }
    }

    @Override
    protected int getLabelWidth() {
        return 120;
    }

    protected void createPageServcieGroup(Composite p) {
        Group parent = this.getFieldToolkit().createGroupBox(p, "PageData and Service Source Folders");
        this.m_sharedSourceFolder = this.getFieldToolkit().createSourceFolderField((Composite)parent, "Shared Source Folder", ScoutTier.Shared, this.getLabelWidth());
        this.m_sharedSourceFolder.acceptProposal(this.getSharedSourceFolder());
        this.m_sharedSourceFolder.addProposalListener(new IProposalListener(){

            @Override
            public void proposalAccepted(Object proposal) {
                PageNewWizardPage.this.setSharedSourceFolderInternal((IPackageFragmentRoot)proposal);
                PageNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_serverSourceFolder = this.getFieldToolkit().createSourceFolderField((Composite)parent, "Server Source Folder", ScoutTier.Server, this.getLabelWidth());
        this.m_serverSourceFolder.acceptProposal(this.getServerSourceFolder());
        this.m_serverSourceFolder.setEnabled(this.isPageWithTable());
        this.m_serverSourceFolder.addProposalListener(new IProposalListener(){

            @Override
            public void proposalAccepted(Object proposal) {
                PageNewWizardPage.this.setServerSourceFolderInternal((IPackageFragmentRoot)proposal);
                PageNewWizardPage.this.pingStateChanging();
            }
        });
        GridLayoutFactory.swtDefaults().applyTo((Composite)parent);
        GridDataFactory.defaultsFor((Control)parent).align(4, 0x1000000).grab(true, false).applyTo((Control)parent);
        GridDataFactory.defaultsFor((Control)this.m_sharedSourceFolder).align(4, 0x1000000).grab(true, false).span(3, 0).indent(0, 8).applyTo((Control)this.m_sharedSourceFolder);
        GridDataFactory.defaultsFor((Control)this.m_serverSourceFolder).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_serverSourceFolder);
    }

    public IPackageFragmentRoot getSharedSourceFolder() {
        return this.getProperty(PROP_SHARED_SOURCE_FOLDER, IPackageFragmentRoot.class);
    }

    public void setSharedSourceFolder(IPackageFragmentRoot sharedSourceFolder) {
        try {
            this.setStateChanging(true);
            this.setSharedSourceFolderInternal(sharedSourceFolder);
            if (this.isControlCreated() && this.m_sharedSourceFolder != null) {
                this.m_sharedSourceFolder.acceptProposal(sharedSourceFolder);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setSharedSourceFolderInternal(IPackageFragmentRoot sharedSourceFolder) {
        this.setProperty(PROP_SHARED_SOURCE_FOLDER, sharedSourceFolder);
    }

    public IPackageFragmentRoot getServerSourceFolder() {
        return this.getProperty(PROP_SERVER_SOURCE_FOLDER, IPackageFragmentRoot.class);
    }

    public void setServerSourceFolder(IPackageFragmentRoot serverSourceFolder) {
        try {
            this.setStateChanging(true);
            this.setServerSourceFolderInternal(serverSourceFolder);
            if (this.isControlCreated() && this.m_serverSourceFolder != null) {
                this.m_serverSourceFolder.acceptProposal(serverSourceFolder);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setServerSourceFolderInternal(IPackageFragmentRoot serverSourceFolder) {
        this.setProperty(PROP_SERVER_SOURCE_FOLDER, serverSourceFolder);
    }

    public boolean isCreateAbstractPage() {
        Boolean val = this.getProperty(PROP_CREATE_ABSTRACT_PAGE, Boolean.class);
        return val != null && val != false;
    }

    public void setIsCreateAbstractPage(boolean createAbstractPage) {
        try {
            this.setStateChanging(true);
            this.setIsCreateAbstractPageInternal(createAbstractPage);
            if (this.isControlCreated() && this.m_createAbstractPageButton != null) {
                this.m_createAbstractPageButton.setSelection(createAbstractPage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setIsCreateAbstractPageInternal(boolean createAbstractPage) {
        this.setProperty(PROP_CREATE_ABSTRACT_PAGE, createAbstractPage);
    }

    protected boolean isPageWithTable() {
        return this.m_isPageWithTable;
    }

    protected void setIsPageWithTable(boolean isPageWithTable) {
        this.m_isPageWithTable = isPageWithTable;
    }
}

