/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.wizard;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scout.sdk.core.util.BasicPropertySupport;
import org.eclipse.scout.sdk.s2e.ui.fields.FieldToolkit;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractWizardPage
extends WizardPage {
    private IStatus m_status = Status.OK_STATUS;
    private Composite m_content;
    private int m_stateChangingCounter = 0;
    private boolean m_excludePage;
    private final FieldToolkit m_fieldToolkit = new FieldToolkit();
    private final BasicPropertySupport m_propertySupport = new BasicPropertySupport((Object)this);

    public AbstractWizardPage(String pageName) {
        super(pageName, null, null);
    }

    public FieldToolkit getFieldToolkit() {
        return this.m_fieldToolkit;
    }

    public final void createControl(Composite parent) {
        this.m_content = new Composite(parent, 0);
        this.m_content.setLayout((Layout)new FillLayout());
        this.createContent(this.m_content);
        this.setControl((Control)this.m_content);
        this.revalidate();
    }

    protected boolean isControlCreated() {
        return super.isControlCreated() && !this.getControl().isDisposed();
    }

    protected abstract void createContent(Composite var1);

    public Composite getControl() {
        return this.m_content;
    }

    public void setVisible(boolean visible) {
        this.m_content.setVisible(visible);
    }

    protected void setStatus(IStatus status) {
        if (status == null) {
            status = Status.OK_STATUS;
        }
        if (status.isOK()) {
            this.setMessage(this.getDescription(), 0);
        } else {
            int messagetype;
            IStatus highestSeverityStatus = this.getHighestSeverityStatus(status, Status.OK_STATUS);
            switch (highestSeverityStatus.getSeverity()) {
                case 1: {
                    messagetype = 1;
                    break;
                }
                case 2: {
                    messagetype = 2;
                    break;
                }
                case 4: {
                    messagetype = 3;
                    break;
                }
                default: {
                    messagetype = 0;
                }
            }
            String message = highestSeverityStatus.getMessage();
            this.setMessage(message, messagetype);
        }
        this.setPageComplete(!status.matches(4));
        this.m_status = status;
    }

    private IStatus getHighestSeverityStatus(IStatus status, IStatus highestSeverity) {
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                highestSeverity = this.getHighestSeverityStatus(child, highestSeverity);
                ++n2;
            }
            return highestSeverity;
        }
        if (highestSeverity.getSeverity() < status.getSeverity()) {
            highestSeverity = status;
        }
        return highestSeverity;
    }

    public void pingStateChanging() {
        if (this.m_stateChangingCounter <= 0) {
            this.m_stateChangingCounter = 0;
            this.revalidate();
        }
    }

    protected void setStateChanging(boolean changing) {
        this.m_stateChangingCounter = changing ? ++this.m_stateChangingCounter : --this.m_stateChangingCounter;
        this.pingStateChanging();
    }

    protected boolean isStateChanging() {
        return this.m_stateChangingCounter > 0;
    }

    protected final void revalidate() {
        this.setStatus((IStatus)this.computePageStatus());
    }

    protected final MultiStatus computePageStatus() {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.scout.sdk.s2e.ui", -1, "multi status", null);
        this.validatePage(multiStatus);
        return multiStatus;
    }

    protected void validatePage(MultiStatus multiStatus) {
    }

    public boolean performFinish() {
        return true;
    }

    protected IStatus getStatus() {
        return this.m_status;
    }

    public void setExcludePage(boolean excludePage) {
        this.m_excludePage = excludePage;
    }

    public boolean isExcludePage() {
        return this.m_excludePage;
    }

    public <T> T getProperty(String key, Class<T> type) {
        return (T)this.m_propertySupport.getProperty(key);
    }

    public boolean getPropertyBool(String name) {
        return this.m_propertySupport.getPropertyBool(name);
    }

    public double getPropertyDouble(String name) {
        return this.m_propertySupport.getPropertyDouble(name);
    }

    public int getPropertyInt(String name) {
        return this.m_propertySupport.getPropertyInt(name);
    }

    public long getPropertyLong(String name) {
        return this.m_propertySupport.getPropertyLong(name);
    }

    public String getPropertyString(String name) {
        return this.m_propertySupport.getPropertyString(name);
    }

    public boolean setProperty(String name, Object newValue) {
        return this.m_propertySupport.setProperty(name, newValue);
    }

    public boolean setPropertyBool(String name, boolean b) {
        return this.m_propertySupport.setPropertyBool(name, b);
    }

    public boolean setPropertyDouble(String name, double d) {
        return this.m_propertySupport.setPropertyDouble(name, d);
    }

    public boolean setPropertyInt(String name, int i) {
        return this.m_propertySupport.setPropertyInt(name, i);
    }

    public boolean setPropertyLong(String name, long i) {
        return this.m_propertySupport.setPropertyLong(name, i);
    }

    public boolean setPropertyString(String name, String s) {
        return this.m_propertySupport.setPropertyString(name, s);
    }
}

