/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.backward;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.framework.DevicePlugin;
import org.eclipse.sequoyah.device.framework.factory.InstanceRegistry;
import org.eclipse.sequoyah.device.framework.manager.persistence.DeviceXmlReader;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DeviceBackwardPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "org.eclipse.sequoyah.device.backward";
    private static DeviceBackwardPlugin plugin;
    private final String PROJECT_NAME = "sequoyah";
    private final String OLD_PROJECT_NAME = "tml";
    private final String DEVICE_XML_INFO_SUFFIX = ".info";
    private final String BACKWARD_MARK = "backward";
    private final String OLD_DEVICE_PLUGIN_ID = "org.eclipse.tml.framework.device";
    File deviceXmlLocation = DevicePlugin.getDeviceXmlLocation();
    File deviceXmlFile = new File(String.valueOf(this.deviceXmlLocation.getAbsolutePath()) + File.separator + DevicePlugin.getDeviceXmlFileName());
    File oldDeviceXmlFile = null;
    File oldDeviceXmlFileInfo = null;

    public DeviceBackwardPlugin() {
        String string = this.deviceXmlFile.getAbsolutePath().replaceAll("org.eclipse.sequoyah.device.framework", "org.eclipse.tml.framework.device").replaceAll("sequoyah", "tml");
        this.oldDeviceXmlFile = new File(string);
        this.oldDeviceXmlFileInfo = new File(String.valueOf(string) + ".info");
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        if (!this.getBackwardStatus()) {
            this.moveDeviceInstancesData();
        }
        if (this.isUsingOldHomeFile()) {
            this.moveDeviceInstancesLocation();
        }
    }

    private void moveDeviceInstancesLocation() {
        String[] stringArray;
        File file;
        File file2 = DevicePlugin.XML_LocationOption.USER_HOME.getLocation();
        if (file2.renameTo(file = DevicePlugin.XML_LocationOption.NEW_USER_HOME.getLocation())) {
            DevicePlugin.setDeviceXmlLocation((DevicePlugin.XML_LocationOption)DevicePlugin.XML_LocationOption.NEW_USER_HOME);
            if ("win32".equals(Platform.getOS())) {
                stringArray = new String[]{"attrib", "+H", file.getAbsolutePath()};
                try {
                    Runtime.getRuntime().exec(stringArray);
                }
                catch (IOException iOException) {
                    BasePlugin.logError((String)"Unable to hide Sequoyah's configuration directory");
                }
            }
            InstanceRegistry.getInstance().reload();
        }
        if ((stringArray = file2.getParentFile()).list().length == 0) {
            stringArray.delete();
        }
    }

    private boolean isUsingOldHomeFile() {
        return DevicePlugin.XML_LocationOption.USER_HOME.getLocation().exists() && !DevicePlugin.XML_LocationOption.NEW_USER_HOME.getLocation().exists();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static DeviceBackwardPlugin getDefault() {
        return plugin;
    }

    private boolean getBackwardStatus() {
        boolean bl = false;
        try {
            if (this.oldDeviceXmlFileInfo.exists()) {
                String string;
                FileReader fileReader = new FileReader(this.oldDeviceXmlFileInfo);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.startsWith("backward")) continue;
                    bl = true;
                }
                fileReader.close();
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            BasePlugin.logError((String)"Could not get TmL devices backward status");
        }
        return bl;
    }

    private void addBackwardStatus() {
        try {
            FileWriter fileWriter = new FileWriter(this.oldDeviceXmlFileInfo);
            fileWriter.write("backward=" + new Date().toString());
            fileWriter.close();
        }
        catch (IOException iOException) {
            BasePlugin.logError((String)"Could not set TmL devices backward status");
        }
    }

    private void moveDeviceInstancesData() {
        if (this.oldDeviceXmlFile.exists()) {
            try {
                Collection collection = DeviceXmlReader.loadInstances((File)this.oldDeviceXmlFile);
                InstanceRegistry instanceRegistry = InstanceRegistry.getInstance();
                for (IInstance iInstance : collection) {
                    if (instanceRegistry.getInstancesByName(iInstance.getName()).size() != 0) continue;
                    instanceRegistry.addInstance(iInstance);
                }
                this.addBackwardStatus();
            }
            catch (Exception exception) {
                BasePlugin.logError((String)"Could not recover TmL devices");
            }
        }
    }

    public void earlyStartup() {
    }
}

