/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.model.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.editor.model.StringEditorPart;
import org.eclipse.sequoyah.localization.editor.model.operations.AddKeyOperation;
import org.eclipse.sequoyah.localization.editor.model.operations.EditorOperation;

public class AddKeysOperation
extends EditorOperation {
    private List<AddKeyOperation> addKeyOperations = new ArrayList<AddKeyOperation>();

    public AddKeysOperation(String string, StringEditorPart stringEditorPart, RowInfo[] rowInfoArray) {
        super(string, stringEditorPart);
        int n = 0;
        while (n < rowInfoArray.length) {
            this.addKeyOperations.add(n, new AddKeyOperation(string, stringEditorPart, rowInfoArray[n], false));
            ++n;
        }
    }

    public IStatus execute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        this.redo(iProgressMonitor, iAdaptable);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        int n = 0;
        while (n < this.addKeyOperations.size()) {
            this.addKeyOperations.get(n).execute(iProgressMonitor, iAdaptable);
            ++n;
        }
        this.getEditor().refresh();
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        int n = this.addKeyOperations.size();
        while (n > 0) {
            this.addKeyOperations.get(n - 1).undo(iProgressMonitor, iAdaptable);
            --n;
        }
        this.getEditor().refresh();
        return Status.OK_STATUS;
    }
}

