/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.datamodel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFileBean;

public class LocalizationFileFactory {
    private static volatile LocalizationFileFactory localizationFileFactory;
    private HashMap<String, Class> hashMap = new HashMap();

    public void addFileType(String string, Class clazz) {
        this.hashMap.put(string, clazz);
    }

    private LocalizationFileFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalizationFileFactory getInstance() {
        if (localizationFileFactory != null) return localizationFileFactory;
        Class<LocalizationFileFactory> clazz = LocalizationFileFactory.class;
        synchronized (LocalizationFileFactory.class) {
            if (localizationFileFactory != null) return localizationFileFactory;
            localizationFileFactory = new LocalizationFileFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return localizationFileFactory;
        }
    }

    public LocalizationFile createLocalizationFile(LocalizationFileBean localizationFileBean) {
        LocalizationFile localizationFile = null;
        try {
            Class.forName(localizationFileBean.getType());
            Class<?> clazz = Class.forName(this.hashMap.get(localizationFileBean.getType()).toString().substring(6));
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("create", LocalizationFileBean.class);
            localizationFile = (LocalizationFile)method.invoke(obj, localizationFileBean);
        }
        catch (ClassNotFoundException classNotFoundException) {
            BasePlugin.logError((String)"Could not find class for LocalizationFile", (Throwable)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            BasePlugin.logError((String)"Could not instantiate class for LocalizationFile", (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            BasePlugin.logError((String)"Could not access class or method for LocalizationFile", (Throwable)illegalAccessException);
        }
        catch (SecurityException securityException) {
            BasePlugin.logError((String)"Access to method denied", (Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            BasePlugin.logError((String)"Could not find method for LocalizationFile", (Throwable)noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BasePlugin.logError((String)"Invalid arguments for method for LocalizationFile", (Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            BasePlugin.logError((String)"Could not call method for LocalizationFile", (Throwable)invocationTargetException);
        }
        return localizationFile;
    }
}

