/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.protocol.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sequoyah.vnc.protocol.lib.IMessageFieldsStore;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFieldsStore
implements IMessageFieldsStore {
    private static final String INTERNAL_SEPARATOR = "$$";
    protected Map<String, Object> messageFieldsValues = new HashMap<String, Object>();
    protected Map<String, Integer> messageFieldsSizes = new HashMap<String, Integer>();
    private String iteratableBlockId;
    private int index;

    public MessageFieldsStore() {
        this.iteratableBlockId = null;
        this.index = -1;
    }

    public MessageFieldsStore(ProtocolMessage protocolMessage, String string, int n) {
        if (protocolMessage != null) {
            this.iteratableBlockId = string;
            this.index = n;
            for (String string2 : protocolMessage.getAllFieldNames()) {
                this.messageFieldsValues.put(string2, protocolMessage.getFieldValue(string2));
            }
        } else {
            this.iteratableBlockId = null;
            this.index = -1;
        }
    }

    @Override
    public Collection<String> getAllFieldNames() {
        return this.messageFieldsValues.keySet();
    }

    @Override
    public Object getFieldValue(String string) {
        Object object = null;
        if (this.iteratableBlockId != null && this.index >= 0) {
            object = this.messageFieldsValues.get(this.generateKey(string, this.iteratableBlockId, this.index));
        }
        if (object == null || this.iteratableBlockId == null || this.index < 0) {
            object = this.messageFieldsValues.get(string);
        }
        return object;
    }

    @Override
    public Object getFieldValue(String string, String string2, int n) {
        Object object = null;
        object = string2 != null && n >= 0 ? this.messageFieldsValues.get(this.generateKey(string, string2, n)) : this.messageFieldsValues.get(string);
        return object;
    }

    protected String generateKey(String string, String string2, int n) {
        return String.valueOf(string2) + INTERNAL_SEPARATOR + string + INTERNAL_SEPARATOR + n;
    }

    protected String getIteratableBlockId() {
        return this.iteratableBlockId;
    }

    protected int getIndex() {
        return this.index;
    }

    @Override
    public Integer getFieldSize(String string) {
        Integer n = null;
        if (this.iteratableBlockId != null && this.index >= 0) {
            n = this.messageFieldsSizes.get(this.generateKey(string, this.iteratableBlockId, this.index));
        }
        if (n == null || this.iteratableBlockId == null || this.index < 0) {
            n = this.messageFieldsSizes.get(string);
        }
        return n;
    }

    @Override
    public Integer getFieldSize(String string, String string2, int n) {
        Integer n2 = null;
        n2 = string2 != null && n >= 0 ? this.messageFieldsSizes.get(this.generateKey(string, string2, n)) : this.messageFieldsSizes.get(string);
        return n2;
    }
}

