/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.utilities.logger;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sequoyah.vnc.utilities.logger.ILogger;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public final class SimpleLogger
implements ILogger {
    private static SimpleLogger logLogger;
    private static final Map<String, String> levelsMap;

    static {
        levelsMap = new HashMap<String, String>();
        levelsMap.put("DEBUG", "[DEBUG]");
        levelsMap.put("INFO", "[INFO]");
        levelsMap.put("WARN", "[WARN]");
        levelsMap.put("ERROR", "[ERROR]");
        levelsMap.put("FATAL", "[FATAL]");
        levelsMap.put("ALL", "[LOG]");
    }

    private SimpleLogger() {
        MessageConsole messageConsole = new MessageConsole("System Output", null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)messageConsole);
        MessageConsoleStream messageConsoleStream = messageConsole.newMessageStream();
        System.setOut(new PrintStream((OutputStream)messageConsoleStream));
        System.setErr(new PrintStream((OutputStream)messageConsoleStream));
    }

    private void configureLogView(int n) {
        switch (n) {
            case 1: {
                this.setAppenderConsole();
                break;
            }
            default: {
                String string = Integer.toString(n);
                throw new IllegalArgumentException(string);
            }
        }
    }

    public void configureLogger(Object object) {
        this.configureLogView(1);
    }

    public void debug(Object object) {
        System.out.println("[DEBUG]" + object);
    }

    public void error(Object object) {
        System.out.println("[ERROR]" + object);
    }

    public void error(Object object, Object object2) {
        System.out.println("[ERROR]" + object + "-" + ((Throwable)object2).getMessage());
    }

    public void fatal(Object object) {
        System.out.println("[FATAL]" + object);
    }

    public Object getCurrentLevel() {
        return "[LOG]";
    }

    public static SimpleLogger getInstance() {
        if (logLogger == null) {
            logLogger = new SimpleLogger();
        }
        return logLogger;
    }

    public void info(Object object) {
        System.out.println("[INFO]" + object);
    }

    public void log(Object object, Object object2, Object object3) {
        System.out.println(String.valueOf(levelsMap.get(object)) + object2 + "-" + ((Throwable)object3).getMessage());
    }

    public void log(Object object) {
        System.out.println("[LOG]" + ((Throwable)object).getMessage());
    }

    public void log(Object object, Object object2) {
        System.out.println(String.valueOf(levelsMap.get(object)) + object2);
    }

    private void setAppenderConsole() {
    }

    private void setAppenderFile() {
    }

    private void setAppenderHTML() {
    }

    public void setLevel(Object object) {
    }

    public void setLogToConsole() {
    }

    public void setLogToFile(String string) {
    }

    public void setLogToFile(String string, String string2) {
    }

    public void setLogToHTMLFile(String string) {
    }

    public void warn(Object object) {
        System.out.println("[WARN]" + object);
    }
}

