/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.vncviewer.network;

import java.io.DataInput;
import java.io.IOException;
import org.eclipse.sequoyah.vnc.utilities.logger.Logger;
import org.eclipse.sequoyah.vnc.vncviewer.exceptions.ProtoClientException;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.HexTilePaintStrategy;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.IPaintStrategy;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.IPainterContext;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.RREPaintStrategy;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.RawPaintStrategy;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.ZRLEPaintStrategy;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.ZlibPaintStrategy;
import org.eclipse.sequoyah.vnc.vncviewer.network.IVNCPainter;
import org.eclipse.sequoyah.vnc.vncviewer.network.PixelFormat;
import org.eclipse.sequoyah.vnc.vncviewer.network.RectHeader;
import org.eclipse.sequoyah.vnc.vncviewer.network.VNCProtocol;

public abstract class AbstractVNCPainter
implements IVNCPainter {
    protected PixelFormat pixelFormat;
    protected int bytesPerPixel;
    private int width;
    private int height;
    private IPaintStrategy rawPaintStrategy;
    private IPaintStrategy rrePaintStrategy;
    private IPaintStrategy hexTilePaintStrategy;
    private IPaintStrategy zlibPaintStrategy;
    private IPaintStrategy zrlePaintStrategy;

    public AbstractVNCPainter() {
        IPainterContext iPainterContext = this.getPainterContext();
        this.rawPaintStrategy = new RawPaintStrategy(iPainterContext);
        this.rrePaintStrategy = new RREPaintStrategy(iPainterContext);
        this.hexTilePaintStrategy = new HexTilePaintStrategy(iPainterContext);
        this.zlibPaintStrategy = new ZlibPaintStrategy(iPainterContext);
        this.zrlePaintStrategy = new ZRLEPaintStrategy(iPainterContext);
    }

    public int[] getSupportedEncodings() {
        int[] nArray = new int[5];
        nArray[0] = 5;
        nArray[1] = 16;
        nArray[2] = 6;
        nArray[3] = 2;
        return nArray;
    }

    public static int[] getSupportedEncodingsStatic() {
        int[] nArray = new int[5];
        nArray[0] = 5;
        nArray[1] = 16;
        nArray[2] = 6;
        nArray[3] = 2;
        return nArray;
    }

    public void processRectangle(RectHeader rectHeader, DataInput dataInput) throws Exception {
        IPaintStrategy iPaintStrategy = this.getPaintStrategy(rectHeader.getEncoding());
        if (iPaintStrategy != null) {
            iPaintStrategy.processRectangle(rectHeader, dataInput);
        } else {
            Logger.log(AbstractVNCPainter.class).error("This encoding is not supported.");
        }
    }

    public PixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    public void setPixelFormat(PixelFormat pixelFormat) {
        this.pixelFormat = pixelFormat;
        this.bytesPerPixel = pixelFormat.getBitsPerPixel() / 8;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    private byte[] readpixelsbytes(DataInput dataInput, int n) throws ProtoClientException {
        byte[] byArray = new byte[n];
        try {
            dataInput.readFully(byArray, 0, n);
        }
        catch (IOException iOException) {
            Logger.log(VNCProtocol.class).error("Rectangle message error: " + iOException.getMessage());
            throw new ProtoClientException("Rectangle message error.");
        }
        return byArray;
    }

    public int[] readPixels(DataInput dataInput, int n, int n2) throws Exception {
        byte[] byArray = new byte[1];
        int[] nArray = new int[n * n2];
        int n3 = n * n2;
        int n4 = n3 * (this.pixelFormat.getBitsPerPixel() / 8);
        byArray = this.readpixelsbytes(dataInput, n4);
        int n5 = 0;
        while (n5 < n3) {
            int n6;
            boolean bl;
            int n7 = n5 * this.bytesPerPixel;
            int n8 = 0;
            boolean bl2 = bl = this.pixelFormat.getBigEndianFlag() != 0;
            if (bl) {
                n6 = 0;
                while (n6 < this.bytesPerPixel) {
                    n8 = n8 << 8 | byArray[n7 + n6] & 0xFF;
                    ++n6;
                }
            } else {
                n6 = this.bytesPerPixel - 1;
                while (n6 >= 0) {
                    n8 = n8 << 8 | byArray[n7 + n6] & 0xFF;
                    --n6;
                }
            }
            nArray[n5] = n8;
            ++n5;
        }
        return nArray;
    }

    protected int readPixel(DataInput dataInput, int n) throws Exception {
        int n2 = 0;
        if (n == 1) {
            n2 = dataInput.readByte() & 0xFF;
        } else {
            boolean bl;
            boolean bl2 = bl = this.pixelFormat.getBigEndianFlag() != 0;
            if (bl) {
                int n3 = 0;
                while (n3 < n) {
                    int n4 = dataInput.readUnsignedByte();
                    n2 = n2 << 8 | n4 & 0xFF;
                    ++n3;
                }
            } else {
                int n5 = 0;
                while (n5 < n) {
                    int n6 = dataInput.readUnsignedByte();
                    n2 |= (n6 & 0xFF) << n5 * 8;
                    ++n5;
                }
            }
        }
        return n2;
    }

    protected int readPixel(DataInput dataInput) throws Exception {
        return this.readPixel(dataInput, this.bytesPerPixel);
    }

    protected abstract IPainterContext getPainterContext();

    protected IPaintStrategy getPaintStrategy(int n) {
        switch (n) {
            case 0: {
                return this.rawPaintStrategy;
            }
            case 2: {
                return this.rrePaintStrategy;
            }
            case 5: {
                return this.hexTilePaintStrategy;
            }
            case 6: {
                return this.zlibPaintStrategy;
            }
            case 16: {
                return this.zrlePaintStrategy;
            }
        }
        return null;
    }
}

