/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.PropertyHandlerEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.internal.requests.ApplyAppearancePropertiesRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangePropertyValueRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.internal.refresh.diagram.ViewPropertiesSynchronizer;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.sirius.viewpoint.description.FixedColor;
import org.eclipse.sirius.viewpoint.description.UserFixedColor;
import org.eclipse.swt.graphics.RGB;

public class SiriusPropertyHandlerEditPolicy
extends PropertyHandlerEditPolicy {
    public Command getCommand(Request request) {
        Command c = super.getCommand(request);
        Command styleCommand = null;
        if (request.getType().equals("property_change")) {
            styleCommand = this.buildPropertyChangeCommand(request);
        } else if (request instanceof ApplyAppearancePropertiesRequest) {
            styleCommand = this.buildApplyAppearancePropertiesCommand((ApplyAppearancePropertiesRequest)request);
        }
        if (styleCommand != null) {
            CompoundCommand cc = new CompoundCommand();
            cc.setDebugLabel(Messages.SiriusPropertyHandlerEditPolicy_chainedStyleCommandDebugLabel);
            cc.add(c);
            cc.add(styleCommand);
            return cc;
        }
        return c;
    }

    private Command buildApplyAppearancePropertiesCommand(ApplyAppearancePropertiesRequest request) {
        View viewToCopy;
        View targetView;
        DStylizable styleReceiver = null;
        Style styleToCopy = null;
        if (this.getHost() instanceof IGraphicalEditPart && (targetView = ((IGraphicalEditPart)this.getHost()).getNotationView()).getElement() instanceof DStylizable) {
            styleReceiver = (DStylizable)targetView.getElement();
        }
        if ((viewToCopy = request.getViewToCopyFrom()).getElement() instanceof DStylizable) {
            styleToCopy = (Style)EcoreUtil.copy((EObject)((DStylizable)viewToCopy.getElement()).getStyle());
        }
        AbstractTransactionalCommand viewStyleCommand = null;
        if (styleReceiver instanceof DEdge && styleToCopy instanceof EdgeStyle) {
            final DEdge edge = (DEdge)styleReceiver;
            final EdgeStyle edgeStyle = (EdgeStyle)styleToCopy;
            viewStyleCommand = new AbstractTransactionalCommand(this.getEditingDomain(), Messages.SiriusPropertyHandlerEditPolicy_applyAppearancePropertiesCommandLabel, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    edge.setOwnedStyle(edgeStyle);
                    return CommandResult.newOKCommandResult();
                }
            };
        } else if (styleReceiver instanceof DNode && styleToCopy instanceof NodeStyle) {
            final DNode node = (DNode)styleReceiver;
            final NodeStyle nodeStyle = (NodeStyle)styleToCopy;
            viewStyleCommand = new AbstractTransactionalCommand(this.getEditingDomain(), Messages.SiriusPropertyHandlerEditPolicy_applyAppearancePropertiesCommandLabel, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    node.setOwnedStyle(nodeStyle);
                    return CommandResult.newOKCommandResult();
                }
            };
        } else if (styleReceiver instanceof DDiagramElementContainer && styleToCopy instanceof ContainerStyle) {
            final DDiagramElementContainer container = (DDiagramElementContainer)styleReceiver;
            final ContainerStyle containerStyle = (ContainerStyle)styleToCopy;
            viewStyleCommand = new AbstractTransactionalCommand(this.getEditingDomain(), Messages.SiriusPropertyHandlerEditPolicy_applyAppearancePropertiesCommandLabel, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    container.setOwnedStyle(containerStyle);
                    return CommandResult.newOKCommandResult();
                }
            };
        }
        if (viewStyleCommand == null) {
            return null;
        }
        return new ICommandProxy(viewStyleCommand);
    }

    private Command buildPropertyChangeCommand(Request request) {
        Command propertyChangeCommand = null;
        EditPart ep = this.getHost();
        if (ep instanceof IGraphicalEditPart) {
            View view = ((IGraphicalEditPart)ep).getNotationView();
            ChangePropertyValueRequest cpvr = (ChangePropertyValueRequest)request;
            if (Properties.ID_FILLCOLOR.equals(cpvr.getPropertyID()) || Properties.ID_LINECOLOR.equals(cpvr.getPropertyID()) || Properties.ID_FONTCOLOR.equals(cpvr.getPropertyID())) {
                propertyChangeCommand = this.buildColorPropertyChangeCommand(view, cpvr, ep);
            }
        }
        return propertyChangeCommand;
    }

    private Command buildColorPropertyChangeCommand(final View view, final ChangePropertyValueRequest cpvr, EditPart ep) {
        if (view != null && ViewUtil.isPropertySupported((View)view, (Object)cpvr.getPropertyID()) && ep instanceof IDiagramElementEditPart) {
            AbstractTransactionalCommand colorCommand = new AbstractTransactionalCommand(this.getEditingDomain(), Messages.SiriusPropertyHandlerEditPolicy_applyTabbarPropertiesCommandLabel, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    if (cpvr.getValue() instanceof Integer) {
                        RGB finalColor = FigureUtilities.integerToRGB((Integer)((Integer)cpvr.getValue()));
                        UserFixedColor newColor = DescriptionFactory.eINSTANCE.createUserFixedColor();
                        newColor.setName(Messages.AnonymousUserFixedColorName);
                        newColor.setBlue(finalColor.blue);
                        newColor.setGreen(finalColor.green);
                        newColor.setRed(finalColor.red);
                        IInterpreter interpreter = new EObjectQuery((EObject)view).getSession().getInterpreter();
                        new ViewPropertiesSynchronizer().synchronizeDDiagramElementStyleColorProperties(view, (FixedColor)newColor, cpvr.getPropertyID(), interpreter);
                    }
                    return CommandResult.newOKCommandResult();
                }
            };
            return new ICommandProxy((ICommand)colorCommand);
        }
        return null;
    }
}

