/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.sirius.common.ui.tools.api.dialog.FeatureEditorDialog;
import org.eclipse.sirius.editor.properties.sections.common.AbstractEditorDialogPropertySection;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.featureExtensions.FeatureExtensionsUIManager;
import org.eclipse.sirius.ui.business.internal.dialect.HierarchyLabelProvider;
import org.eclipse.sirius.viewpoint.provider.ViewpointItemProviderAdapterFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public abstract class AbstractEditorDialogWithListPropertySection
extends AbstractEditorDialogPropertySection {
    @Override
    protected SelectionListener createButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureEditorDialog dialog = new FeatureEditorDialog(AbstractEditorDialogWithListPropertySection.this.composite.getShell(), AbstractEditorDialogWithListPropertySection.this.getLabelProvider(), (Object)AbstractEditorDialogWithListPropertySection.this.eObject, (EClassifier)AbstractEditorDialogWithListPropertySection.this.eObject.eClass(), AbstractEditorDialogWithListPropertySection.this.getCurrentValue(), AbstractEditorDialogWithListPropertySection.this.getDefaultLabelText(), AbstractEditorDialogWithListPropertySection.this.getChoiceOfValues(), false, AbstractEditorDialogWithListPropertySection.this.getSortChoice(), AbstractEditorDialogWithListPropertySection.this.getChoiceOfValues() != null);
                dialog.open();
                EList result = dialog.getResult();
                if (result != null) {
                    AbstractEditorDialogWithListPropertySection.this.handleFeatureModified((List)result);
                }
            }
        };
    }

    protected abstract List getCurrentValue();

    protected abstract boolean getSortChoice();

    private AdapterFactory getAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(DialectUIManager.INSTANCE.createAdapterFactory());
        factories.add(FeatureExtensionsUIManager.INSTANCE.createAdapterFactory());
        factories.add(new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        factories.add(new ViewpointItemProviderAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }

    protected ILabelProvider getLabelProvider() {
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider(this.getAdapterFactory());
        return new HierarchyLabelProvider((ILabelProvider)labelProvider);
    }

    protected EReference getFeature() {
        return null;
    }

    @Override
    protected String getFeatureAsText() {
        StringBuilder sb = new StringBuilder();
        if (this.getCurrentValue() != null) {
            List values = this.getCurrentValue();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                EObject eObj = (EObject)iterator.next();
                sb.append(this.getAdapterFactoryLabelProvider(eObj).getText((Object)eObj));
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    protected boolean isEqual(List newList) {
        return newList.equals(this.getCurrentValue());
    }
}

