/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.interpreter.api.EvaluationResult;
import org.eclipse.sirius.common.interpreter.api.IEvaluationResult;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterWithDiagnostic;
import org.eclipse.sirius.tools.internal.interpreter.ODesignGenericInterpreter;
import org.eclipse.sirius.ui.properties.internal.SiriusToolServices;

public class SiriusInterpreter
implements org.eclipse.sirius.common.interpreter.api.IInterpreter {
    private IInterpreterWithDiagnostic interpreter;

    public SiriusInterpreter(Session session) {
        this((IInterpreterWithDiagnostic)session.getInterpreter());
    }

    public SiriusInterpreter(IInterpreterWithDiagnostic interpreterWithDiagnostic) {
        this.interpreter = (IInterpreterWithDiagnostic)Preconditions.checkNotNull((Object)interpreterWithDiagnostic);
    }

    public IEvaluationResult evaluateExpression(Map<String, Object> variables, String expr) {
        EvaluationResult result = EvaluationResult.noEvaluation();
        Object self = variables.get("self");
        if (self instanceof EObject) {
            try {
                try {
                    this.setupInterpreter(variables);
                    IInterpreterWithDiagnostic.IEvaluationResult evaluationResult = this.interpreter.evaluateExpression((EObject)self, expr);
                    result = EvaluationResult.of((Object)evaluationResult.getValue(), (Diagnostic)evaluationResult.getDiagnostic());
                }
                catch (EvaluationException e) {
                    result = EvaluationResult.withError((Diagnostic)BasicDiagnostic.toDiagnostic((Throwable)e));
                    this.tearDownInterpreter(variables);
                }
            }
            finally {
                this.tearDownInterpreter(variables);
            }
        }
        return result;
    }

    private void setupInterpreter(Map<String, Object> variables) {
        if (this.interpreter instanceof IInterpreter) {
            Object current;
            IInterpreter i = (IInterpreter)this.interpreter;
            Collection filesProperty = Lists.newArrayList();
            if (i instanceof ODesignGenericInterpreter && (current = ((ODesignGenericInterpreter)i).getProperty((Object)"files")) instanceof Collection) {
                filesProperty = (Collection)current;
            }
            if (!filesProperty.contains("org.eclipse.sirius.ui.properties")) {
                filesProperty.add("org.eclipse.sirius.ui.properties");
            }
            i.setProperty((Object)"files", (Object)filesProperty);
            i.addImport(SiriusToolServices.class.getName());
            this.declareLocals(variables, i);
        }
    }

    private void declareLocals(Map<String, Object> variables, IInterpreter i) {
        Set<Map.Entry<String, Object>> entries = variables.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            i.setVariable(entry.getKey(), entry.getValue());
        }
    }

    private void tearDownInterpreter(Map<String, Object> variables) {
        if (this.interpreter instanceof IInterpreter) {
            IInterpreter i = (IInterpreter)this.interpreter;
            i.removeImport(SiriusToolServices.class.getName());
            this.unsetLocals(variables, i);
        }
    }

    private void unsetLocals(Map<String, Object> variables, IInterpreter i) {
        Set<Map.Entry<String, Object>> entries = variables.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            i.unSetVariable(entry.getKey());
        }
    }
}

