/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.emf.edit.EditingDomainServices;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.ui.properties.internal.SiriusContext;
import org.eclipse.sirius.ui.properties.internal.SiriusInputDescriptor;
import org.eclipse.sirius.ui.properties.internal.tabprovider.SiriusTabDescriptorProvider;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.InitialOperation;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;

public class SiriusToolServices {
    private final EditingDomainServices editServices = new EditingDomainServices();

    public Object eefViewImage(EObject eObject) {
        return this.editServices.getLabelProviderImage(eObject);
    }

    public Object eefViewText(EObject eObject) {
        return this.editServices.getLabelProviderText(eObject);
    }

    public Object eefViewText(EObject eObject, EStructuralFeature eStructuralFeature) {
        String result = this.editServices.getPropertyDescriptorDisplayName(eObject, eStructuralFeature.getName());
        if (result == null || result.trim().isEmpty()) {
            result = this.editServices.getLabelProviderText((EObject)eStructuralFeature);
        }
        if (result == null || result.trim().isEmpty()) {
            result = eStructuralFeature.getName();
        }
        return result;
    }

    public Collection<?> eefViewChoiceOfValues(EObject eObject, EStructuralFeature eStructuralFeature) {
        return this.editServices.getPropertyDescriptorChoiceOfValues(eObject, eStructuralFeature.getName());
    }

    public EObject executeOperation(EObject eObject, String initialCommandUri) {
        Session session = new EObjectQuery(eObject).getSession();
        ModelOperation modelOperation = this.findModelOperation(initialCommandUri, session);
        if (modelOperation != null) {
            ModelAccessor modelAccessor = session.getModelAccessor();
            ICommandTask task = new TaskHelper(modelAccessor, SiriusEditPlugin.getPlugin().getUiCallback()).buildTaskFromModelOperation(eObject, modelOperation);
            SiriusCommand command = new SiriusCommand(session.getTransactionalEditingDomain(), "SiriusToolServices#executeOperation");
            command.getTasks().add(task);
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
        }
        return eObject;
    }

    private ModelOperation findModelOperation(String initialCommandUri, Session session) {
        URI commandResourceURI = URI.createURI((String)initialCommandUri).trimFragment();
        for (Resource res : this.getResourcesInScope(session)) {
            EObject modelOperationEObject;
            if (!commandResourceURI.equals(res.getURI()) || !((modelOperationEObject = res.getEObject(URI.createURI((String)initialCommandUri).fragment())) instanceof InitialOperation)) continue;
            return ((InitialOperation)modelOperationEObject).getFirstModelOperations();
        }
        return null;
    }

    private Set<Resource> getResourcesInScope(Session session) {
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>();
        Collection selectedViewpoints = session.getSelectedViewpoints(true);
        for (Viewpoint viewpoint : selectedViewpoints) {
            Resource eResource = viewpoint.eResource();
            if (eResource == null) continue;
            result.add(eResource);
        }
        ViewExtensionDescription defaults = SiriusTabDescriptorProvider.getDefaultRules();
        if (defaults != null && defaults.eResource() != null) {
            result.add(defaults.eResource());
        }
        return result;
    }

    public Object eGet(EObject eObject, EStructuralFeature eStructuralFeature) {
        return eObject.eGet(eStructuralFeature);
    }

    public EObject eSet(EObject eObject, EStructuralFeature eStructuralFeature, Object value) {
        Object finalValue = value;
        if (eStructuralFeature instanceof EAttribute && value instanceof String) {
            finalValue = EcoreUtil.createFromString((EDataType)((EAttribute)eStructuralFeature).getEAttributeType(), (String)((String)value));
        }
        eObject.eSet(eStructuralFeature, finalValue);
        return eObject;
    }

    public SiriusContext context(EObject self) {
        return SiriusContext.from(self);
    }

    public SiriusContext context(SiriusInputDescriptor sid) {
        return sid.getFullContext();
    }

    public Session session(SiriusContext ctx) {
        Option<Session> s = ctx.getSession();
        if (s.some()) {
            return (Session)s.get();
        }
        return null;
    }

    public DRepresentation representation(SiriusContext ctx) {
        Option<DRepresentation> r = ctx.getDRepresentation();
        if (r.some()) {
            return (DRepresentation)r.get();
        }
        return null;
    }

    public DSemanticDecorator semanticDecorator(SiriusContext ctx) {
        return ctx.getSemanticDecorator();
    }

    public EObject mainSemanticElement(SiriusContext ctx) {
        Option<EObject> target = ctx.getMainSemanticElement();
        if (target.some()) {
            return (EObject)target.get();
        }
        return null;
    }

    public Collection<EObject> allSemanticElements(SiriusContext ctx) {
        Option<Collection<EObject>> elements = ctx.getAdditionalSemanticElements();
        if (elements.some()) {
            return (Collection)elements.get();
        }
        return null;
    }
}

