/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class TransactionalEditingDomainContextAdapter
implements EditingContextAdapter {
    private static final NotificationFilter FILTER = NotificationFilter.NOT_TOUCH.and(NotificationFilter.createNotifierTypeFilter(EObject.class));
    private final TransactionalEditingDomain ted;
    private final ResourceSetListener preCommitListener = new Listener();
    private IConsumer<List<Notification>> callback;

    public TransactionalEditingDomainContextAdapter(TransactionalEditingDomain ted) {
        this.ted = (TransactionalEditingDomain)Preconditions.checkNotNull((Object)ted);
    }

    public void performModelChange(final Runnable effect) {
        RecordingCommand cmd = new RecordingCommand(this.ted){

            protected void doExecute() {
                effect.run();
            }
        };
        this.ted.getCommandStack().execute((Command)cmd);
    }

    public synchronized void onModelChange(IConsumer<List<Notification>> trigger) {
        if (this.callback == null) {
            this.ted.addResourceSetListener(this.preCommitListener);
        }
        this.callback = trigger;
    }

    public void removeModelChangeConsumer() {
        this.callback = null;
        this.ted.removeResourceSetListener(this.preCommitListener);
    }

    private class Listener
    extends ResourceSetListenerImpl {
        public Listener() {
            super(FILTER);
        }

        public boolean isPostcommitOnly() {
            return true;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            IConsumer t = TransactionalEditingDomainContextAdapter.this.callback;
            if (t != null) {
                t.apply((Object)Lists.newArrayList((Iterable)event.getNotifications()));
            }
        }
    }
}

