/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal.tabprovider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.eef.EEFButtonConditionalStyle;
import org.eclipse.eef.EEFButtonDescription;
import org.eclipse.eef.EEFButtonStyle;
import org.eclipse.eef.EEFCheckboxConditionalStyle;
import org.eclipse.eef.EEFCheckboxDescription;
import org.eclipse.eef.EEFCheckboxStyle;
import org.eclipse.eef.EEFContainerDescription;
import org.eclipse.eef.EEFControlDescription;
import org.eclipse.eef.EEFCustomExpression;
import org.eclipse.eef.EEFCustomWidgetConditionalStyle;
import org.eclipse.eef.EEFCustomWidgetDescription;
import org.eclipse.eef.EEFCustomWidgetStyle;
import org.eclipse.eef.EEFDynamicMappingFor;
import org.eclipse.eef.EEFDynamicMappingIf;
import org.eclipse.eef.EEFFillLayoutDescription;
import org.eclipse.eef.EEFGridLayoutDescription;
import org.eclipse.eef.EEFGroupConditionalStyle;
import org.eclipse.eef.EEFGroupDescription;
import org.eclipse.eef.EEFGroupStyle;
import org.eclipse.eef.EEFHyperlinkConditionalStyle;
import org.eclipse.eef.EEFHyperlinkDescription;
import org.eclipse.eef.EEFHyperlinkStyle;
import org.eclipse.eef.EEFLabelConditionalStyle;
import org.eclipse.eef.EEFLabelDescription;
import org.eclipse.eef.EEFLabelStyle;
import org.eclipse.eef.EEFLayoutDescription;
import org.eclipse.eef.EEFPageDescription;
import org.eclipse.eef.EEFPropertyValidationRuleDescription;
import org.eclipse.eef.EEFRadioConditionalStyle;
import org.eclipse.eef.EEFRadioDescription;
import org.eclipse.eef.EEFRadioStyle;
import org.eclipse.eef.EEFReferenceConditionalStyle;
import org.eclipse.eef.EEFReferenceDescription;
import org.eclipse.eef.EEFReferenceStyle;
import org.eclipse.eef.EEFRuleAuditDescription;
import org.eclipse.eef.EEFSelectConditionalStyle;
import org.eclipse.eef.EEFSelectDescription;
import org.eclipse.eef.EEFSelectStyle;
import org.eclipse.eef.EEFSemanticValidationRuleDescription;
import org.eclipse.eef.EEFTextConditionalStyle;
import org.eclipse.eef.EEFTextDescription;
import org.eclipse.eef.EEFTextStyle;
import org.eclipse.eef.EEFValidationFixDescription;
import org.eclipse.eef.EEFValidationRuleDescription;
import org.eclipse.eef.EEFViewDescription;
import org.eclipse.eef.EEFWidgetAction;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EEFWidgetStyle;
import org.eclipse.eef.EEF_FILL_LAYOUT_ORIENTATION;
import org.eclipse.eef.EEF_TITLE_BAR_STYLE;
import org.eclipse.eef.EEF_TOGGLE_STYLE;
import org.eclipse.eef.EEF_VALIDATION_SEVERITY_DESCRIPTION;
import org.eclipse.eef.EefFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.color.AbstractColorUpdater;
import org.eclipse.sirius.properties.ButtonDescription;
import org.eclipse.sirius.properties.ButtonWidgetConditionalStyle;
import org.eclipse.sirius.properties.ButtonWidgetStyle;
import org.eclipse.sirius.properties.CheckboxDescription;
import org.eclipse.sirius.properties.CheckboxWidgetConditionalStyle;
import org.eclipse.sirius.properties.CheckboxWidgetStyle;
import org.eclipse.sirius.properties.ContainerDescription;
import org.eclipse.sirius.properties.ControlDescription;
import org.eclipse.sirius.properties.CustomDescription;
import org.eclipse.sirius.properties.CustomExpression;
import org.eclipse.sirius.properties.CustomOperation;
import org.eclipse.sirius.properties.CustomWidgetConditionalStyle;
import org.eclipse.sirius.properties.CustomWidgetStyle;
import org.eclipse.sirius.properties.DynamicMappingFor;
import org.eclipse.sirius.properties.DynamicMappingIf;
import org.eclipse.sirius.properties.FILL_LAYOUT_ORIENTATION;
import org.eclipse.sirius.properties.FillLayoutDescription;
import org.eclipse.sirius.properties.GridLayoutDescription;
import org.eclipse.sirius.properties.GroupConditionalStyle;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.GroupStyle;
import org.eclipse.sirius.properties.HyperlinkDescription;
import org.eclipse.sirius.properties.HyperlinkWidgetConditionalStyle;
import org.eclipse.sirius.properties.HyperlinkWidgetStyle;
import org.eclipse.sirius.properties.LabelDescription;
import org.eclipse.sirius.properties.LabelWidgetConditionalStyle;
import org.eclipse.sirius.properties.LabelWidgetStyle;
import org.eclipse.sirius.properties.LayoutDescription;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.PropertyValidationRule;
import org.eclipse.sirius.properties.RadioDescription;
import org.eclipse.sirius.properties.RadioWidgetConditionalStyle;
import org.eclipse.sirius.properties.RadioWidgetStyle;
import org.eclipse.sirius.properties.ReferenceDescription;
import org.eclipse.sirius.properties.ReferenceWidgetConditionalStyle;
import org.eclipse.sirius.properties.ReferenceWidgetStyle;
import org.eclipse.sirius.properties.SelectDescription;
import org.eclipse.sirius.properties.SelectWidgetConditionalStyle;
import org.eclipse.sirius.properties.SelectWidgetStyle;
import org.eclipse.sirius.properties.TextAreaDescription;
import org.eclipse.sirius.properties.TextDescription;
import org.eclipse.sirius.properties.TextWidgetConditionalStyle;
import org.eclipse.sirius.properties.TextWidgetStyle;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.properties.WidgetAction;
import org.eclipse.sirius.properties.WidgetDescription;
import org.eclipse.sirius.properties.WidgetStyle;
import org.eclipse.sirius.ui.properties.internal.SiriusInputDescriptor;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.description.ColorDescription;
import org.eclipse.sirius.viewpoint.description.tool.InitialOperation;
import org.eclipse.sirius.viewpoint.description.validation.ERROR_LEVEL;
import org.eclipse.sirius.viewpoint.description.validation.RuleAudit;
import org.eclipse.sirius.viewpoint.description.validation.SemanticValidationRule;
import org.eclipse.sirius.viewpoint.description.validation.ValidationFix;
import org.eclipse.sirius.viewpoint.description.validation.ValidationRule;

public class ViewDescriptionConverter {
    private Map<WidgetDescription, EEFWidgetDescription> widget2eefWidget = new HashMap<WidgetDescription, EEFWidgetDescription>();
    private Map<EEFPropertyValidationRuleDescription, PropertyValidationRule> eefPropertyValidationRule2propertyValidationRule = new HashMap<EEFPropertyValidationRuleDescription, PropertyValidationRule>();
    private final List<PageDescription> pageDescriptions;
    private EObject semanticElement;

    public ViewDescriptionConverter(List<PageDescription> pageDescriptions) {
        this.pageDescriptions = pageDescriptions;
    }

    public EEFViewDescription convert(SiriusInputDescriptor input) {
        EEFViewDescription view = EefFactory.eINSTANCE.createEEFViewDescription();
        view.setImageExpression("service:eefViewImage");
        LinkedHashSet ePackages = new LinkedHashSet();
        for (PageDescription pageDescription : this.pageDescriptions) {
            EObject eContainer = pageDescription.eContainer();
            if (!(eContainer instanceof ViewExtensionDescription)) continue;
            ViewExtensionDescription viewExtensionDescription = (ViewExtensionDescription)eContainer;
            ePackages.addAll(viewExtensionDescription.getMetamodels());
        }
        view.getEPackages().addAll(ePackages);
        view.setLabelExpression("service:eefViewText");
        for (PageDescription pageDescription : this.pageDescriptions) {
            this.createPage(pageDescription, view);
        }
        Set<Map.Entry<EEFPropertyValidationRuleDescription, PropertyValidationRule>> entries = this.eefPropertyValidationRule2propertyValidationRule.entrySet();
        for (Map.Entry<EEFPropertyValidationRuleDescription, PropertyValidationRule> entry : entries) {
            EList widgets = entry.getValue().getTargets();
            for (WidgetDescription widgetDescription : widgets) {
                EEFWidgetDescription eefWidgetDescription = this.widget2eefWidget.get(widgetDescription);
                if (eefWidgetDescription == null) continue;
                EEFPropertyValidationRuleDescription eefPropertyValidationRule = entry.getKey();
                eefPropertyValidationRule.getTargets().add((Object)eefWidgetDescription);
            }
        }
        if (input != null) {
            this.semanticElement = input.getSemanticElement();
        }
        this.widget2eefWidget.clear();
        this.eefPropertyValidationRule2propertyValidationRule.clear();
        return view;
    }

    private void createPage(PageDescription pageDescription, EEFViewDescription view) {
        EEFPageDescription page = EefFactory.eINSTANCE.createEEFPageDescription();
        page.setIdentifier(pageDescription.getIdentifier());
        page.setLabelExpression(pageDescription.getLabelExpression());
        page.setDomainClass(pageDescription.getDomainClass());
        page.setSemanticCandidateExpression(pageDescription.getSemanticCandidateExpression());
        page.setPreconditionExpression(pageDescription.getPreconditionExpression());
        if (page.getIdentifier() == null || page.getIdentifier().trim().length() == 0) {
            page.setIdentifier(EcoreUtil.getURI((EObject)pageDescription).toString());
        }
        for (GroupDescription groupDescription : pageDescription.getGroups()) {
            this.createGroup(groupDescription, page, view);
        }
        if (pageDescription.getValidationSet() != null) {
            EList semanticValidationRules = pageDescription.getValidationSet().getSemanticValidationRules();
            for (SemanticValidationRule semanticValidationRule : semanticValidationRules) {
                page.getSemanticValidationRules().add((Object)this.createSemanticValidationRuleDescription(semanticValidationRule));
            }
        }
        view.getPages().add((Object)page);
    }

    private EEFSemanticValidationRuleDescription createSemanticValidationRuleDescription(SemanticValidationRule semanticValidationRule) {
        EEFSemanticValidationRuleDescription eefSemanticValidationRuleDescription = EefFactory.eINSTANCE.createEEFSemanticValidationRuleDescription();
        eefSemanticValidationRuleDescription.setTargetClass(semanticValidationRule.getTargetClass());
        eefSemanticValidationRuleDescription.setSeverity(this.getValidationSeverity(semanticValidationRule.getLevel()));
        this.createValidationRuleContent((EEFValidationRuleDescription)eefSemanticValidationRuleDescription, (ValidationRule)semanticValidationRule);
        return eefSemanticValidationRuleDescription;
    }

    private EEFPropertyValidationRuleDescription createPropertyValidationRuleDescription(PropertyValidationRule propertyValidationRule) {
        EEFPropertyValidationRuleDescription eefPropertyValidationRuleDescription = EefFactory.eINSTANCE.createEEFPropertyValidationRuleDescription();
        eefPropertyValidationRuleDescription.setSeverity(this.getValidationSeverity(propertyValidationRule.getLevel()));
        this.createValidationRuleContent((EEFValidationRuleDescription)eefPropertyValidationRuleDescription, (ValidationRule)propertyValidationRule);
        return eefPropertyValidationRuleDescription;
    }

    private void createValidationRuleContent(EEFValidationRuleDescription eefValidationRuleDescription, ValidationRule validationRule) {
        eefValidationRuleDescription.setMessageExpression(validationRule.getMessage());
        EList audits = validationRule.getAudits();
        for (RuleAudit audit : audits) {
            EEFRuleAuditDescription eefRuleAuditDescription = EefFactory.eINSTANCE.createEEFRuleAuditDescription();
            eefRuleAuditDescription.setAuditExpression(audit.getAuditExpression());
            eefValidationRuleDescription.getAudits().add((Object)eefRuleAuditDescription);
        }
        EList fixes = validationRule.getFixes();
        for (ValidationFix validationFix : fixes) {
            EEFValidationFixDescription eefValidationFixDescription = EefFactory.eINSTANCE.createEEFValidationFixDescription();
            eefValidationFixDescription.setName(validationFix.getName());
            eefValidationFixDescription.setFixExpression(this.getExpressionForOperation(validationFix.getInitialOperation()));
            eefValidationRuleDescription.getFixes().add((Object)eefValidationFixDescription);
        }
    }

    private EEF_VALIDATION_SEVERITY_DESCRIPTION getValidationSeverity(ERROR_LEVEL level) {
        EEF_VALIDATION_SEVERITY_DESCRIPTION severity = EEF_VALIDATION_SEVERITY_DESCRIPTION.INFO;
        switch (level) {
            case INFO_LITERAL: {
                severity = EEF_VALIDATION_SEVERITY_DESCRIPTION.INFO;
                break;
            }
            case WARNING_LITERAL: {
                severity = EEF_VALIDATION_SEVERITY_DESCRIPTION.WARNING;
                break;
            }
            case ERROR_LITERAL: {
                severity = EEF_VALIDATION_SEVERITY_DESCRIPTION.ERROR;
                break;
            }
            default: {
                severity = EEF_VALIDATION_SEVERITY_DESCRIPTION.INFO;
            }
        }
        return severity;
    }

    private void createGroup(GroupDescription groupDescription, EEFPageDescription page, EEFViewDescription view) {
        EList conditionalStyles;
        EEFGroupDescription eefGroup = EefFactory.eINSTANCE.createEEFGroupDescription();
        eefGroup.setIdentifier(groupDescription.getIdentifier());
        eefGroup.setLabelExpression(groupDescription.getLabelExpression());
        eefGroup.setDomainClass(groupDescription.getDomainClass());
        eefGroup.setSemanticCandidateExpression(groupDescription.getSemanticCandidateExpression());
        eefGroup.setPreconditionExpression(groupDescription.getPreconditionExpression());
        EEFGroupStyle eefGroupStyle = this.createEEFGroupStyle(groupDescription.getStyle());
        if (eefGroupStyle != null) {
            eefGroup.setStyle(eefGroupStyle);
        }
        if ((conditionalStyles = groupDescription.getConditionalStyles()) != null && !conditionalStyles.isEmpty()) {
            ArrayList<EEFGroupConditionalStyle> eefConditionalStyles = new ArrayList<EEFGroupConditionalStyle>();
            for (GroupConditionalStyle conditionalStyle : conditionalStyles) {
                EEFGroupConditionalStyle eefConditionalStyle = EefFactory.eINSTANCE.createEEFGroupConditionalStyle();
                eefConditionalStyle.setPreconditionExpression(conditionalStyle.getPreconditionExpression());
                EEFGroupStyle eefConditionalStyleGroupStyle = this.createEEFGroupStyle(conditionalStyle.getStyle());
                if (eefConditionalStyleGroupStyle != null) {
                    eefConditionalStyle.setStyle(eefConditionalStyleGroupStyle);
                }
                eefConditionalStyles.add(eefConditionalStyle);
            }
            if (eefConditionalStyles != null && !eefConditionalStyles.isEmpty()) {
                eefGroup.getConditionalStyles().addAll(eefConditionalStyles);
            }
        }
        if (eefGroup.getIdentifier() == null || eefGroup.getIdentifier().trim().length() == 0) {
            eefGroup.setIdentifier(EcoreUtil.getURI((EObject)groupDescription).toString());
        }
        this.convertGroupContents(groupDescription, eefGroup);
        if (groupDescription.getValidationSet() != null) {
            for (SemanticValidationRule semanticValidationRule : groupDescription.getValidationSet().getSemanticValidationRules()) {
                eefGroup.getSemanticValidationRules().add((Object)this.createSemanticValidationRuleDescription(semanticValidationRule));
            }
            for (PropertyValidationRule propertyValidationRule : groupDescription.getValidationSet().getPropertyValidationRules()) {
                EEFPropertyValidationRuleDescription propertyValidationRuleDescription = this.createPropertyValidationRuleDescription(propertyValidationRule);
                this.eefPropertyValidationRule2propertyValidationRule.put(propertyValidationRuleDescription, propertyValidationRule);
                eefGroup.getPropertyValidationRules().add((Object)propertyValidationRuleDescription);
            }
        }
        page.getGroups().add((Object)eefGroup);
        view.getGroups().add((Object)eefGroup);
    }

    private EEFGroupStyle createEEFGroupStyle(GroupStyle groupStyle) {
        if (groupStyle != null) {
            String foregroundColorExpression;
            ColorDescription foregroundColorDescription;
            String backgroundColorExpression;
            EEFGroupStyle eefGroupStyle = EefFactory.eINSTANCE.createEEFGroupStyle();
            ColorDescription backgroundColorDescription = groupStyle.getBackgroundColor();
            if (backgroundColorDescription != null && (backgroundColorExpression = this.getColorExpression(backgroundColorDescription)) != null) {
                eefGroupStyle.setBackgroundColorExpression(backgroundColorExpression);
            }
            if ((foregroundColorDescription = groupStyle.getForegroundColor()) != null && (foregroundColorExpression = this.getColorExpression(foregroundColorDescription)) != null) {
                eefGroupStyle.setForegroundColorExpression(foregroundColorExpression);
            }
            eefGroupStyle.setFontNameExpression(groupStyle.getFontNameExpression());
            eefGroupStyle.setFontSizeExpression(Integer.toString(groupStyle.getFontSize()));
            eefGroupStyle.setBarStyle(EEF_TITLE_BAR_STYLE.get((int)groupStyle.getBarStyle().getValue()));
            eefGroupStyle.setToggleStyle(EEF_TOGGLE_STYLE.get((int)groupStyle.getToggleStyle().getValue()));
            eefGroupStyle.setExpandedByDefault(groupStyle.isExpandedByDefault());
            return eefGroupStyle;
        }
        return null;
    }

    private void convertGroupContents(GroupDescription groupDescription, EEFGroupDescription group) {
        EList controls = groupDescription.getControls();
        for (ControlDescription controlDescription : controls) {
            EEFControlDescription eefControlDescription = this.createEEFControlDescription(controlDescription);
            if (eefControlDescription == null) continue;
            group.getControls().add((Object)eefControlDescription);
        }
    }

    private EEFControlDescription createEEFControlDescription(ControlDescription controlDescription) {
        EEFWidgetDescription eefControlDescription = null;
        if (controlDescription instanceof WidgetDescription) {
            WidgetDescription widgetDescription = (WidgetDescription)controlDescription;
            eefControlDescription = this.createEEFWidgetDescription(widgetDescription);
        } else if (controlDescription instanceof ContainerDescription) {
            ContainerDescription containerDescription = (ContainerDescription)controlDescription;
            eefControlDescription = this.createEEFContainerDescription(containerDescription);
        } else if (controlDescription instanceof DynamicMappingFor) {
            DynamicMappingFor dynamicMappingFor = (DynamicMappingFor)controlDescription;
            eefControlDescription = this.createEEFDynamicMappingFor(dynamicMappingFor);
        }
        return eefControlDescription;
    }

    private EEFContainerDescription createEEFContainerDescription(ContainerDescription containerDescription) {
        EEFContainerDescription eefContainerDescription = EefFactory.eINSTANCE.createEEFContainerDescription();
        LayoutDescription layout = containerDescription.getLayout();
        if (layout instanceof FillLayoutDescription) {
            EEFFillLayoutDescription eefFillLayoutDescription = EefFactory.eINSTANCE.createEEFFillLayoutDescription();
            if (((FillLayoutDescription)layout).getOrientation() == FILL_LAYOUT_ORIENTATION.HORIZONTAL) {
                eefFillLayoutDescription.setOrientation(EEF_FILL_LAYOUT_ORIENTATION.HORIZONTAL);
            } else if (((FillLayoutDescription)layout).getOrientation() == FILL_LAYOUT_ORIENTATION.VERTICAL) {
                eefFillLayoutDescription.setOrientation(EEF_FILL_LAYOUT_ORIENTATION.VERTICAL);
            }
            eefContainerDescription.setLayout((EEFLayoutDescription)eefFillLayoutDescription);
        } else if (layout instanceof GridLayoutDescription) {
            EEFGridLayoutDescription eefGridLayoutDescription = EefFactory.eINSTANCE.createEEFGridLayoutDescription();
            eefGridLayoutDescription.setNumberOfColumns(((GridLayoutDescription)layout).getNumberOfColumns());
            eefGridLayoutDescription.setMakeColumnsWithEqualWidth(((GridLayoutDescription)layout).isMakeColumnsWithEqualWidth());
            eefContainerDescription.setLayout((EEFLayoutDescription)eefGridLayoutDescription);
        }
        EList controls = containerDescription.getControls();
        for (ControlDescription controlDescription : controls) {
            EEFControlDescription eefControlDescription = this.createEEFControlDescription(controlDescription);
            if (eefControlDescription == null) continue;
            eefContainerDescription.getControls().add((Object)eefControlDescription);
        }
        return eefContainerDescription;
    }

    private EEFDynamicMappingFor createEEFDynamicMappingFor(DynamicMappingFor dynamicMappingFor) {
        EEFDynamicMappingFor eefDynamicMappingFor = EefFactory.eINSTANCE.createEEFDynamicMappingFor();
        eefDynamicMappingFor.setDomainClassExpression(dynamicMappingFor.getDomainClassExpression());
        eefDynamicMappingFor.setIterator(dynamicMappingFor.getIterator());
        EList dynamicMappingIfs = dynamicMappingFor.getIfs();
        for (DynamicMappingIf dynamicMappingIf : dynamicMappingIfs) {
            EEFDynamicMappingIf eefDynamicMappingIf = EefFactory.eINSTANCE.createEEFDynamicMappingIf();
            eefDynamicMappingIf.setPredicateExpression(dynamicMappingIf.getPredicateExpression());
            EEFWidgetDescription eefWidgetDescription = this.createEEFWidgetDescription(dynamicMappingIf.getWidget());
            eefDynamicMappingIf.setWidget(eefWidgetDescription);
            eefDynamicMappingFor.getIfs().add((Object)eefDynamicMappingIf);
        }
        return eefDynamicMappingFor;
    }

    private EEFWidgetDescription createEEFWidgetDescription(WidgetDescription widgetDescription) {
        EEFTextDescription description = null;
        if (widgetDescription instanceof TextAreaDescription) {
            description = this.createEEFTextDescription((TextAreaDescription)widgetDescription);
        } else if (widgetDescription instanceof TextDescription) {
            description = this.createEEFTextDescription((TextDescription)widgetDescription);
        } else if (widgetDescription instanceof LabelDescription) {
            description = this.createEEFLabelDescription((LabelDescription)widgetDescription);
        } else if (widgetDescription instanceof CheckboxDescription) {
            description = this.createEEFCheckboxDescription((CheckboxDescription)widgetDescription);
        } else if (widgetDescription instanceof SelectDescription) {
            description = this.createEEFSelectDescription((SelectDescription)widgetDescription);
        } else if (widgetDescription instanceof ButtonDescription) {
            description = this.createEEFButtonDescription((ButtonDescription)widgetDescription);
        } else if (widgetDescription instanceof RadioDescription) {
            description = this.createEEFRadioDescription((RadioDescription)widgetDescription);
        } else if (widgetDescription instanceof ReferenceDescription) {
            description = this.createEEFReferenceDescription((ReferenceDescription)widgetDescription);
        } else if (widgetDescription instanceof HyperlinkDescription) {
            description = this.createEEFHyperlinkDescription((HyperlinkDescription)widgetDescription);
        } else if (widgetDescription instanceof CustomDescription) {
            description = this.createEEFCustomDescription((CustomDescription)widgetDescription);
        }
        if (description != null) {
            description.setHelpExpression(widgetDescription.getHelpExpression());
            description.setLabelExpression(widgetDescription.getLabelExpression());
            description.setIsEnabledExpression(widgetDescription.getIsEnabledExpression());
            this.widget2eefWidget.put(widgetDescription, (EEFWidgetDescription)description);
        }
        return description;
    }

    private EEFWidgetStyle createEEFWidgetStyle(WidgetStyle widgetStyle) {
        EEFTextStyle eefWidgetStyle = null;
        if (widgetStyle instanceof TextWidgetStyle) {
            eefWidgetStyle = this.createEEFTextStyle((TextWidgetStyle)widgetStyle);
        } else if (widgetStyle instanceof LabelWidgetStyle) {
            eefWidgetStyle = this.createEEFLabelStyle((LabelWidgetStyle)widgetStyle);
        } else if (widgetStyle instanceof ButtonWidgetStyle) {
            eefWidgetStyle = EefFactory.eINSTANCE.createEEFButtonStyle();
        } else if (widgetStyle instanceof CheckboxWidgetStyle) {
            eefWidgetStyle = EefFactory.eINSTANCE.createEEFCheckboxStyle();
        } else if (widgetStyle instanceof RadioWidgetStyle) {
            eefWidgetStyle = EefFactory.eINSTANCE.createEEFRadioStyle();
        } else if (widgetStyle instanceof SelectWidgetStyle) {
            eefWidgetStyle = EefFactory.eINSTANCE.createEEFSelectStyle();
        } else if (widgetStyle instanceof HyperlinkWidgetStyle) {
            eefWidgetStyle = this.createEEFHyperlinkStyle((HyperlinkWidgetStyle)widgetStyle);
        } else if (widgetStyle instanceof CustomWidgetStyle) {
            eefWidgetStyle = EefFactory.eINSTANCE.createEEFCustomWidgetStyle();
        } else if (widgetStyle instanceof ReferenceWidgetStyle) {
            eefWidgetStyle = EefFactory.eINSTANCE.createEEFReferenceStyle();
        }
        if (eefWidgetStyle != null) {
            String foregroundColorExpression;
            ColorDescription foregroundColorDescription;
            String backgroundColorExpression;
            ColorDescription backgroundColorDescription = widgetStyle.getLabelBackgroundColor();
            if (backgroundColorDescription != null && (backgroundColorExpression = this.getColorExpression(backgroundColorDescription)) != null) {
                eefWidgetStyle.setLabelBackgroundColorExpression(backgroundColorExpression);
            }
            if ((foregroundColorDescription = widgetStyle.getLabelForegroundColor()) != null && (foregroundColorExpression = this.getColorExpression(foregroundColorDescription)) != null) {
                eefWidgetStyle.setLabelForegroundColorExpression(foregroundColorExpression);
            }
            eefWidgetStyle.setLabelFontNameExpression(widgetStyle.getLabelFontNameExpression());
            eefWidgetStyle.setLabelFontSizeExpression(Integer.toString(widgetStyle.getLabelFontSize()));
            eefWidgetStyle.setLabelFontStyleExpression(this.getFontStyleExpression((List<FontFormat>)widgetStyle.getLabelFontFormat()));
        }
        return eefWidgetStyle;
    }

    private EEFTextStyle createEEFTextStyle(TextWidgetStyle textStyle) {
        String foregroundColorExpression;
        ColorDescription foregroundColorDescription;
        String backgroundColorExpression;
        EEFTextStyle eefTextStyle = EefFactory.eINSTANCE.createEEFTextStyle();
        ColorDescription backgroundColorDescription = textStyle.getBackgroundColor();
        if (backgroundColorDescription != null && (backgroundColorExpression = this.getColorExpression(backgroundColorDescription)) != null) {
            eefTextStyle.setBackgroundColorExpression(backgroundColorExpression);
        }
        if ((foregroundColorDescription = textStyle.getForegroundColor()) != null && (foregroundColorExpression = this.getColorExpression(foregroundColorDescription)) != null) {
            eefTextStyle.setForegroundColorExpression(foregroundColorExpression);
        }
        eefTextStyle.setFontNameExpression(textStyle.getFontNameExpression());
        eefTextStyle.setFontSizeExpression(Integer.toString(textStyle.getFontSize()));
        eefTextStyle.setFontStyleExpression(this.getFontStyleExpression((List<FontFormat>)textStyle.getFontFormat()));
        return eefTextStyle;
    }

    private EEFLabelStyle createEEFLabelStyle(LabelWidgetStyle labelStyle) {
        String foregroundColorExpression;
        ColorDescription foregroundColorDescription;
        String backgroundColorExpression;
        EEFLabelStyle eefLabelStyle = EefFactory.eINSTANCE.createEEFLabelStyle();
        ColorDescription backgroundColorDescription = labelStyle.getBackgroundColor();
        if (backgroundColorDescription != null && (backgroundColorExpression = this.getColorExpression(backgroundColorDescription)) != null) {
            eefLabelStyle.setBackgroundColorExpression(backgroundColorExpression);
        }
        if ((foregroundColorDescription = labelStyle.getForegroundColor()) != null && (foregroundColorExpression = this.getColorExpression(foregroundColorDescription)) != null) {
            eefLabelStyle.setForegroundColorExpression(foregroundColorExpression);
        }
        eefLabelStyle.setFontNameExpression(labelStyle.getFontNameExpression());
        eefLabelStyle.setFontSizeExpression(Integer.toString(labelStyle.getFontSize()));
        eefLabelStyle.setFontStyleExpression(this.getFontStyleExpression((List<FontFormat>)labelStyle.getFontFormat()));
        return eefLabelStyle;
    }

    private EEFHyperlinkStyle createEEFHyperlinkStyle(HyperlinkWidgetStyle hyperlinkStyle) {
        String backgroundColorExpression;
        EEFHyperlinkStyle eefHyperlinkStyle = EefFactory.eINSTANCE.createEEFHyperlinkStyle();
        ColorDescription backgroundColorDescription = hyperlinkStyle.getBackgroundColor();
        if (backgroundColorDescription != null && (backgroundColorExpression = this.getColorExpression(backgroundColorDescription)) != null) {
            eefHyperlinkStyle.setBackgroundColorExpression(backgroundColorExpression);
        }
        eefHyperlinkStyle.setFontNameExpression(hyperlinkStyle.getFontNameExpression());
        eefHyperlinkStyle.setFontSizeExpression(Integer.toString(hyperlinkStyle.getFontSize()));
        eefHyperlinkStyle.setFontStyleExpression(this.getFontStyleExpression((List<FontFormat>)hyperlinkStyle.getFontFormat()));
        return eefHyperlinkStyle;
    }

    private String getFontStyleExpression(List<FontFormat> fontFormats) {
        String fontFormat = fontFormats.toString();
        return fontFormat.substring(1, fontFormat.length() - 1);
    }

    private EEFTextDescription createEEFTextDescription(TextDescription textDescription) {
        EList conditionalStyles;
        EEFTextDescription eefTextDescription = EefFactory.eINSTANCE.createEEFTextDescription();
        eefTextDescription.setIdentifier(textDescription.getIdentifier());
        eefTextDescription.setValueExpression(textDescription.getValueExpression());
        InitialOperation initialOperation = textDescription.getInitialOperation();
        eefTextDescription.setEditExpression(this.getExpressionForOperation(initialOperation));
        TextWidgetStyle textStyle = textDescription.getStyle();
        if (textStyle != null) {
            eefTextDescription.setStyle((EEFTextStyle)this.createEEFWidgetStyle((WidgetStyle)textStyle));
        }
        if ((conditionalStyles = textDescription.getConditionalStyles()) != null && !conditionalStyles.isEmpty()) {
            ArrayList<EEFTextConditionalStyle> eefConditionalStyles = new ArrayList<EEFTextConditionalStyle>();
            for (TextWidgetConditionalStyle conditionalStyle : conditionalStyles) {
                EEFTextConditionalStyle eefConditionalStyle = EefFactory.eINSTANCE.createEEFTextConditionalStyle();
                eefConditionalStyle.setPreconditionExpression(conditionalStyle.getPreconditionExpression());
                eefConditionalStyle.setStyle((EEFTextStyle)this.createEEFWidgetStyle((WidgetStyle)conditionalStyle.getStyle()));
                eefConditionalStyles.add(eefConditionalStyle);
            }
            if (eefConditionalStyles != null && !eefConditionalStyles.isEmpty()) {
                eefTextDescription.getConditionalStyles().addAll(eefConditionalStyles);
            }
        }
        return eefTextDescription;
    }

    private EEFHyperlinkDescription createEEFHyperlinkDescription(HyperlinkDescription hyperlinkDescription) {
        EList conditionalStyles;
        EEFHyperlinkDescription eefHyperlinkDescription = EefFactory.eINSTANCE.createEEFHyperlinkDescription();
        eefHyperlinkDescription.setIdentifier(hyperlinkDescription.getIdentifier());
        eefHyperlinkDescription.setValueExpression(hyperlinkDescription.getValueExpression());
        InitialOperation initialOperation = hyperlinkDescription.getInitialOperation();
        eefHyperlinkDescription.setOnClickExpression(this.getExpressionForOperation(initialOperation));
        HyperlinkWidgetStyle hyperlinkStyle = hyperlinkDescription.getStyle();
        if (hyperlinkStyle != null) {
            eefHyperlinkDescription.setStyle((EEFHyperlinkStyle)this.createEEFWidgetStyle((WidgetStyle)hyperlinkStyle));
        }
        if ((conditionalStyles = hyperlinkDescription.getConditionalStyles()) != null && !conditionalStyles.isEmpty()) {
            ArrayList<EEFHyperlinkConditionalStyle> eefConditionalStyles = new ArrayList<EEFHyperlinkConditionalStyle>();
            for (HyperlinkWidgetConditionalStyle conditionalStyle : conditionalStyles) {
                EEFHyperlinkConditionalStyle eefConditionalStyle = EefFactory.eINSTANCE.createEEFHyperlinkConditionalStyle();
                eefConditionalStyle.setPreconditionExpression(conditionalStyle.getPreconditionExpression());
                eefConditionalStyle.setStyle((EEFHyperlinkStyle)this.createEEFWidgetStyle((WidgetStyle)conditionalStyle.getStyle()));
                eefConditionalStyles.add(eefConditionalStyle);
            }
            if (eefConditionalStyles != null && !eefConditionalStyles.isEmpty()) {
                eefHyperlinkDescription.getConditionalStyles().addAll(eefConditionalStyles);
            }
        }
        return eefHyperlinkDescription;
    }

    private String getColorExpression(ColorDescription colorDescription) {
        AbstractColorUpdater colorUpdater = new AbstractColorUpdater();
        RGBValues rgbValues = colorUpdater.getRGBValuesFromColorDescription(this.semanticElement, colorDescription);
        if (rgbValues != null) {
            return "rgb(" + rgbValues.getRed() + "," + rgbValues.getGreen() + "," + rgbValues.getBlue() + ")";
        }
        return null;
    }

    private String getExpressionForOperation(InitialOperation initialOperation) {
        if (initialOperation != null) {
            return "aql:self.executeOperation('" + EcoreUtil.getURI((EObject)initialOperation).toString() + "')";
        }
        return null;
    }

    private EEFTextDescription createEEFTextDescription(TextAreaDescription textDescription) {
        EList conditionalStyles;
        EEFTextDescription eefTextDescription = EefFactory.eINSTANCE.createEEFTextDescription();
        eefTextDescription.setIdentifier(textDescription.getIdentifier());
        eefTextDescription.setValueExpression(textDescription.getValueExpression());
        eefTextDescription.setLineCount(textDescription.getLineCount());
        InitialOperation initialOperation = textDescription.getInitialOperation();
        eefTextDescription.setEditExpression(this.getExpressionForOperation(initialOperation));
        TextWidgetStyle textStyle = textDescription.getStyle();
        if (textStyle != null) {
            eefTextDescription.setStyle((EEFTextStyle)this.createEEFWidgetStyle((WidgetStyle)textStyle));
        }
        if ((conditionalStyles = textDescription.getConditionalStyles()) != null && !conditionalStyles.isEmpty()) {
            ArrayList<EEFTextConditionalStyle> eefConditionalStyles = new ArrayList<EEFTextConditionalStyle>();
            for (TextWidgetConditionalStyle conditionalStyle : conditionalStyles) {
                EEFTextConditionalStyle eefConditionalStyle = EefFactory.eINSTANCE.createEEFTextConditionalStyle();
                eefConditionalStyle.setPreconditionExpression(conditionalStyle.getPreconditionExpression());
                eefConditionalStyle.setStyle((EEFTextStyle)this.createEEFWidgetStyle((WidgetStyle)conditionalStyle.getStyle()));
                eefConditionalStyles.add(eefConditionalStyle);
            }
            if (eefConditionalStyles != null && !eefConditionalStyles.isEmpty()) {
                eefTextDescription.getConditionalStyles().addAll(eefConditionalStyles);
            }
        }
        return eefTextDescription;
    }

    private EEFLabelDescription createEEFLabelDescription(LabelDescription labelDescription) {
        EList conditionalStyles;
        EEFLabelDescription eefLabelDescription = EefFactory.eINSTANCE.createEEFLabelDescription();
        eefLabelDescription.setIdentifier(labelDescription.getIdentifier());
        eefLabelDescription.setValueExpression(labelDescription.getValueExpression());
        LabelWidgetStyle bodyStyle = labelDescription.getStyle();
        if (bodyStyle != null) {
            eefLabelDescription.setStyle((EEFLabelStyle)this.createEEFWidgetStyle((WidgetStyle)bodyStyle));
        }
        if ((conditionalStyles = labelDescription.getConditionalStyles()) != null && !conditionalStyles.isEmpty()) {
            ArrayList<EEFLabelConditionalStyle> eefConditionalStyles = new ArrayList<EEFLabelConditionalStyle>();
            for (LabelWidgetConditionalStyle conditionalStyle : conditionalStyles) {
                EEFLabelConditionalStyle eefConditionalStyle = EefFactory.eINSTANCE.createEEFLabelConditionalStyle();
                eefConditionalStyle.setPreconditionExpression(conditionalStyle.getPreconditionExpression());
                eefConditionalStyle.setStyle((EEFLabelStyle)this.createEEFWidgetStyle((WidgetStyle)conditionalStyle.getStyle()));
                eefConditionalStyles.add(eefConditionalStyle);
            }
            if (eefConditionalStyles != null && !eefConditionalStyles.isEmpty()) {
                eefLabelDescription.getConditionalStyles().addAll(eefConditionalStyles);
            }
        }
        return eefLabelDescription;
    }

    private EEFButtonDescription createEEFButtonDescription(ButtonDescription buttonDescription) {
        EList conditionalStyles;
        EEFButtonDescription eefButtonDescription = EefFactory.eINSTANCE.createEEFButtonDescription();
        eefButtonDescription.setIdentifier(buttonDescription.getIdentifier());
        eefButtonDescription.setButtonLabelExpression(buttonDescription.getButtonLabelExpression());
        InitialOperation initialOperation = buttonDescription.getInitialOperation();
        eefButtonDescription.setPushExpression(this.getExpressionForOperation(initialOperation));
        ButtonWidgetStyle buttonStyle = buttonDescription.getStyle();
        if (buttonStyle != null) {
            eefButtonDescription.setStyle((EEFButtonStyle)this.createEEFWidgetStyle((WidgetStyle)buttonStyle));
        }
        if ((conditionalStyles = buttonDescription.getConditionalStyles()) != null && !conditionalStyles.isEmpty()) {
            ArrayList<EEFButtonConditionalStyle> eefConditionalStyles = new ArrayList<EEFButtonConditionalStyle>();
            for (ButtonWidgetConditionalStyle conditionalStyle : conditionalStyles) {
                EEFButtonConditionalStyle eefConditionalStyle = EefFactory.eINSTANCE.createEEFButtonConditionalStyle();
                eefConditionalStyle.setPreconditionExpression(conditionalStyle.getPreconditionExpression());
                eefConditionalStyle.setStyle((EEFButtonStyle)this.createEEFWidgetStyle((WidgetStyle)conditionalStyle.getStyle()));
                eefConditionalStyles.add(eefConditionalStyle);
            }
            if (eefConditionalStyles != null && !eefConditionalStyles.isEmpty()) {
                eefButtonDescription.getConditionalStyles().addAll(eefConditionalStyles);
            }
        }
        return eefButtonDescription;
    }

    private EEFCheckboxDescription createEEFCheckboxDescription(CheckboxDescription checkboxDescription) {
        EList conditionalStyles;
        EEFCheckboxDescription eefCheckboxDescription = EefFactory.eINSTANCE.createEEFCheckboxDescription();
        eefCheckboxDescription.setIdentifier(checkboxDescription.getIdentifier());
        eefCheckboxDescription.setValueExpression(checkboxDescription.getValueExpression());
        InitialOperation initialOperation = checkboxDescription.getInitialOperation();
        eefCheckboxDescription.setEditExpression(this.getExpressionForOperation(initialOperation));
        CheckboxWidgetStyle checkboxStyle = checkboxDescription.getStyle();
        if (checkboxStyle != null) {
            eefCheckboxDescription.setStyle((EEFCheckboxStyle)this.createEEFWidgetStyle((WidgetStyle)checkboxStyle));
        }
        if ((conditionalStyles = checkboxDescription.getConditionalStyles()) != null && !conditionalStyles.isEmpty()) {
            ArrayList<EEFCheckboxConditionalStyle> eefConditionalStyles = new ArrayList<EEFCheckboxConditionalStyle>();
            for (CheckboxWidgetConditionalStyle conditionalStyle : conditionalStyles) {
                EEFCheckboxConditionalStyle eefConditionalStyle = EefFactory.eINSTANCE.createEEFCheckboxConditionalStyle();
                eefConditionalStyle.setPreconditionExpression(conditionalStyle.getPreconditionExpression());
                eefConditionalStyle.setStyle((EEFCheckboxStyle)this.createEEFWidgetStyle((WidgetStyle)conditionalStyle.getStyle()));
                eefConditionalStyles.add(eefConditionalStyle);
            }
            if (eefConditionalStyles != null && !eefConditionalStyles.isEmpty()) {
                eefCheckboxDescription.getConditionalStyles().addAll(eefConditionalStyles);
            }
        }
        return eefCheckboxDescription;
    }

    private EEFSelectDescription createEEFSelectDescription(SelectDescription selectDescription) {
        EList conditionalStyles;
        EEFSelectDescription eefSelectDescription = EefFactory.eINSTANCE.createEEFSelectDescription();
        eefSelectDescription.setIdentifier(selectDescription.getIdentifier());
        eefSelectDescription.setValueExpression(selectDescription.getValueExpression());
        eefSelectDescription.setCandidatesExpression(selectDescription.getCandidatesExpression());
        eefSelectDescription.setCandidateDisplayExpression(selectDescription.getCandidateDisplayExpression());
        InitialOperation initialOperation = selectDescription.getInitialOperation();
        eefSelectDescription.setEditExpression(this.getExpressionForOperation(initialOperation));
        SelectWidgetStyle selectStyle = selectDescription.getStyle();
        if (selectStyle != null) {
            eefSelectDescription.setStyle((EEFSelectStyle)this.createEEFWidgetStyle((WidgetStyle)selectStyle));
        }
        if ((conditionalStyles = selectDescription.getConditionalStyles()) != null) {
            ArrayList<EEFSelectConditionalStyle> eefConditionalStyles = new ArrayList<EEFSelectConditionalStyle>();
            for (SelectWidgetConditionalStyle conditionalStyle : conditionalStyles) {
                EEFSelectConditionalStyle eefConditionalStyle = EefFactory.eINSTANCE.createEEFSelectConditionalStyle();
                eefConditionalStyle.setPreconditionExpression(conditionalStyle.getPreconditionExpression());
                eefConditionalStyle.setStyle((EEFSelectStyle)this.createEEFWidgetStyle((WidgetStyle)conditionalStyle.getStyle()));
                eefConditionalStyles.add(eefConditionalStyle);
            }
            if (eefConditionalStyles != null && !eefConditionalStyles.isEmpty()) {
                eefSelectDescription.getConditionalStyles().addAll(eefConditionalStyles);
            }
        }
        return eefSelectDescription;
    }

    private EEFRadioDescription createEEFRadioDescription(RadioDescription radioDescription) {
        EList conditionalStyles;
        EEFRadioDescription eefRadioDescription = EefFactory.eINSTANCE.createEEFRadioDescription();
        eefRadioDescription.setIdentifier(radioDescription.getIdentifier());
        eefRadioDescription.setValueExpression(radioDescription.getValueExpression());
        eefRadioDescription.setCandidatesExpression(radioDescription.getCandidatesExpression());
        eefRadioDescription.setCandidateDisplayExpression(radioDescription.getCandidateDisplayExpression());
        eefRadioDescription.setNumberOfColumns(radioDescription.getNumberOfColumns());
        InitialOperation initialOperation = radioDescription.getInitialOperation();
        eefRadioDescription.setEditExpression(this.getExpressionForOperation(initialOperation));
        RadioWidgetStyle radioStyle = radioDescription.getStyle();
        if (radioStyle != null) {
            eefRadioDescription.setStyle((EEFRadioStyle)this.createEEFWidgetStyle((WidgetStyle)radioStyle));
        }
        if ((conditionalStyles = radioDescription.getConditionalStyles()) != null && !conditionalStyles.isEmpty()) {
            ArrayList<EEFRadioConditionalStyle> eefConditionalStyles = new ArrayList<EEFRadioConditionalStyle>();
            for (RadioWidgetConditionalStyle conditionalStyle : conditionalStyles) {
                EEFRadioConditionalStyle eefConditionalStyle = EefFactory.eINSTANCE.createEEFRadioConditionalStyle();
                eefConditionalStyle.setPreconditionExpression(conditionalStyle.getPreconditionExpression());
                eefConditionalStyle.setStyle((EEFRadioStyle)this.createEEFWidgetStyle((WidgetStyle)conditionalStyle.getStyle()));
                eefConditionalStyles.add(eefConditionalStyle);
            }
            if (eefConditionalStyles != null && !eefConditionalStyles.isEmpty()) {
                eefRadioDescription.getConditionalStyles().addAll(eefConditionalStyles);
            }
        }
        return eefRadioDescription;
    }

    private EEFReferenceDescription createEEFReferenceDescription(ReferenceDescription referenceDescription) {
        EList conditionalStyles;
        EEFReferenceDescription eefReferenceDescription = EefFactory.eINSTANCE.createEEFReferenceDescription();
        eefReferenceDescription.setIdentifier(referenceDescription.getIdentifier());
        eefReferenceDescription.setValueExpression(referenceDescription.getValueExpression());
        eefReferenceDescription.setMultiple(referenceDescription.isMultiple());
        eefReferenceDescription.setDisplayExpression(referenceDescription.getDisplayExpression());
        eefReferenceDescription.setOnClickExpression(this.getExpressionForOperation(referenceDescription.getOnClickOperation()));
        for (WidgetAction action : referenceDescription.getActions()) {
            EEFWidgetAction eefAction = EefFactory.eINSTANCE.createEEFWidgetAction();
            eefAction.setLabelExpression(action.getLabelExpression());
            eefAction.setActionExpression(this.getExpressionForOperation(action.getInitialOperation()));
            eefReferenceDescription.getActions().add((Object)eefAction);
        }
        ReferenceWidgetStyle referenceStyle = referenceDescription.getStyle();
        if (referenceStyle != null) {
            eefReferenceDescription.setStyle((EEFReferenceStyle)this.createEEFWidgetStyle((WidgetStyle)referenceStyle));
        }
        if ((conditionalStyles = referenceDescription.getConditionalStyles()) != null && !conditionalStyles.isEmpty()) {
            ArrayList<EEFReferenceConditionalStyle> eefConditionalStyles = new ArrayList<EEFReferenceConditionalStyle>();
            for (ReferenceWidgetConditionalStyle conditionalStyle : conditionalStyles) {
                EEFReferenceConditionalStyle eefConditionalStyle = EefFactory.eINSTANCE.createEEFReferenceConditionalStyle();
                eefConditionalStyle.setPreconditionExpression(conditionalStyle.getPreconditionExpression());
                eefConditionalStyle.setStyle((EEFReferenceStyle)this.createEEFWidgetStyle((WidgetStyle)conditionalStyle.getStyle()));
                eefConditionalStyles.add(eefConditionalStyle);
            }
            if (eefConditionalStyles != null && !eefConditionalStyles.isEmpty()) {
                eefReferenceDescription.getConditionalStyles().addAll(eefConditionalStyles);
            }
        }
        return eefReferenceDescription;
    }

    private EEFCustomWidgetDescription createEEFCustomDescription(CustomDescription customDescription) {
        EList conditionalStyles;
        EEFCustomExpression eefCustomExpression;
        EEFCustomWidgetDescription eefCustomDescription = EefFactory.eINSTANCE.createEEFCustomWidgetDescription();
        eefCustomDescription.setIdentifier(customDescription.getIdentifier());
        eefCustomDescription.setLabelExpression(customDescription.getLabelExpression());
        for (CustomExpression customExpression : customDescription.getCustomExpressions()) {
            eefCustomExpression = EefFactory.eINSTANCE.createEEFCustomExpression();
            eefCustomExpression.setIdentifier(customExpression.getIdentifier());
            String expression = customExpression.getCustomExpression();
            eefCustomExpression.setCustomExpression(expression);
            eefCustomDescription.getCustomExpressions().add((Object)eefCustomExpression);
        }
        for (CustomOperation customOperation : customDescription.getCustomOperations()) {
            eefCustomExpression = EefFactory.eINSTANCE.createEEFCustomExpression();
            eefCustomExpression.setIdentifier(customOperation.getIdentifier());
            eefCustomExpression.setCustomExpression(this.getExpressionForOperation(customOperation.getInitialOperation()));
            eefCustomDescription.getCustomExpressions().add((Object)eefCustomExpression);
        }
        CustomWidgetStyle customStyle = customDescription.getStyle();
        if (customStyle != null) {
            eefCustomDescription.setStyle((EEFCustomWidgetStyle)this.createEEFWidgetStyle((WidgetStyle)customStyle));
        }
        if ((conditionalStyles = customDescription.getConditionalStyles()) != null && !conditionalStyles.isEmpty()) {
            ArrayList<EEFCustomWidgetConditionalStyle> eefConditionalStyles = new ArrayList<EEFCustomWidgetConditionalStyle>();
            for (CustomWidgetConditionalStyle conditionalStyle : conditionalStyles) {
                EEFCustomWidgetConditionalStyle eefConditionalStyle = EefFactory.eINSTANCE.createEEFCustomWidgetConditionalStyle();
                eefConditionalStyle.setPreconditionExpression(conditionalStyle.getPreconditionExpression());
                eefConditionalStyle.setStyle((EEFCustomWidgetStyle)this.createEEFWidgetStyle((WidgetStyle)conditionalStyle.getStyle()));
                eefConditionalStyles.add(eefConditionalStyle);
            }
            if (eefConditionalStyles != null && !eefConditionalStyles.isEmpty()) {
                eefCustomDescription.getConditionalStyles().addAll(eefConditionalStyles);
            }
        }
        return eefCustomDescription;
    }
}

