/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint.provider;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.ui.business.internal.dialect.LogThroughActiveDialectEditorLogListener;
import org.eclipse.sirius.ui.business.internal.session.GenericSWTCallBack;
import org.eclipse.sirius.ui.business.internal.session.factory.UISessionFactoryDescriptorRegistryListener;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.ui.tools.api.profiler.SiriusTasks;
import org.eclipse.sirius.ui.tools.api.properties.ISiriusPropertySheetPageProvider;
import org.eclipse.sirius.ui.tools.api.views.modelexplorerview.resourcelistener.IModelingProjectResourceListener;
import org.eclipse.sirius.ui.tools.internal.actions.analysis.IAddModelDependencyWizardRegistryListener;
import org.eclipse.sirius.ui.tools.internal.views.common.modelingproject.resourcelistener.ModelingProjectResourceListenerRegistry;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.extension.tab.ModelExplorerTabRegistryListener;
import org.eclipse.sirius.viewpoint.description.audit.provider.AuditItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.provider.DescriptionItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.style.provider.StyleItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.tool.provider.ToolItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.validation.provider.ValidationItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.provider.ViewpointItemProviderAdapterFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.osgi.framework.BundleContext;

public final class SiriusEditPlugin
extends EMFPlugin {
    public static final SiriusEditPlugin INSTANCE = new SiriusEditPlugin();
    public static final String ID = "org.eclipse.sirius.ui";
    private static Implementation plugin;

    public SiriusEditPlugin() {
        super(new ResourceLocator[]{EcoreEditPlugin.INSTANCE});
    }

    public ResourceLocator getPluginResourceLocator() {
        List overridingLocator = EclipseUtil.getExtensionPlugins(ResourceLocator.class, (String)"org.eclipse.sirius.ui.resourcelocator", (String)"class");
        if (overridingLocator.size() > 0) {
            return (ResourceLocator)overridingLocator.get(0);
        }
        return plugin;
    }

    public ResourceLocator getOriginalResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return ImageDescriptor.createFromURL((URL)((URL)this.getImage(key)));
    }

    static /* synthetic */ Implementation access$0() {
        return plugin;
    }

    public static class Implementation
    extends EclipseUIPlugin {
        private ComposedAdapterFactory adapterFactory;
        private Map<ImageDescriptor, Image> descriptorsToImages;
        private UICallBack uiCallback = new GenericSWTCallBack();
        private Multimap<String, ISiriusPropertySheetPageProvider> propertySheetPageProviders = HashMultimap.create();
        private ModelExplorerTabRegistryListener tabRegistryListener;
        private IModelingProjectResourceListener modelingProjectListener;
        private UISessionFactoryDescriptorRegistryListener uiSessionFactoryDescriptorRegistryListener;
        private IAddModelDependencyWizardRegistryListener resourceWizardRegistryListener;

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            this.initPreferences();
            this.adapterFactory = this.createAdapterFactory();
            this.descriptorsToImages = new HashMap<ImageDescriptor, Image>();
            this.startDesignerCorePreferencesManagement();
            this.tabRegistryListener = new ModelExplorerTabRegistryListener();
            this.tabRegistryListener.init();
            this.modelingProjectListener = ModelingProjectResourceListenerRegistry.getModelingProjectResourceListener();
            this.modelingProjectListener.init();
            this.uiSessionFactoryDescriptorRegistryListener = new UISessionFactoryDescriptorRegistryListener();
            this.uiSessionFactoryDescriptorRegistryListener.init();
            this.resourceWizardRegistryListener = new IAddModelDependencyWizardRegistryListener();
            this.resourceWizardRegistryListener.init();
            this.registerPropertySheetPageProviders();
            try {
                SiriusTasks.initSiriusTasks();
            }
            catch (IllegalArgumentException e) {
                Status status = new Status(4, SiriusEditPlugin.ID, 0, e.getMessage(), (Throwable)e);
                SiriusEditPlugin.getPlugin().getLog().log((IStatus)status);
            }
            EclipseUtil.getExtensionPlugins(ResourceLocator.class, (String)"org.eclipse.sirius.ui.resourcelocator", (String)"class");
            Platform.addLogListener((ILogListener)LogThroughActiveDialectEditorLogListener.INSTANCE);
        }

        private void registerPropertySheetPageProviders() {
            IConfigurationElement[] iConfigurationElementArray = EclipseUtil.getConfigurationElementsFor((String)"org.eclipse.sirius.ui.siriusPropertySheetPageProvider");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                try {
                    String contribId = ce.getAttribute("contributorId");
                    if (contribId != null) {
                        ISiriusPropertySheetPageProvider provider = (ISiriusPropertySheetPageProvider)ce.createExecutableExtension("class");
                        this.propertySheetPageProviders.put((Object)contribId, (Object)provider);
                    }
                }
                catch (CoreException e) {
                    this.getLog().log((IStatus)new Status(4, SiriusEditPlugin.ID, 0, e.getMessage(), (Throwable)e));
                }
                ++n2;
            }
        }

        private void startDesignerCorePreferencesManagement() {
            this.reflectAllPreferencesOnCore();
            this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    SiriusPreferencesKeys key = null;
                    SiriusPreferencesKeys[] siriusPreferencesKeysArray = SiriusPreferencesKeys.values();
                    int n = siriusPreferencesKeysArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SiriusPreferencesKeys currentKey = siriusPreferencesKeysArray[n2];
                        if (currentKey.name().equals(event.getProperty())) {
                            key = currentKey;
                        }
                        ++n2;
                    }
                    if (key != null) {
                        Implementation.this.reflectPreferencesOnCore(key);
                    }
                }
            });
        }

        private void reflectAllPreferencesOnCore() {
            SiriusPreferencesKeys[] siriusPreferencesKeysArray = SiriusPreferencesKeys.values();
            int n = siriusPreferencesKeysArray.length;
            int n2 = 0;
            while (n2 < n) {
                SiriusPreferencesKeys key = siriusPreferencesKeysArray[n2];
                this.reflectPreferencesOnCore(key);
                ++n2;
            }
        }

        private void initPreferences() {
            IPreferencesService service = Platform.getPreferencesService();
            int maxColorSize = service.getInt(SiriusEditPlugin.ID, "ColorRegistryMaxSize", 2048, null);
            int maxFontSize = service.getInt(SiriusEditPlugin.ID, "FontRegistryMaxSize", 256, null);
            VisualBindingManager.getDefault().init(maxColorSize, maxFontSize);
        }

        private void reflectPreferencesOnCore(SiriusPreferencesKeys key) {
            IPreferenceStore uiPreferenceStore = this.getPreferenceStore();
            IEclipsePreferences corePreferenceStore = InstanceScope.INSTANCE.getNode("org.eclipse.sirius");
            String keyName = key.name();
            if (key.getType() == Boolean.TYPE) {
                boolean uiValue = uiPreferenceStore.getBoolean(keyName);
                corePreferenceStore.putBoolean(keyName, uiValue);
            } else if (key.getType() == Integer.TYPE) {
                int uiValue = uiPreferenceStore.getInt(keyName);
                corePreferenceStore.putInt(keyName, uiValue);
            } else if (key.getType() == Long.TYPE) {
                long uiValue = uiPreferenceStore.getLong(keyName);
                corePreferenceStore.putLong(keyName, uiValue);
            } else if (key.getType() == Double.TYPE) {
                double uiValue = uiPreferenceStore.getDouble(keyName);
                corePreferenceStore.putDouble(keyName, uiValue);
            } else if (key.getType() == Float.TYPE) {
                float uiValue = uiPreferenceStore.getFloat(keyName);
                corePreferenceStore.putFloat(keyName, uiValue);
            } else if (key.getType() == String.class) {
                String uiValue = uiPreferenceStore.getString(keyName);
                corePreferenceStore.put(keyName, uiValue);
            }
        }

        public void stop(BundleContext context) throws Exception {
            try {
                this.adapterFactory.dispose();
                this.adapterFactory = null;
            }
            catch (NullPointerException nullPointerException) {}
            for (Image img : this.descriptorsToImages.values()) {
                if (img == null) continue;
                img.dispose();
            }
            this.tabRegistryListener.dispose();
            this.tabRegistryListener = null;
            this.modelingProjectListener.dispose();
            this.modelingProjectListener = null;
            this.uiSessionFactoryDescriptorRegistryListener.dispose();
            this.uiSessionFactoryDescriptorRegistryListener = null;
            this.resourceWizardRegistryListener.dispose();
            this.resourceWizardRegistryListener = null;
            Platform.removeLogListener((ILogListener)LogThroughActiveDialectEditorLogListener.INSTANCE);
            super.stop(context);
            VisualBindingManager.getDefault().dispose();
        }

        public static ImageDescriptor getBundledImageDescriptor(String path) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)SiriusEditPlugin.ID, (String)path);
        }

        public static ImageDescriptor findImageDescriptor(String path) {
            Path p = new Path(path);
            if (p.isAbsolute() && p.segmentCount() > 1) {
                return AbstractUIPlugin.imageDescriptorFromPlugin((String)p.segment(0), (String)p.removeFirstSegments(1).makeAbsolute().toString());
            }
            return Implementation.getBundledImageDescriptor(p.makeAbsolute().toString());
        }

        public Image getBundledImage(String path) {
            Image image = this.getImageRegistry().get(path);
            if (image == null) {
                this.getImageRegistry().put(path, Implementation.getBundledImageDescriptor(path));
                image = this.getImageRegistry().get(path);
            }
            return image;
        }

        public ImageDescriptor getItemImageDescriptor(Object item) {
            IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(item, IItemLabelProvider.class);
            if (labelProvider != null) {
                return ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage(item));
            }
            return null;
        }

        public String getItemText(Object item) {
            IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(item, IItemLabelProvider.class);
            if (labelProvider != null) {
                return labelProvider.getText(item);
            }
            return null;
        }

        public IPropertySheetPage getPropertySheetPage(Object source, String contributorId) {
            for (ISiriusPropertySheetPageProvider provider : this.propertySheetPageProviders.get((Object)contributorId)) {
                IPropertySheetPage page = provider.getPropertySheetPage(source, contributorId);
                if (page == null) continue;
                return page;
            }
            return null;
        }

        protected ComposedAdapterFactory createAdapterFactory() {
            ArrayList<ComposeableAdapterFactory> factories = new ArrayList<ComposeableAdapterFactory>();
            factories.add((ComposeableAdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
            this.fillItemProviderFactories(factories);
            return new ComposedAdapterFactory(factories);
        }

        protected void fillItemProviderFactories(List<ComposeableAdapterFactory> factories) {
            factories.add(new ViewpointItemProviderAdapterFactory());
            factories.add(new DescriptionItemProviderAdapterFactory());
            factories.add(new StyleItemProviderAdapterFactory());
            factories.add(new ToolItemProviderAdapterFactory());
            factories.add(new ValidationItemProviderAdapterFactory());
            factories.add(new AuditItemProviderAdapterFactory());
            factories.add((ComposeableAdapterFactory)new EcoreItemProviderAdapterFactory());
            factories.add((ComposeableAdapterFactory)new ResourceItemProviderAdapterFactory());
            factories.add((ComposeableAdapterFactory)new ReflectiveItemProviderAdapterFactory());
        }

        public AdapterFactory getItemProvidersAdapterFactory() {
            if (this.adapterFactory == null) {
                this.adapterFactory = this.createAdapterFactory();
            }
            return this.adapterFactory;
        }

        public Image getImage(ImageDescriptor desc) {
            if (!this.descriptorsToImages.containsKey(desc)) {
                this.descriptorsToImages.put(desc, desc.createImage());
            }
            return this.descriptorsToImages.get(desc);
        }

        public UICallBack getUiCallback() {
            return this.uiCallback;
        }

        public void setUiCallback(UICallBack uiCallback) {
            this.uiCallback = uiCallback;
        }
    }
}

