/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida.registry;

import com.google.common.base.Preconditions;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.sirius.business.api.query.ViewpointURIQuery;
import org.eclipse.sirius.business.internal.movida.Movida;
import org.eclipse.sirius.ext.base.Option;

public class ViewpointURIHandler
extends URIHandlerImpl.PlatformSchemeAware {
    private final ResourceSet resourceSet;

    public ViewpointURIHandler(ResourceSet resourceSet) {
        this.resourceSet = (ResourceSet)Preconditions.checkNotNull((Object)resourceSet);
    }

    public URI deresolve(URI uri) {
        Option<URI> viewpointURI;
        if (!this.baseURI.isPlatform() && "viewpoint".equals(this.baseURI.scheme())) {
            this.baseURI = this.resourceSet.getURIConverter().normalize(this.baseURI);
        }
        if (Movida.isEnabled() && (viewpointURI = ViewpointURIQuery.asViewpointURI(uri, this.resourceSet)).some()) {
            return (URI)viewpointURI.get();
        }
        return super.deresolve(uri);
    }
}

