/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint.impl;

import com.google.common.base.Splitter;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.internal.metamodel.spec.DViewSpec;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DAnalysisCustomData;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;
import org.eclipse.sirius.viewpoint.DFile;
import org.eclipse.sirius.viewpoint.DFolder;
import org.eclipse.sirius.viewpoint.DModel;
import org.eclipse.sirius.viewpoint.DProject;
import org.eclipse.sirius.viewpoint.DResourceContainer;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.Decoration;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.LabelAlignment;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.MetaModelExtension;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.SessionManagerEObject;
import org.eclipse.sirius.viewpoint.SyncStatus;
import org.eclipse.sirius.viewpoint.UIState;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.impl.BasicLabelStyleImpl;
import org.eclipse.sirius.viewpoint.impl.DAnalysisCustomDataImpl;
import org.eclipse.sirius.viewpoint.impl.DAnalysisImpl;
import org.eclipse.sirius.viewpoint.impl.DAnalysisSessionEObjectImpl;
import org.eclipse.sirius.viewpoint.impl.DFileImpl;
import org.eclipse.sirius.viewpoint.impl.DFolderImpl;
import org.eclipse.sirius.viewpoint.impl.DModelImpl;
import org.eclipse.sirius.viewpoint.impl.DProjectImpl;
import org.eclipse.sirius.viewpoint.impl.DResourceContainerImpl;
import org.eclipse.sirius.viewpoint.impl.DecorationImpl;
import org.eclipse.sirius.viewpoint.impl.LabelStyleImpl;
import org.eclipse.sirius.viewpoint.impl.MetaModelExtensionImpl;
import org.eclipse.sirius.viewpoint.impl.SessionManagerEObjectImpl;
import org.eclipse.sirius.viewpoint.impl.UIStateImpl;

public class ViewpointFactoryImpl
extends EFactoryImpl
implements ViewpointFactory {
    public static ViewpointFactory init() {
        try {
            ViewpointFactory theViewpointFactory = (ViewpointFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/sirius/1.1.0");
            if (theViewpointFactory != null) {
                return theViewpointFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ViewpointFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createDAnalysis();
            }
            case 8: {
                return this.createDView();
            }
            case 9: {
                return this.createMetaModelExtension();
            }
            case 10: {
                return this.createDecoration();
            }
            case 11: {
                return this.createDAnalysisCustomData();
            }
            case 12: {
                return this.createLabelStyle();
            }
            case 14: {
                return this.createDAnalysisSessionEObject();
            }
            case 15: {
                return this.createSessionManagerEObject();
            }
            case 17: {
                return this.createDFile();
            }
            case 18: {
                return this.createDResourceContainer();
            }
            case 19: {
                return this.createDProject();
            }
            case 20: {
                return this.createDFolder();
            }
            case 21: {
                return this.createDModel();
            }
            case 22: {
                return this.createBasicLabelStyle();
            }
            case 24: {
                return this.createUIState();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 25: {
                return this.createFontFormatFromString(eDataType, initialValue);
            }
            case 26: {
                return this.createLabelAlignmentFromString(eDataType, initialValue);
            }
            case 27: {
                return this.createSyncStatusFromString(eDataType, initialValue);
            }
            case 28: {
                return this.createRGBValuesFromString(eDataType, initialValue);
            }
            case 29: {
                return this.createResourceDescriptorFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 25: {
                return this.convertFontFormatToString(eDataType, instanceValue);
            }
            case 26: {
                return this.convertLabelAlignmentToString(eDataType, instanceValue);
            }
            case 27: {
                return this.convertSyncStatusToString(eDataType, instanceValue);
            }
            case 28: {
                return this.convertRGBValuesToString(eDataType, instanceValue);
            }
            case 29: {
                return this.convertResourceDescriptorToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public DAnalysis createDAnalysis() {
        DAnalysisImpl dAnalysis = new DAnalysisImpl();
        return dAnalysis;
    }

    @Override
    public DView createDView() {
        DViewSpec dView = new DViewSpec();
        return dView;
    }

    @Override
    public MetaModelExtension createMetaModelExtension() {
        MetaModelExtensionImpl metaModelExtension = new MetaModelExtensionImpl();
        return metaModelExtension;
    }

    @Override
    public Decoration createDecoration() {
        DecorationImpl decoration = new DecorationImpl();
        return decoration;
    }

    @Override
    public DAnalysisCustomData createDAnalysisCustomData() {
        DAnalysisCustomDataImpl dAnalysisCustomData = new DAnalysisCustomDataImpl();
        return dAnalysisCustomData;
    }

    @Override
    public LabelStyle createLabelStyle() {
        LabelStyleImpl labelStyle = new LabelStyleImpl();
        return labelStyle;
    }

    @Override
    public DAnalysisSessionEObject createDAnalysisSessionEObject() {
        DAnalysisSessionEObjectImpl dAnalysisSessionEObject = new DAnalysisSessionEObjectImpl();
        return dAnalysisSessionEObject;
    }

    @Override
    public SessionManagerEObject createSessionManagerEObject() {
        SessionManagerEObjectImpl sessionManagerEObject = new SessionManagerEObjectImpl();
        return sessionManagerEObject;
    }

    @Override
    public DFile createDFile() {
        DFileImpl dFile = new DFileImpl();
        return dFile;
    }

    @Override
    public DResourceContainer createDResourceContainer() {
        DResourceContainerImpl dResourceContainer = new DResourceContainerImpl();
        return dResourceContainer;
    }

    @Override
    public DProject createDProject() {
        DProjectImpl dProject = new DProjectImpl();
        return dProject;
    }

    @Override
    public DFolder createDFolder() {
        DFolderImpl dFolder = new DFolderImpl();
        return dFolder;
    }

    @Override
    public DModel createDModel() {
        DModelImpl dModel = new DModelImpl();
        return dModel;
    }

    @Override
    public BasicLabelStyle createBasicLabelStyle() {
        BasicLabelStyleImpl basicLabelStyle = new BasicLabelStyleImpl();
        return basicLabelStyle;
    }

    @Override
    public UIState createUIState() {
        UIStateImpl uiState = new UIStateImpl();
        return uiState;
    }

    public FontFormat createFontFormatFromString(EDataType eDataType, String initialValue) {
        FontFormat result = FontFormat.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertFontFormatToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public LabelAlignment createLabelAlignmentFromString(EDataType eDataType, String initialValue) {
        LabelAlignment result = LabelAlignment.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertLabelAlignmentToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public SyncStatus createSyncStatusFromString(EDataType eDataType, String initialValue) {
        SyncStatus result = SyncStatus.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSyncStatusToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RGBValues createRGBValuesFromString(EDataType eDataType, String initialValue) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (!StringUtil.isEmpty((String)initialValue)) {
            Iterator it = Splitter.on((char)',').split((CharSequence)initialValue).iterator();
            if (it.hasNext()) {
                r = this.toInt((String)it.next());
            }
            if (it.hasNext()) {
                g = this.toInt((String)it.next());
            }
            if (it.hasNext()) {
                b = this.toInt((String)it.next());
            }
        }
        return RGBValues.create(r, g, b);
    }

    private int toInt(String next) {
        if (next.length() > 0) {
            try {
                return Integer.valueOf(next);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return 0;
    }

    public String convertRGBValuesToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue instanceof RGBValues) {
            return instanceValue.toString();
        }
        return super.convertToString(eDataType, instanceValue);
    }

    public ResourceDescriptor createResourceDescriptorFromString(EDataType eDataType, String initialValue) {
        return (ResourceDescriptor)super.createFromString(eDataType, initialValue);
    }

    public String convertResourceDescriptorToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public ViewpointPackage getViewpointPackage() {
        return (ViewpointPackage)this.getEPackage();
    }

    @Deprecated
    public static ViewpointPackage getPackage() {
        return ViewpointPackage.eINSTANCE;
    }

    @Override
    public RGBValues createRGBValues() {
        return RGBValues.create(0, 0, 0);
    }
}

