/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.serialization.generators.xsd;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.serialization.XMLPersistenceMappingExtendedMetaData;
import org.eclipse.sphinx.emf.serialization.generators.util.Ecore2XSDUtil;
import org.eclipse.sphinx.emf.serialization.generators.util.IGeneratorConstants;
import org.eclipse.sphinx.emf.serialization.generators.util.JavaXSDPrimitiveTypeMapping;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDPatternFacet;
import org.eclipse.xsd.XSDProcessContents;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.ecore.NameMangler;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class Ecore2XSDFactory
extends NameMangler {
    protected String defaultXMLSchemaNamespace = "http://www.w3.org/2001/XMLSchema";
    protected String defaultXMLNamespace = "http://www.w3.org/XML/1998/namespace";
    protected XMLPersistenceMappingExtendedMetaData xsdExtendedMetaData = XMLPersistenceMappingExtendedMetaData.INSTANCE;
    protected static XSDFactory xsdFactory = XSDFactory.eINSTANCE;
    public Set<String> patternCaseSet = new HashSet<String>();
    public Set<EPackage> referencedEcores = new HashSet<EPackage>();
    public Map<String, String> nsSchemaLocations = new HashMap<String, String>();
    protected String defaultUserSchemaNamespace;
    public EPackage ecoreModel;
    private final HashMap<ArrayList<?>, XSDImport> _createCache_createXSDImport = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, XSDComplexTypeDefinition> _createCache_createClassTypeDefinition5 = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, XSDSimpleTypeDefinition> _createCache_createEnumSchema6 = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, XSDSimpleTypeDefinition> _createCache_createSimpleType8 = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, XSDParticle> _createCache_createXSDParticleForFeatureCase0010 = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, XSDParticle> _createCache_createXSDParticleForFeatureCase0012 = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, XSDParticle> _createCache_createXSDParticleForFeatureCase0013 = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, XSDParticle> _createCache_createXSDParticleForFeatureCase0023 = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    public Ecore2XSDFactory(EPackage ecoreModel) {
        this.ecoreModel = ecoreModel;
    }

    public XSDSchema initSchema(EPackage ePackage, ResourceSet resourceSet, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        progress.subTask("Initialize XSD schema");
        XSDSchema xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
        String targetNamespace = this.xsdExtendedMetaData.getNamespace(ePackage);
        xsdSchema.setTargetNamespace(targetNamespace);
        Map namespaces = xsdSchema.getQNamePrefixToNamespaceMap();
        xsdSchema.setSchemaForSchemaQNamePrefix("xsd");
        namespaces.put("xsd", this.defaultXMLSchemaNamespace);
        String nsPrefix = this.getRootNsPrefix(ePackage);
        Ecore2XSDUtil.handlePrefix(namespaces, nsPrefix, targetNamespace);
        xsdSchema.setElementFormDefault(XSDForm.QUALIFIED_LITERAL);
        xsdSchema.setAttributeFormDefault(XSDForm.UNQUALIFIED_LITERAL);
        xsdSchema.updateElement();
        this.initSchemaImports(ePackage, xsdSchema, monitor);
        this.defaultUserSchemaNamespace = targetNamespace;
        progress.done();
        return xsdSchema;
    }

    protected void initSchemaImports(EPackage ePackage, final XSDSchema xsdSchema, IProgressMonitor monitor) {
        Map externalSchemaLocations = this.xsdExtendedMetaData.getXMLExternalSchemaLocations(ePackage);
        Set<EPackage> referencedEcores = this.getReferencedEcoreRootPackages(monitor);
        Consumer<EPackage> _function = new Consumer<EPackage>(){

            @Override
            public void accept(EPackage it) {
                String namespace = Ecore2XSDFactory.this.getGlobalXSDSchemaNamespace(it);
                String schemaLocation = Ecore2XSDFactory.this.getSchemaLocation(it);
                Ecore2XSDFactory.this.nsSchemaLocations.put(namespace, schemaLocation);
            }
        };
        referencedEcores.forEach(_function);
        this.nsSchemaLocations.putAll(externalSchemaLocations);
        ArrayList<String> orderedNs = new ArrayList<String>();
        Set<String> _keySet = this.nsSchemaLocations.keySet();
        orderedNs.addAll(_keySet);
        Collections.sort(orderedNs);
        Consumer<String> _function_1 = new Consumer<String>(){

            @Override
            public void accept(String it) {
                EList _contents = xsdSchema.getContents();
                String _get = Ecore2XSDFactory.this.nsSchemaLocations.get(it);
                XSDImport _createXSDImport = Ecore2XSDFactory.this.createXSDImport(it, _get);
                _contents.add((Object)_createXSDImport);
            }
        };
        orderedNs.forEach(_function_1);
    }

    protected String getRootNsPrefix(EPackage ePackage) {
        return ePackage.getNsPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDImport createXSDImport(String nameSpace, String schemaLocation) {
        XSDImport _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new String[]{nameSpace, schemaLocation});
        HashMap<ArrayList<?>, XSDImport> hashMap = this._createCache_createXSDImport;
        synchronized (hashMap) {
            XSDImport _createXSDImport;
            if (this._createCache_createXSDImport.containsKey(_cacheKey)) {
                return this._createCache_createXSDImport.get(_cacheKey);
            }
            _result = _createXSDImport = xsdFactory.createXSDImport();
            this._createCache_createXSDImport.put(_cacheKey, _result);
        }
        this._init_createXSDImport(_result, nameSpace, schemaLocation);
        return _result;
    }

    private void _init_createXSDImport(XSDImport xsdImport, String nameSpace, String schemaLocation) {
        xsdImport.setNamespace(nameSpace);
        xsdImport.setSchemaLocation(schemaLocation);
    }

    protected String getTypeXMLName(String xmlName, ENamedElement eElement) {
        String _namespace;
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)eElement);
        EPackage rootPackage = (EPackage)_rootContainer;
        String nsURI = rootPackage.getNsURI();
        boolean _equals = nsURI.equals(_namespace = this.xsdExtendedMetaData.getNamespace(this.ecoreModel));
        if (_equals) {
            return xmlName;
        }
        boolean _equals_1 = nsURI.equals("http://www.eclipse.org/emf/2002/Ecore");
        if (_equals_1) {
            return xmlName;
        }
        boolean _contains = this.referencedEcores.contains(rootPackage);
        if (_contains) {
            String result = Ecore2XSDUtil.getSingularName(eElement);
            return result;
        }
        return Ecore2XSDUtil.getSingularName(eElement);
    }

    protected String getGlobalXSDSchemaNamespace(EPackage rootPackage) {
        try {
            boolean _notEquals;
            String namespace = rootPackage.getNsURI();
            java.net.URI namespaceURI = new java.net.URI(namespace);
            IMetaModelDescriptor mmDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(namespaceURI);
            boolean bl = _notEquals = !Objects.equal((Object)mmDescriptor, null);
            if (_notEquals) {
                String _string;
                java.net.URI _namespaceURI = mmDescriptor.getNamespaceURI();
                namespace = _string = _namespaceURI.toString();
            }
            return namespace;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String getSchemaLocation(EPackage referencedRootPackage) {
        String namespace = this.getGlobalXSDSchemaNamespace(referencedRootPackage);
        String schemaLocation = this.xsdExtendedMetaData.getXMLSchemaLocation(referencedRootPackage);
        boolean _equals = Objects.equal(null, (Object)schemaLocation);
        if (_equals) {
            boolean _equals_1 = namespace.equals("http://www.eclipse.org/emf/2002/Ecore");
            if (_equals_1) {
                schemaLocation = "platform:/plugin/org.eclipse.emf.ecore/model/Ecore.xsd";
            } else {
                boolean _notEquals;
                URI uri = this.getXSDSchemaFileURIFromNsURI(namespace);
                boolean bl = _notEquals = !Objects.equal((Object)uri, null);
                if (_notEquals) {
                    String _string;
                    schemaLocation = _string = uri.toString();
                } else {
                    String _plus;
                    String _name = referencedRootPackage.getName();
                    schemaLocation = _plus = String.valueOf(_name) + "xsd";
                }
            }
        }
        return schemaLocation;
    }

    protected void loadImportReferencedXSD(EPackage referencedRootPackage, XSDSchema xsdSchema, ResourceSet resourceSet) {
        String namespace = this.getGlobalXSDSchemaNamespace(referencedRootPackage);
        String schemaLocation = this.xsdExtendedMetaData.getXMLSchemaLocation(referencedRootPackage);
        boolean _equals = Objects.equal(null, (Object)schemaLocation);
        if (_equals) {
            boolean _equals_1 = namespace.equals("http://www.eclipse.org/emf/2002/Ecore");
            if (_equals_1) {
                schemaLocation = "platform:/plugin/org.eclipse.emf.ecore/model/Ecore.xsd";
            } else {
                boolean _notEquals;
                URI uri = this.getXSDSchemaFileURIFromNsURI(namespace);
                boolean bl = _notEquals = !Objects.equal((Object)uri, null);
                if (_notEquals) {
                    String _string;
                    schemaLocation = _string = uri.toString();
                } else {
                    String _plus;
                    String _name = referencedRootPackage.getName();
                    schemaLocation = _plus = String.valueOf(_name) + "xsd";
                }
            }
        }
        XSDImport xsdImport = this.createXSDImport(namespace, schemaLocation);
        EList _contents = xsdSchema.getContents();
        _contents.add((Object)xsdImport);
    }

    protected URI getXSDSchemaFileURIFromNsURI(String nsURI) {
        Path path = new Path("C:/Work/Eclipse-Kepler/runtime-EclipseApplication-Kepler/xsd.generator.test/model/referenced/hummingbird20.xsd");
        return EcorePlatformUtil.createURI((IPath)path);
    }

    protected Set<EPackage> getReferencedEcoreRootPackages(IProgressMonitor monitor) {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        final String targetNamespace = this.xsdExtendedMetaData.getNamespace(this.ecoreModel);
        TreeIterator _eAllContents = this.ecoreModel.eAllContents();
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
                EClassifier eType;
                EObject container;
                if (it instanceof EClass) {
                    EList _eSuperTypes = ((EClass)it).getESuperTypes();
                    Consumer<EClass> _function = new Consumer<EClass>(){

                        @Override
                        public void accept(EClass it) {
                            boolean _notEquals;
                            EObject _rootContainer = EcoreUtil.getRootContainer((EObject)it);
                            EPackage rootEPackage = (EPackage)_rootContainer;
                            String uri = rootEPackage.getNsURI();
                            boolean bl = _notEquals = !Objects.equal((Object)uri, (Object)targetNamespace);
                            if (_notEquals) {
                                (this).Ecore2XSDFactory.this.referencedEcores.add(rootEPackage);
                            }
                        }
                    };
                    _eSuperTypes.forEach((Consumer)_function);
                } else if (it instanceof EStructuralFeature && (container = EcoreUtil.getRootContainer((EObject)(eType = ((EStructuralFeature)it).getEType()))) instanceof EPackage) {
                    boolean _notEquals;
                    String uri = ((EPackage)container).getNsURI();
                    boolean bl = _notEquals = !Objects.equal((Object)uri, (Object)targetNamespace);
                    if (_notEquals) {
                        boolean _equals_1;
                        boolean _or = false;
                        boolean _equals = uri.equals("http://www.eclipse.org/emf/2002/Ecore");
                        _or = _equals ? true : (_equals_1 = "http://www.eclipse.org/emf/2003/XMLType".equals(uri));
                        if (!_or) {
                            Ecore2XSDFactory.this.referencedEcores.add((EPackage)container);
                        }
                    }
                }
                progress.worked(1);
                boolean _isCanceled = progress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        IteratorExtensions.forEach((Iterator)_eAllContents, (Procedures.Procedure1)_function);
        return this.referencedEcores;
    }

    protected String getElementXSDURI(EClassifier eClassifier) {
        boolean _notEquals;
        String _typeXMLName;
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)eClassifier);
        EPackage rootEPackage = (EPackage)_rootContainer;
        String namespace = this.xsdExtendedMetaData.getNamespace(rootEPackage);
        String result = this.xsdExtendedMetaData.getXMLName(eClassifier);
        result = _typeXMLName = this.getTypeXMLName(result, (ENamedElement)eClassifier);
        boolean bl = _notEquals = !Objects.equal((Object)namespace, null);
        if (_notEquals) {
            result = String.valueOf(namespace) + "#" + result;
        }
        return result;
    }

    protected String getQualifiedRootPackageName(EPackage ePackage) {
        return this.ecoreModel.getName();
    }

    protected List<EStructuralFeature> getEAllRelevantStructuralFeatures(EClass eClass) {
        return eClass.getEAllStructuralFeatures();
    }

    public void createGlobalElement3(EPackage rootEPackageModel, final XSDSchema xsdSchema) {
        List<EClassifier> globalEClassifiers = Ecore2XSDUtil.getGlobalElements(rootEPackageModel);
        Consumer<EClassifier> _function = new Consumer<EClassifier>(){

            @Override
            public void accept(EClassifier it) {
                XSDElementDeclaration xsdGlobalElement = xsdFactory.createXSDElementDeclaration();
                String _xMLName = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLName(it);
                xsdGlobalElement.setName(_xMLName);
                String uri = Ecore2XSDFactory.this.getElementXSDURI(it);
                XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(uri);
                xsdGlobalElement.setTypeDefinition(xsdTypeDefinition);
                EList _contents = xsdSchema.getContents();
                _contents.add((Object)xsdGlobalElement);
            }
        };
        globalEClassifiers.forEach(_function);
    }

    public void createFixedRefTypes4(XSDSchema xsdSchema) {
        XSDSimpleTypeDefinition simpleTypeLocal = xsdFactory.createXSDSimpleTypeDefinition();
        simpleTypeLocal.setName("LOCAL-REF");
        XSDTypeDefinition baseTypeLocal = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#IDREF");
        simpleTypeLocal.setBaseTypeDefinition((XSDSimpleTypeDefinition)baseTypeLocal);
        EList _contents = xsdSchema.getContents();
        _contents.add((Object)simpleTypeLocal);
        XSDSimpleTypeDefinition simpleTypeGlobal = xsdFactory.createXSDSimpleTypeDefinition();
        simpleTypeGlobal.setName("GLOBAL-REF");
        XSDTypeDefinition baseTypeGlobal = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        simpleTypeGlobal.setBaseTypeDefinition((XSDSimpleTypeDefinition)baseTypeGlobal);
        EList _contents_1 = xsdSchema.getContents();
        _contents_1.add((Object)simpleTypeGlobal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDComplexTypeDefinition createClassTypeDefinition5(EClass eClass, XSDSchema xsdSchema, ArrayList<EClass> referencedClass, IProgressMonitor monitor) {
        XSDComplexTypeDefinition _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{eClass, xsdSchema, referencedClass, monitor});
        HashMap<ArrayList<?>, XSDComplexTypeDefinition> hashMap = this._createCache_createClassTypeDefinition5;
        synchronized (hashMap) {
            XSDComplexTypeDefinition _createXSDComplexTypeDefinition;
            if (this._createCache_createClassTypeDefinition5.containsKey(_cacheKey)) {
                return this._createCache_createClassTypeDefinition5.get(_cacheKey);
            }
            _result = _createXSDComplexTypeDefinition = xsdFactory.createXSDComplexTypeDefinition();
            this._createCache_createClassTypeDefinition5.put(_cacheKey, _result);
        }
        this._init_createClassTypeDefinition5(_result, eClass, xsdSchema, referencedClass, monitor);
        return _result;
    }

    private void _init_createClassTypeDefinition5(final XSDComplexTypeDefinition xsdComplexTypeDefinition, final EClass eClass, final XSDSchema xsdSchema, final ArrayList<EClass> referencedClass, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        String _name = eClass.getName();
        String _plus = "create XSD Complex Type Definition for " + _name;
        progress.subTask(_plus);
        String _xMLName = this.xsdExtendedMetaData.getXMLName((EClassifier)eClass);
        xsdComplexTypeDefinition.setName(_xMLName);
        XSDParticle xsdParticle = XSDFactory.eINSTANCE.createXSDParticle();
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle);
        final XSDModelGroup xsdModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        xsdParticle.setContent((XSDParticleContent)xsdModelGroup);
        List<EStructuralFeature> relevantStructuralFeatures = this.getEAllRelevantStructuralFeatures(eClass);
        SubMonitor _newChild = progress.newChild(100);
        int _size = relevantStructuralFeatures.size();
        final SubMonitor subProgress = _newChild.setWorkRemaining(_size);
        Consumer<EStructuralFeature> _function = new Consumer<EStructuralFeature>(){

            @Override
            public void accept(EStructuralFeature it) {
                XSDParticle xsdParticleForFeature = null;
                int _featureKind = ExtendedMetaData.INSTANCE.getFeatureKind(it);
                boolean _equals = Integer.valueOf(4).equals(_featureKind);
                if (_equals) {
                    boolean _notEquals;
                    if (it instanceof EAttribute) {
                        XSDParticle _switchResult = null;
                        int _xMLPersistenceMappingStrategy = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLPersistenceMappingStrategy(it);
                        switch (_xMLPersistenceMappingStrategy) {
                            case 4: {
                                _switchResult = Ecore2XSDFactory.this.createClassElementAttribute5a((EAttribute)it, xsdSchema);
                                break;
                            }
                            case 12: {
                                _switchResult = Ecore2XSDFactory.this.createEAttributeContained1100((EAttribute)it, xsdSchema);
                                break;
                            }
                            default: {
                                Object _xblockexpression = null;
                                int _xMLPersistenceMappingStrategy_1 = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLPersistenceMappingStrategy(it);
                                String _plus = "Not supported: EAttribute " + Integer.valueOf(_xMLPersistenceMappingStrategy_1);
                                System.err.println(_plus);
                                _xblockexpression = null;
                                _switchResult = _xblockexpression;
                            }
                        }
                        xsdParticleForFeature = _switchResult;
                    } else if (it instanceof EReference) {
                        boolean _isContainment = ((EReference)it).isContainment();
                        if (_isContainment) {
                            XSDParticle _switchResult_1 = null;
                            int _xMLPersistenceMappingStrategy_1 = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLPersistenceMappingStrategy(it);
                            switch (_xMLPersistenceMappingStrategy_1) {
                                case 4: {
                                    _switchResult_1 = Ecore2XSDFactory.this.create_EReference_contained0100(it, eClass, xsdSchema);
                                    break;
                                }
                                case 5: {
                                    _switchResult_1 = Ecore2XSDFactory.this.create_EReference_contained0101(it, eClass, xsdSchema);
                                    break;
                                }
                                case 9: {
                                    _switchResult_1 = Ecore2XSDFactory.this.create_EReference_contained1001(it, eClass, xsdSchema);
                                    break;
                                }
                                case 12: {
                                    _switchResult_1 = Ecore2XSDFactory.this.create_EReference_contained1100(it, eClass, xsdSchema);
                                    break;
                                }
                                default: {
                                    _switchResult_1 = null;
                                }
                            }
                            xsdParticleForFeature = _switchResult_1;
                        } else {
                            XSDParticle _switchResult_2 = null;
                            int _xMLPersistenceMappingStrategy_2 = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLPersistenceMappingStrategy(it);
                            switch (_xMLPersistenceMappingStrategy_2) {
                                case 9: {
                                    _switchResult_2 = Ecore2XSDFactory.this.createClassComposition5b(it, eClass);
                                    break;
                                }
                                case 12: {
                                    _switchResult_2 = Ecore2XSDFactory.this.create_EReference_referenced1100Many_5l(it, eClass, xsdSchema, referencedClass);
                                    break;
                                }
                                case 4: {
                                    _switchResult_2 = Ecore2XSDFactory.this.create_EReference_referenced0100Many_5m(it, eClass, xsdSchema, referencedClass);
                                    break;
                                }
                                default: {
                                    _switchResult_2 = null;
                                }
                            }
                            xsdParticleForFeature = _switchResult_2;
                        }
                    }
                    boolean bl = _notEquals = !Objects.equal(null, xsdParticleForFeature);
                    if (_notEquals) {
                        EList _contents = xsdModelGroup.getContents();
                        _contents.add(xsdParticleForFeature);
                    }
                } else {
                    int _featureKind_1 = ExtendedMetaData.INSTANCE.getFeatureKind(it);
                    boolean _equals_1 = Integer.valueOf(2).equals(_featureKind_1);
                    if (_equals_1 && it instanceof EAttribute) {
                        XSDAttributeUse xsdAttributeUse = Ecore2XSDFactory.this.createClassAttribute5d((EAttribute)it, eClass, xsdSchema);
                        EList _attributeContents = xsdComplexTypeDefinition.getAttributeContents();
                        _attributeContents.add((Object)xsdAttributeUse);
                    }
                }
                subProgress.worked(1);
                boolean _isCanceled = subProgress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        relevantStructuralFeatures.forEach(_function);
        EList _contents = xsdSchema.getContents();
        _contents.add((Object)xsdComplexTypeDefinition);
    }

    public XSDParticle createClassElementAttribute5a(EAttribute eAttribute, XSDSchema xsdSchema) {
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        int _lowerBound = eAttribute.getLowerBound();
        xsdParticle.setMinOccurs(_lowerBound);
        int _upperBound = eAttribute.getUpperBound();
        xsdParticle.setMaxOccurs(_upperBound);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        String _xMLName = this.xsdExtendedMetaData.getXMLName((EStructuralFeature)eAttribute);
        xsdElement.setName(_xMLName);
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        EDataType baseType = eAttribute.getEAttributeType();
        boolean _and = false;
        if (!(baseType instanceof EDataType)) {
            _and = false;
        } else {
            Boolean _isXMLPrimitiveXsdType = this.isXMLPrimitiveXsdType(baseType);
            _and = _isXMLPrimitiveXsdType;
        }
        if (_and) {
            XSDTypeDefinition _resolveTypeDefinitionURI;
            String xsdSimpleType = this.getXsdSimpleType((EClassifier)baseType);
            xsdTypeDefinition = _resolveTypeDefinitionURI = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#" + xsdSimpleType);
        } else {
            XSDTypeDefinition _resolveTypeDefinitionURI_1;
            String uri = this.getElementXSDURI((EClassifier)baseType);
            xsdTypeDefinition = _resolveTypeDefinitionURI_1 = xsdSchema.resolveTypeDefinitionURI(uri);
        }
        xsdElement.setTypeDefinition(xsdTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle createEAttributeContained1100(EAttribute eAttribute, XSDSchema xsdSchema) {
        boolean _greaterThan;
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        int _lowerBound = eAttribute.getLowerBound();
        boolean bl = _greaterThan = _lowerBound > 0;
        if (_greaterThan) {
            xsdParticle.setMinOccurs(1);
        } else {
            xsdParticle.setMinOccurs(0);
        }
        xsdParticle.setMaxOccurs(1);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        String _xMLWrapperName = this.xsdExtendedMetaData.getXMLWrapperName((EStructuralFeature)eAttribute);
        xsdElement.setName(_xMLWrapperName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        int _upperBound = eAttribute.getUpperBound();
        xsdParticle2.setMaxOccurs(_upperBound);
        int _lowerBound_1 = eAttribute.getLowerBound();
        xsdParticle2.setMinOccurs(_lowerBound_1);
        XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EDataType datatype = eAttribute.getEAttributeType();
        XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        String _xMLName = this.xsdExtendedMetaData.getXMLName((EStructuralFeature)eAttribute);
        xsdElement2.setName(_xMLName);
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        Boolean _isXMLPrimitiveXsdType = this.isXMLPrimitiveXsdType(datatype);
        if (_isXMLPrimitiveXsdType.booleanValue()) {
            XSDTypeDefinition _resolveTypeDefinitionURI;
            String xsdSimpleType = this.getXsdSimpleType((EClassifier)datatype);
            xsdTypeDefinition = _resolveTypeDefinitionURI = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#" + xsdSimpleType);
        } else {
            XSDTypeDefinition _resolveTypeDefinitionURI_1;
            String uri = this.getElementXSDURI((EClassifier)datatype);
            xsdTypeDefinition = _resolveTypeDefinitionURI_1 = xsdSchema.resolveTypeDefinitionURI(uri);
        }
        xsdElement2.setTypeDefinition(xsdTypeDefinition);
        xsdParticle3.setContent((XSDParticleContent)xsdElement2);
        EList _contents = xsdModelGroup2.getContents();
        _contents.add((Object)xsdParticle3);
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle createClassComposition5b(EStructuralFeature feature, EClass eClass) {
        boolean _greaterThan;
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        int _lowerBound = feature.getLowerBound();
        boolean bl = _greaterThan = _lowerBound > 0;
        if (_greaterThan) {
            xsdParticle.setMinOccurs(1);
        } else {
            xsdParticle.setMinOccurs(0);
        }
        xsdParticle.setMaxOccurs(1);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        String _xMLName = this.xsdExtendedMetaData.getXMLName(feature);
        xsdElement.setName(_xMLName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        int _upperBound = feature.getUpperBound();
        xsdParticle2.setMaxOccurs(_upperBound);
        int _lowerBound_1 = feature.getLowerBound();
        xsdParticle2.setMinOccurs(_lowerBound_1);
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeeClassifier = feature.getEType();
        XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement2.setName("xxxxxxxx");
        String typeeClassifierURI = this.getElementXSDURI(typeeClassifier);
        XSDTypeDefinition xsdTypeDefinition = xsdElement2.resolveTypeDefinitionURI(typeeClassifierURI);
        xsdElement2.setTypeDefinition(xsdTypeDefinition);
        xsdParticle3.setContent((XSDParticleContent)xsdElement2);
        EList _contents = xsdModelGroup2.getContents();
        _contents.add((Object)xsdParticle3);
        if (typeeClassifier instanceof EClass) {
            List<EClass> _findESubTypesOf = Ecore2XSDUtil.findESubTypesOf((EClass)typeeClassifier);
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle xsdParticleSubType = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration xsdElementSubType = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    String _xMLName = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLName((EClassifier)it);
                    xsdElementSubType.setName(_xMLName);
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDTypeDefinition xsdTypeDefinitionSubType = xsdElementSubType.resolveTypeDefinitionURI(subTypeURI);
                    xsdElementSubType.setTypeDefinition(xsdTypeDefinitionSubType);
                    xsdParticleSubType.setContent((XSDParticleContent)xsdElementSubType);
                    EList _contents = xsdModelGroup2.getContents();
                    _contents.add((Object)xsdParticleSubType);
                }
            };
            _findESubTypesOf.forEach(_function);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle create_EReference_contained1001(final EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        boolean _greaterThan;
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        int _lowerBound = feature.getLowerBound();
        boolean bl = _greaterThan = _lowerBound > 0;
        if (_greaterThan) {
            xsdParticle.setMinOccurs(1);
        } else {
            xsdParticle.setMinOccurs(0);
        }
        xsdParticle.setMaxOccurs(1);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        String _xMLWrapperName = this.xsdExtendedMetaData.getXMLWrapperName(feature);
        xsdElement.setName(_xMLWrapperName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        int _upperBound = feature.getUpperBound();
        xsdParticle2.setMaxOccurs(_upperBound);
        int _lowerBound_1 = feature.getLowerBound();
        xsdParticle2.setMinOccurs(_lowerBound_1);
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeEClassifier = feature.getEType();
        if (typeEClassifier instanceof EClass) {
            List<EClass> _findAllConcreteTypes = Ecore2XSDUtil.findAllConcreteTypes((EClass)typeEClassifier, null);
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle xsdParticleSubType = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration xsdElementSubType = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    String _xMLName = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLName((EClassifier)it, feature);
                    String subClassXMLName = Ecore2XSDFactory.this.getTypeXMLName(_xMLName, (ENamedElement)it);
                    xsdElementSubType.setName(subClassXMLName);
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDTypeDefinition xsdTypeDefinitionSubType = xsdElementSubType.resolveTypeDefinitionURI(subTypeURI);
                    xsdElementSubType.setTypeDefinition(xsdTypeDefinitionSubType);
                    xsdParticleSubType.setContent((XSDParticleContent)xsdElementSubType);
                    EList _contents = xsdModelGroup2.getContents();
                    _contents.add((Object)xsdParticleSubType);
                }
            };
            _findAllConcreteTypes.forEach(_function);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle createClassComposition5c0101(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        int _lowerBound = feature.getLowerBound();
        xsdParticle.setMinOccurs(_lowerBound);
        int _upperBound = feature.getUpperBound();
        xsdParticle.setMaxOccurs(_upperBound);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        String _xMLWrapperName = this.xsdExtendedMetaData.getXMLWrapperName(feature);
        xsdElement.setName(_xMLWrapperName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        int _lowerBound_1 = feature.getLowerBound();
        xsdParticle2.setMinOccurs(_lowerBound_1);
        xsdParticle2.setMaxOccurs(1);
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeEClassifier = feature.getEType();
        XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        String _name = this.xsdExtendedMetaData.getName(typeEClassifier);
        xsdElement2.setName(_name);
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        boolean _and = false;
        if (!(typeEClassifier instanceof EDataType)) {
            _and = false;
        } else {
            Boolean _isXMLPrimitiveXsdType = this.isXMLPrimitiveXsdType((EDataType)typeEClassifier);
            _and = _isXMLPrimitiveXsdType;
        }
        if (_and) {
            XSDTypeDefinition _resolveTypeDefinitionURI;
            String xsdSimpleType = this.getXsdSimpleType(typeEClassifier);
            xsdTypeDefinition = _resolveTypeDefinitionURI = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#" + xsdSimpleType);
        } else {
            XSDTypeDefinition _resolveTypeDefinitionURI_1;
            String uri = this.getElementXSDURI(typeEClassifier);
            xsdTypeDefinition = _resolveTypeDefinitionURI_1 = xsdSchema.resolveTypeDefinitionURI(uri);
        }
        xsdElement2.setTypeDefinition(xsdTypeDefinition);
        xsdParticle3.setContent((XSDParticleContent)xsdElement2);
        EList _contents = xsdModelGroup2.getContents();
        _contents.add((Object)xsdParticle3);
        if (typeEClassifier instanceof EClass) {
            List<EClass> _findESubTypesOf = Ecore2XSDUtil.findESubTypesOf((EClass)typeEClassifier);
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle xsdParticleSubType = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration xsdElementSubType = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    String _xMLName = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLName((EClassifier)it);
                    xsdElementSubType.setName(_xMLName);
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDTypeDefinition xsdTypeDefinitionSubType = xsdElementSubType.resolveTypeDefinitionURI(subTypeURI);
                    xsdElementSubType.setTypeDefinition(xsdTypeDefinitionSubType);
                    xsdParticleSubType.setContent((XSDParticleContent)xsdElementSubType);
                    EList _contents = xsdModelGroup2.getContents();
                    _contents.add((Object)xsdParticleSubType);
                }
            };
            _findESubTypesOf.forEach(_function);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDAttributeUse createClassAttribute5d(EAttribute attribute, EClass eClass, XSDSchema xsdSchema) {
        boolean _equals;
        XSDAttributeUse xsdAttributeUse = xsdFactory.createXSDAttributeUse();
        XSDAttributeDeclaration attributeDeclaration = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
        String _xMLName = this.xsdExtendedMetaData.getXMLName((EStructuralFeature)attribute);
        attributeDeclaration.setName(_xMLName);
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        EClassifier baseType = attribute.getEType();
        boolean _and = false;
        if (!(baseType instanceof EDataType)) {
            _and = false;
        } else {
            Boolean _isXMLPrimitiveXsdType = this.isXMLPrimitiveXsdType((EDataType)baseType);
            _and = _isXMLPrimitiveXsdType;
        }
        if (_and) {
            XSDTypeDefinition _resolveTypeDefinitionURI;
            String xsdSimpleType = this.getXsdSimpleType(baseType);
            xsdTypeDefinition = _resolveTypeDefinitionURI = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#" + xsdSimpleType);
        } else {
            XSDTypeDefinition _resolveTypeDefinitionURI_1;
            String uri = this.getElementXSDURI(baseType);
            xsdTypeDefinition = _resolveTypeDefinitionURI_1 = xsdSchema.resolveTypeDefinitionURI(uri);
        }
        attributeDeclaration.setTypeDefinition((XSDSimpleTypeDefinition)xsdTypeDefinition);
        xsdAttributeUse.setContent(attributeDeclaration);
        int _upperBound = attribute.getUpperBound();
        boolean bl = _equals = _upperBound == 0;
        if (_equals) {
            xsdAttributeUse.setUse(XSDAttributeUseCategory.PROHIBITED_LITERAL);
        } else {
            boolean _equals_1;
            int _lowerBound = attribute.getLowerBound();
            boolean bl2 = _equals_1 = _lowerBound == 0;
            if (_equals_1) {
                xsdAttributeUse.setUse(XSDAttributeUseCategory.OPTIONAL_LITERAL);
            } else {
                xsdAttributeUse.setUse(XSDAttributeUseCategory.REQUIRED_LITERAL);
            }
        }
        return xsdAttributeUse;
    }

    public XSDParticle create_EReference_contained1100(final EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        boolean _greaterThan;
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        int _lowerBound = feature.getLowerBound();
        boolean bl = _greaterThan = _lowerBound > 0;
        if (_greaterThan) {
            xsdParticle.setMinOccurs(1);
        } else {
            xsdParticle.setMinOccurs(0);
        }
        xsdParticle.setMaxOccurs(1);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        String _xMLWrapperName = this.xsdExtendedMetaData.getXMLWrapperName(feature);
        xsdElement.setName(_xMLWrapperName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        int _upperBound = feature.getUpperBound();
        xsdParticle2.setMaxOccurs(_upperBound);
        int _lowerBound_1 = feature.getLowerBound();
        xsdParticle2.setMinOccurs(_lowerBound_1);
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeEClassifier = feature.getEType();
        XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        String _xMLName = this.xsdExtendedMetaData.getXMLName(feature);
        xsdElement2.setName(_xMLName);
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        boolean _and = false;
        if (!(typeEClassifier instanceof EDataType)) {
            _and = false;
        } else {
            Boolean _isXMLPrimitiveXsdType = this.isXMLPrimitiveXsdType((EDataType)typeEClassifier);
            _and = _isXMLPrimitiveXsdType;
        }
        if (_and) {
            XSDTypeDefinition _resolveTypeDefinitionURI;
            String xsdSimpleType = this.getXsdSimpleType(typeEClassifier);
            xsdTypeDefinition = _resolveTypeDefinitionURI = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#" + xsdSimpleType);
        } else {
            XSDTypeDefinition _resolveTypeDefinitionURI_1;
            String uri = this.getElementXSDURI(typeEClassifier);
            xsdTypeDefinition = _resolveTypeDefinitionURI_1 = xsdSchema.resolveTypeDefinitionURI(uri);
        }
        xsdElement2.setTypeDefinition(xsdTypeDefinition);
        xsdParticle3.setContent((XSDParticleContent)xsdElement2);
        EList _contents = xsdModelGroup2.getContents();
        _contents.add((Object)xsdParticle3);
        if (typeEClassifier instanceof EClass) {
            List<EClass> _findESubTypesOf = Ecore2XSDUtil.findESubTypesOf((EClass)typeEClassifier);
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle xsdParticleSubType = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration xsdElementSubType = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    String _xMLName = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLName(feature);
                    xsdElementSubType.setName(_xMLName);
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDTypeDefinition xsdTypeDefinitionSubType = xsdElementSubType.resolveTypeDefinitionURI(subTypeURI);
                    xsdElementSubType.setTypeDefinition(xsdTypeDefinitionSubType);
                    xsdParticleSubType.setContent((XSDParticleContent)xsdElementSubType);
                    EList _contents = xsdModelGroup2.getContents();
                    _contents.add((Object)xsdParticleSubType);
                }
            };
            _findESubTypesOf.forEach(_function);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle create_EReference_contained0101(final EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        boolean _greaterThan;
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        int _lowerBound = feature.getLowerBound();
        boolean bl = _greaterThan = _lowerBound > 0;
        if (_greaterThan) {
            xsdParticle.setMinOccurs(1);
        } else {
            xsdParticle.setMinOccurs(0);
        }
        int _upperBound = feature.getUpperBound();
        xsdParticle.setMaxOccurs(_upperBound);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        String _xMLName = this.xsdExtendedMetaData.getXMLName(feature);
        xsdElement.setName(_xMLName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMaxOccurs(1);
        int _lowerBound_1 = feature.getLowerBound();
        xsdParticle2.setMinOccurs(_lowerBound_1);
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeEClassifier = feature.getEType();
        if (typeEClassifier instanceof EClass) {
            List<EClass> _findAllConcreteTypes = Ecore2XSDUtil.findAllConcreteTypes((EClass)typeEClassifier, null);
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle xsdParticleSubType = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration xsdElementSubType = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    String _xMLName = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLName((EClassifier)it, feature);
                    String subClassXMLName = Ecore2XSDFactory.this.getTypeXMLName(_xMLName, (ENamedElement)it);
                    xsdElementSubType.setName(subClassXMLName);
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDTypeDefinition xsdTypeDefinitionSubType = xsdElementSubType.resolveTypeDefinitionURI(subTypeURI);
                    xsdElementSubType.setTypeDefinition(xsdTypeDefinitionSubType);
                    xsdParticleSubType.setContent((XSDParticleContent)xsdElementSubType);
                    EList _contents = xsdModelGroup2.getContents();
                    _contents.add((Object)xsdParticleSubType);
                }
            };
            _findAllConcreteTypes.forEach(_function);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        return xsdParticle;
    }

    public XSDParticle create_EReference_contained0100(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        int _lowerBound = feature.getLowerBound();
        xsdParticle.setMinOccurs(_lowerBound);
        int _upperBound = feature.getUpperBound();
        xsdParticle.setMaxOccurs(_upperBound);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        String _xMLName = this.xsdExtendedMetaData.getXMLName(feature);
        xsdElement.setName(_xMLName);
        EClassifier typeeClassifier = feature.getEType();
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        boolean _and = false;
        if (!(typeeClassifier instanceof EDataType)) {
            _and = false;
        } else {
            Boolean _isXMLPrimitiveXsdType = this.isXMLPrimitiveXsdType((EDataType)typeeClassifier);
            _and = _isXMLPrimitiveXsdType;
        }
        if (_and) {
            XSDTypeDefinition _resolveTypeDefinitionURI;
            String xsdSimpleType = this.getXsdSimpleType(typeeClassifier);
            xsdTypeDefinition = _resolveTypeDefinitionURI = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#" + xsdSimpleType);
        } else {
            XSDTypeDefinition _resolveTypeDefinitionURI_1;
            String uri = this.getElementXSDURI(typeeClassifier);
            xsdTypeDefinition = _resolveTypeDefinitionURI_1 = xsdSchema.resolveTypeDefinitionURI(uri);
        }
        xsdElement.setTypeDefinition(xsdTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle create_EReference_referenced1100Many_5l(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema, ArrayList<EClass> referencedClass) {
        boolean _not;
        String _xMLTypeAttributeName = this.xsdExtendedMetaData.getXMLTypeAttributeName(feature);
        boolean _equals = _xMLTypeAttributeName.equals("xsi:type");
        boolean bl = _not = !_equals;
        if (_not) {
            return this.create_EReference_referenced1100Many_5l_XSITypeFalse(feature, eClass, xsdSchema, referencedClass);
        }
        return this.create_EReference_referenced1100Many_5l_XSITypeTrue(feature, eClass, xsdSchema, referencedClass);
    }

    public XSDParticle create_EReference_referenced1100Many_5l_XSITypeFalse(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema, ArrayList<EClass> referencedClass) {
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        String roleName = this.xsdExtendedMetaData.getXMLWrapperName(feature);
        int lowerBound = feature.getLowerBound();
        if (lowerBound > 1) {
            lowerBound = 1;
        }
        xsdParticle.setMinOccurs(lowerBound);
        xsdParticle.setMaxOccurs(1);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(roleName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        int _upperBound = feature.getUpperBound();
        xsdParticle2.setMaxOccurs(_upperBound);
        int _lowerBound = feature.getLowerBound();
        xsdParticle2.setMinOccurs(_lowerBound);
        XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        String _xMLName = this.xsdExtendedMetaData.getXMLName(feature);
        xsdElement2.setName(_xMLName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition2 = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        xsdComplexTypeDefinition2.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        XSDSimpleTypeDefinition simpleTypeDefinition = xsdFactory.createXSDSimpleTypeDefinition();
        XSDTypeDefinition baseTypeDef = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        xsdComplexTypeDefinition2.setBaseTypeDefinition(baseTypeDef);
        xsdComplexTypeDefinition2.setContent((XSDComplexTypeContent)simpleTypeDefinition);
        XSDAttributeUse simpleAttributeUse = xsdFactory.createXSDAttributeUse();
        XSDAttributeDeclaration xsdAttribute = xsdFactory.createXSDAttributeDeclaration();
        String _xMLTypeAttributeName = this.xsdExtendedMetaData.getXMLTypeAttributeName(feature);
        xsdAttribute.setName(_xMLTypeAttributeName);
        EClassifier baseType = feature.getEType();
        referencedClass.add((EClass)baseType);
        String _elementXSDURI = this.getElementXSDURI(baseType);
        String uri = String.valueOf(_elementXSDURI) + "--SUBTYPES-ENUM";
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(uri);
        xsdAttribute.setTypeDefinition((XSDSimpleTypeDefinition)xsdTypeDefinition);
        simpleAttributeUse.setContent(xsdAttribute);
        simpleAttributeUse.setUse(XSDAttributeUseCategory.OPTIONAL_LITERAL);
        EList _attributeContents = xsdComplexTypeDefinition2.getAttributeContents();
        _attributeContents.add((Object)simpleAttributeUse);
        xsdElement2.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition2);
        xsdParticle3.setContent((XSDParticleContent)xsdElement2);
        EList _contents = xsdModelGroup2.getContents();
        _contents.add((Object)xsdParticle3);
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle create_EReference_referenced1100Many_5l_XSITypeTrue(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema, ArrayList<EClass> referencedClass) {
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        String roleName = this.xsdExtendedMetaData.getXMLWrapperName(feature);
        int lowerBound = feature.getLowerBound();
        if (lowerBound > 1) {
            lowerBound = 1;
        }
        xsdParticle.setMinOccurs(lowerBound);
        xsdParticle.setMaxOccurs(1);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(roleName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        int _upperBound = feature.getUpperBound();
        xsdParticle2.setMaxOccurs(_upperBound);
        int _lowerBound = feature.getLowerBound();
        xsdParticle2.setMinOccurs(_lowerBound);
        XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        String _xMLName = this.xsdExtendedMetaData.getXMLName(feature);
        xsdElement2.setName(_xMLName);
        XSDTypeDefinition typeDef = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        xsdElement2.setTypeDefinition(typeDef);
        xsdParticle3.setContent((XSDParticleContent)xsdElement2);
        EList _contents = xsdModelGroup2.getContents();
        _contents.add((Object)xsdParticle3);
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle create_EReference_referenced0100Many_5m(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema, ArrayList<EClass> referencedClass) {
        boolean _not;
        String _xMLTypeAttributeName = this.xsdExtendedMetaData.getXMLTypeAttributeName(feature);
        boolean _equals = _xMLTypeAttributeName.equals("xsi:type");
        boolean bl = _not = !_equals;
        if (_not) {
            return this.create_EReference_referenced0100Many_5m_XSITypeFalse(feature, eClass, xsdSchema, referencedClass);
        }
        return this.create_EReference_referenced0100Many_5m_XSITypeTrue(feature, eClass, xsdSchema, referencedClass);
    }

    public XSDParticle create_EReference_referenced0100Many_5m_XSITypeFalse(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema, ArrayList<EClass> referencedClass) {
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        String roleName = this.xsdExtendedMetaData.getXMLName(feature);
        int _lowerBound = feature.getLowerBound();
        xsdParticle.setMinOccurs(_lowerBound);
        int _upperBound = feature.getUpperBound();
        xsdParticle.setMaxOccurs(_upperBound);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(roleName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        xsdComplexTypeDefinition.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        XSDSimpleTypeDefinition simpleTypeDefinition = xsdFactory.createXSDSimpleTypeDefinition();
        XSDTypeDefinition baseTypeDef = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        xsdComplexTypeDefinition.setBaseTypeDefinition(baseTypeDef);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)simpleTypeDefinition);
        XSDAttributeUse simpleAttributeUse = xsdFactory.createXSDAttributeUse();
        XSDAttributeDeclaration xsdAttribute = xsdFactory.createXSDAttributeDeclaration();
        String typeAttributeName = this.xsdExtendedMetaData.getXMLTypeAttributeName(feature);
        xsdAttribute.setName(typeAttributeName);
        EClassifier baseType = feature.getEType();
        referencedClass.add((EClass)baseType);
        String _elementXSDURI = this.getElementXSDURI(baseType);
        String uri = String.valueOf(_elementXSDURI) + "--SUBTYPES-ENUM";
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(uri);
        xsdAttribute.setTypeDefinition((XSDSimpleTypeDefinition)xsdTypeDefinition);
        simpleAttributeUse.setContent(xsdAttribute);
        simpleAttributeUse.setUse(XSDAttributeUseCategory.OPTIONAL_LITERAL);
        EList _attributeContents = xsdComplexTypeDefinition.getAttributeContents();
        _attributeContents.add((Object)simpleAttributeUse);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle create_EReference_referenced0100Many_5m_XSITypeTrue(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema, ArrayList<EClass> referencedClass) {
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        String roleName = this.xsdExtendedMetaData.getXMLName(feature);
        int _lowerBound = feature.getLowerBound();
        xsdParticle.setMinOccurs(_lowerBound);
        int _upperBound = feature.getUpperBound();
        xsdParticle.setMaxOccurs(_upperBound);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(roleName);
        XSDTypeDefinition typeDef = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        xsdElement.setTypeDefinition(typeDef);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle create_EReference_referenced0100Single_5n(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema, ArrayList<EClass> referencedClass) {
        return this.create_EReference_referenced0100Many_5m(feature, eClass, xsdSchema, referencedClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDSimpleTypeDefinition createEnumSchema6(EEnum eEnum, XSDSchema xsdSchema) {
        XSDSimpleTypeDefinition _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new EObject[]{eEnum, xsdSchema});
        HashMap<ArrayList<?>, XSDSimpleTypeDefinition> hashMap = this._createCache_createEnumSchema6;
        synchronized (hashMap) {
            XSDSimpleTypeDefinition _createXSDSimpleTypeDefinition;
            if (this._createCache_createEnumSchema6.containsKey(_cacheKey)) {
                return this._createCache_createEnumSchema6.get(_cacheKey);
            }
            _result = _createXSDSimpleTypeDefinition = xsdFactory.createXSDSimpleTypeDefinition();
            this._createCache_createEnumSchema6.put(_cacheKey, _result);
        }
        this._init_createEnumSchema6(_result, eEnum, xsdSchema);
        return _result;
    }

    private void _init_createEnumSchema6(final XSDSimpleTypeDefinition xsdSimpleTypeDefinition, EEnum eEnum, XSDSchema xsdSchema) {
        String _xMLName = this.xsdExtendedMetaData.getXMLName((EClassifier)eEnum);
        xsdSimpleTypeDefinition.setName(_xMLName);
        XSDTypeDefinition baseType = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        xsdSimpleTypeDefinition.setBaseTypeDefinition((XSDSimpleTypeDefinition)baseType);
        EList _eLiterals = eEnum.getELiterals();
        Consumer<EEnumLiteral> _function = new Consumer<EEnumLiteral>(){

            @Override
            public void accept(EEnumLiteral it) {
                XSDEnumerationFacet xsdEnum = xsdFactory.createXSDEnumerationFacet();
                String _name = it.getName();
                String _upperCase = _name.toUpperCase();
                xsdEnum.setLexicalValue(_upperCase);
                EList _facetContents = xsdSimpleTypeDefinition.getFacetContents();
                _facetContents.add((Object)xsdEnum);
            }
        };
        _eLiterals.forEach((Consumer)_function);
        EList _contents = xsdSchema.getContents();
        _contents.add((Object)xsdSimpleTypeDefinition);
    }

    public XSDComplexTypeDefinition createDataTypeSchema7a(EDataType eDataType, XSDSchema xsdSchema) {
        XSDComplexTypeDefinition xsdComplexTypeDefinition = xsdFactory.createXSDComplexTypeDefinition();
        String _xMLName = this.xsdExtendedMetaData.getXMLName((EClassifier)eDataType);
        xsdComplexTypeDefinition.setName(_xMLName);
        XSDParticle xsdParticle = XSDFactory.eINSTANCE.createXSDParticle();
        XSDModelGroup xsdModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDWildcard xsdAny = XSDFactory.eINSTANCE.createXSDWildcard();
        xsdAny.setStringLexicalNamespaceConstraint("##any");
        xsdAny.setProcessContents(XSDProcessContents.LAX_LITERAL);
        xsdParticle2.setMinOccurs(0);
        xsdParticle2.setMaxOccurs(1);
        xsdParticle2.setContent((XSDParticleContent)xsdAny);
        EList _contents = xsdModelGroup.getContents();
        _contents.add((Object)xsdParticle2);
        xsdParticle.setContent((XSDParticleContent)xsdModelGroup);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle);
        EList _contents_1 = xsdSchema.getContents();
        _contents_1.add((Object)xsdComplexTypeDefinition);
        return xsdComplexTypeDefinition;
    }

    public XSDSimpleTypeDefinition createDataTypeSchema7b(EDataType eDataType, XSDSchema xsdSchema) {
        boolean _isNullOrEmpty;
        boolean _not;
        boolean _notEquals;
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = xsdFactory.createXSDSimpleTypeDefinition();
        String _xMLName = this.xsdExtendedMetaData.getXMLName((EClassifier)eDataType);
        xsdSimpleTypeDefinition.setName(_xMLName);
        XSDTypeDefinition baseType = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        xsdSimpleTypeDefinition.setBaseTypeDefinition((XSDSimpleTypeDefinition)baseType);
        List patternValue = ExtendedMetaData.INSTANCE.getPatternFacet(eDataType);
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal((Object)patternValue, null);
        _and = !_notEquals ? false : (_not = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)patternValue)));
        if (_and) {
            String pattern = (String)patternValue.get(0);
            XSDPatternFacet xsdPattern = xsdFactory.createXSDPatternFacet();
            xsdPattern.setLexicalValue(pattern);
            EList _facetContents = xsdSimpleTypeDefinition.getFacetContents();
            _facetContents.add((Object)xsdPattern);
        }
        EList _contents = xsdSchema.getContents();
        _contents.add((Object)xsdSimpleTypeDefinition);
        return xsdSimpleTypeDefinition;
    }

    public XSDSimpleTypeDefinition createDataTypeSimpleType7b(EDataType eDataType, XSDSchema xsdSchema) {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = xsdFactory.createXSDSimpleTypeDefinition();
        String _xMLName = this.xsdExtendedMetaData.getXMLName((EClassifier)eDataType);
        xsdSimpleTypeDefinition.setName(_xMLName);
        XSDTypeDefinition baseType = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        xsdSimpleTypeDefinition.setBaseTypeDefinition((XSDSimpleTypeDefinition)baseType);
        XSDPatternFacet xsdPattern = xsdFactory.createXSDPatternFacet();
        List patternValue = ExtendedMetaData.INSTANCE.getPatternFacet(eDataType);
        String _get = (String)patternValue.get(0);
        xsdPattern.setLexicalValue(_get);
        EList _facetContents = xsdSimpleTypeDefinition.getFacetContents();
        _facetContents.add((Object)xsdPattern);
        EList _contents = xsdSchema.getContents();
        _contents.add((Object)xsdSimpleTypeDefinition);
        return xsdSimpleTypeDefinition;
    }

    public XSDComplexTypeDefinition createDataTypeComplexType7c(EDataType eDataType, XSDSchema xsdSchema) {
        XSDComplexTypeDefinition xsdComplexTypeDefinition = xsdFactory.createXSDComplexTypeDefinition();
        String xmlName = this.xsdExtendedMetaData.getXMLName((EClassifier)eDataType);
        xsdComplexTypeDefinition.setName(xmlName);
        xsdComplexTypeDefinition.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        XSDSimpleTypeDefinition simpleTypeDefinition = xsdFactory.createXSDSimpleTypeDefinition();
        String typeURI = String.valueOf(this.defaultUserSchemaNamespace) + "#" + xmlName + "--SIMPLE";
        XSDTypeDefinition baseTypeDef = xsdSchema.resolveTypeDefinitionURI(typeURI);
        xsdComplexTypeDefinition.setBaseTypeDefinition(baseTypeDef);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)simpleTypeDefinition);
        EList _contents = xsdSchema.getContents();
        _contents.add((Object)xsdComplexTypeDefinition);
        return xsdComplexTypeDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDSimpleTypeDefinition createSimpleType8(EClass eClass, XSDSchema xsdSchema) {
        XSDSimpleTypeDefinition _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new EObject[]{eClass, xsdSchema});
        HashMap<ArrayList<?>, XSDSimpleTypeDefinition> hashMap = this._createCache_createSimpleType8;
        synchronized (hashMap) {
            XSDSimpleTypeDefinition _createXSDSimpleTypeDefinition;
            if (this._createCache_createSimpleType8.containsKey(_cacheKey)) {
                return this._createCache_createSimpleType8.get(_cacheKey);
            }
            _result = _createXSDSimpleTypeDefinition = xsdFactory.createXSDSimpleTypeDefinition();
            this._createCache_createSimpleType8.put(_cacheKey, _result);
        }
        this._init_createSimpleType8(_result, eClass, xsdSchema);
        return _result;
    }

    private void _init_createSimpleType8(final XSDSimpleTypeDefinition xsdSimpleTypeDefinition, EClass eClass, XSDSchema xsdSchema) {
        String _xMLName = this.xsdExtendedMetaData.getXMLName((EClassifier)eClass);
        String _plus = String.valueOf(_xMLName) + "--SUBTYPES-ENUM";
        xsdSimpleTypeDefinition.setName(_plus);
        XSDTypeDefinition baseType = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        xsdSimpleTypeDefinition.setBaseTypeDefinition((XSDSimpleTypeDefinition)baseType);
        XSDEnumerationFacet xsdEnumFacet = XSDFactory.eINSTANCE.createXSDEnumerationFacet();
        String _xMLName_1 = this.xsdExtendedMetaData.getXMLName((EClassifier)eClass);
        xsdEnumFacet.setLexicalValue(_xMLName_1);
        EList _facetContents = xsdSimpleTypeDefinition.getFacetContents();
        _facetContents.add((Object)xsdEnumFacet);
        List<EClass> _findESubTypesOf = Ecore2XSDUtil.findESubTypesOf(eClass);
        Consumer<EClass> _function = new Consumer<EClass>(){

            @Override
            public void accept(EClass it) {
                XSDEnumerationFacet xsdEnum = XSDFactory.eINSTANCE.createXSDEnumerationFacet();
                String _xMLName = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLName((EClassifier)it);
                xsdEnum.setLexicalValue(_xMLName);
                EList _facetContents = xsdSimpleTypeDefinition.getFacetContents();
                _facetContents.add((Object)xsdEnum);
            }
        };
        _findESubTypesOf.forEach(_function);
        EList _contents = xsdSchema.getContents();
        _contents.add((Object)xsdSimpleTypeDefinition);
    }

    public XSDParticle generateXSDParticleForFeature(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        int xmlPersistenceStrategy = this.xsdExtendedMetaData.getXMLPersistenceMappingStrategy(feature);
        XSDParticle xsdParticle = null;
        if (9 == xmlPersistenceStrategy) {
            XSDParticle _createXSDParticleForFeatureCase0010;
            xsdParticle = _createXSDParticleForFeatureCase0010 = this.createXSDParticleForFeatureCase0010(feature, eClass);
            this.patternCaseSet.add("0010");
        } else if (5 == xmlPersistenceStrategy) {
            XSDParticle _createXSDParticleForFeatureCase0012;
            xsdParticle = _createXSDParticleForFeatureCase0012 = this.createXSDParticleForFeatureCase0012(feature, eClass);
            this.patternCaseSet.add("0012");
        } else if (4 == xmlPersistenceStrategy) {
            XSDParticle _createXSDParticleForFeatureCase0013;
            xsdParticle = _createXSDParticleForFeatureCase0013 = this.createXSDParticleForFeatureCase0013(feature, eClass, xsdSchema);
            this.patternCaseSet.add("0013");
        } else if (12 == xmlPersistenceStrategy) {
            XSDParticle _createXSDParticleForFeatureCase0023;
            xsdParticle = _createXSDParticleForFeatureCase0023 = this.createXSDParticleForFeatureCase0023(feature, eClass, xsdSchema);
            this.patternCaseSet.add("0023");
        } else if (8 == xmlPersistenceStrategy) {
            XSDParticle _createXSDParticleForFeatureCase0010_1;
            xsdParticle = _createXSDParticleForFeatureCase0010_1 = this.createXSDParticleForFeatureCase0010(feature, eClass);
            this.patternCaseSet.add("case not allowed, handled as pattern 0010 (the same way in EAST-ADL)");
        } else {
            XSDParticle _createXSDParticleForFeatureCase0012_1;
            xsdParticle = _createXSDParticleForFeatureCase0012_1 = this.createXSDParticleForFeatureCase0012(feature, eClass);
            this.patternCaseSet.add("unsupported_mapping_strategy" + Integer.valueOf(xmlPersistenceStrategy));
            String _name = eClass.getName();
            String _plus = "\n eClass = " + _name;
            String _plus_1 = String.valueOf(_plus) + " feature = ";
            String _name_1 = feature.getName();
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            System.out.print(_plus_2);
        }
        return xsdParticle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDParticle createXSDParticleForFeatureCase0010(EStructuralFeature feature, EClass eClass) {
        XSDParticle _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ENamedElement[]{feature, eClass});
        HashMap<ArrayList<?>, XSDParticle> hashMap = this._createCache_createXSDParticleForFeatureCase0010;
        synchronized (hashMap) {
            XSDParticle _createXSDParticle;
            if (this._createCache_createXSDParticleForFeatureCase0010.containsKey(_cacheKey)) {
                return this._createCache_createXSDParticleForFeatureCase0010.get(_cacheKey);
            }
            _result = _createXSDParticle = xsdFactory.createXSDParticle();
            this._createCache_createXSDParticleForFeatureCase0010.put(_cacheKey, _result);
        }
        this._init_createXSDParticleForFeatureCase0010(_result, feature, eClass);
        return _result;
    }

    private void _init_createXSDParticleForFeatureCase0010(XSDParticle xsdParticle, EStructuralFeature feature, EClass eClass) {
        boolean _greaterThan;
        String roleName = this.xsdExtendedMetaData.getXMLWrapperName(feature);
        int _lowerBound = feature.getLowerBound();
        boolean bl = _greaterThan = _lowerBound > 0;
        if (_greaterThan) {
            xsdParticle.setMinOccurs(1);
        } else {
            xsdParticle.setMinOccurs(0);
        }
        xsdParticle.setMaxOccurs(1);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(roleName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMaxOccurs(1);
        xsdParticle2.setMinOccurs(0);
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeEClassifier = feature.getEType();
        XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        String _name = this.xsdExtendedMetaData.getName(typeEClassifier);
        xsdElement2.setName(_name);
        String typeeClassifierURI = this.getElementXSDURI(typeEClassifier);
        XSDTypeDefinition xsdTypeDefinition = xsdElement2.resolveTypeDefinitionURI(typeeClassifierURI);
        xsdElement2.setTypeDefinition(xsdTypeDefinition);
        xsdParticle3.setContent((XSDParticleContent)xsdElement2);
        EList _contents = xsdModelGroup2.getContents();
        _contents.add((Object)xsdParticle3);
        if (typeEClassifier instanceof EClass) {
            List<EClass> _findESubTypesOf = Ecore2XSDUtil.findESubTypesOf((EClass)typeEClassifier);
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle xsdParticleSubType = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration xsdElementSubType = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    String _xMLName = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLName((EClassifier)it);
                    xsdElementSubType.setName(_xMLName);
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDTypeDefinition xsdTypeDefinitionSubType = xsdElementSubType.resolveTypeDefinitionURI(subTypeURI);
                    xsdElementSubType.setTypeDefinition(xsdTypeDefinitionSubType);
                    xsdParticleSubType.setContent((XSDParticleContent)xsdElementSubType);
                    EList _contents = xsdModelGroup2.getContents();
                    _contents.add((Object)xsdParticleSubType);
                }
            };
            _findESubTypesOf.forEach(_function);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDParticle createXSDParticleForFeatureCase0012(EStructuralFeature feature, EClass eClass) {
        XSDParticle _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ENamedElement[]{feature, eClass});
        HashMap<ArrayList<?>, XSDParticle> hashMap = this._createCache_createXSDParticleForFeatureCase0012;
        synchronized (hashMap) {
            XSDParticle _createXSDParticle;
            if (this._createCache_createXSDParticleForFeatureCase0012.containsKey(_cacheKey)) {
                return this._createCache_createXSDParticleForFeatureCase0012.get(_cacheKey);
            }
            _result = _createXSDParticle = xsdFactory.createXSDParticle();
            this._createCache_createXSDParticleForFeatureCase0012.put(_cacheKey, _result);
        }
        this._init_createXSDParticleForFeatureCase0012(_result, feature, eClass);
        return _result;
    }

    private void _init_createXSDParticleForFeatureCase0012(XSDParticle xsdParticle, EStructuralFeature feature, EClass eClass) {
        String roleName = this.xsdExtendedMetaData.getXMLName(feature);
        xsdParticle.setMinOccurs(0);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(roleName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMaxOccurs(1);
        xsdParticle2.setMinOccurs(0);
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeEClassifier = feature.getEType();
        XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        String _xMLName = this.xsdExtendedMetaData.getXMLName(typeEClassifier);
        xsdElement2.setName(_xMLName);
        String typeeClassifierURI = this.getElementXSDURI(typeEClassifier);
        XSDTypeDefinition xsdTypeDefinition = xsdElement2.resolveTypeDefinitionURI(typeeClassifierURI);
        xsdElement2.setTypeDefinition(xsdTypeDefinition);
        xsdParticle3.setContent((XSDParticleContent)xsdElement2);
        EList _contents = xsdModelGroup2.getContents();
        _contents.add((Object)xsdParticle3);
        if (typeEClassifier instanceof EClass) {
            List<EClass> _findESubTypesOf = Ecore2XSDUtil.findESubTypesOf((EClass)typeEClassifier);
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle xsdParticleSubType = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration xsdElementSubType = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    String _name = Ecore2XSDFactory.this.xsdExtendedMetaData.getName((EClassifier)it);
                    xsdElementSubType.setName(_name);
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDTypeDefinition xsdTypeDefinitionSubType = xsdElementSubType.resolveTypeDefinitionURI(subTypeURI);
                    xsdElementSubType.setTypeDefinition(xsdTypeDefinitionSubType);
                    xsdParticleSubType.setContent((XSDParticleContent)xsdElementSubType);
                    EList _contents = xsdModelGroup2.getContents();
                    _contents.add((Object)xsdParticleSubType);
                }
            };
            _findESubTypesOf.forEach(_function);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDParticle createXSDParticleForFeatureCase0013(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        XSDParticle _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new EObject[]{feature, eClass, xsdSchema});
        HashMap<ArrayList<?>, XSDParticle> hashMap = this._createCache_createXSDParticleForFeatureCase0013;
        synchronized (hashMap) {
            XSDParticle _createXSDParticle;
            if (this._createCache_createXSDParticleForFeatureCase0013.containsKey(_cacheKey)) {
                return this._createCache_createXSDParticleForFeatureCase0013.get(_cacheKey);
            }
            _result = _createXSDParticle = xsdFactory.createXSDParticle();
            this._createCache_createXSDParticleForFeatureCase0013.put(_cacheKey, _result);
        }
        this._init_createXSDParticleForFeatureCase0013(_result, feature, eClass, xsdSchema);
        return _result;
    }

    private void _init_createXSDParticleForFeatureCase0013(XSDParticle xsdParticle, EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        String roleName = this.xsdExtendedMetaData.getXMLName(feature);
        xsdParticle.setMinOccurs(0);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(roleName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMaxOccurs(1);
        xsdParticle2.setMinOccurs(0);
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeEClassifier = feature.getEType();
        if (typeEClassifier instanceof EClass) {
            XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
            XSDModelGroupDefinition xsdModelGroupdefinitionRef = XSDFactory.eINSTANCE.createXSDModelGroupDefinition();
            String refGroupURI = this.getElementXSDURI(typeEClassifier);
            XSDModelGroupDefinition xsdModelGroupDef = xsdModelGroupdefinitionRef.resolveModelGroupDefinitionURI(refGroupURI);
            xsdModelGroupdefinitionRef.setResolvedModelGroupDefinition(xsdModelGroupDef);
            xsdParticle3.setContent((XSDParticleContent)xsdModelGroupdefinitionRef);
            xsdParticle3.setContent((XSDParticleContent)xsdModelGroupdefinitionRef);
            EList _contents = xsdModelGroup2.getContents();
            _contents.add((Object)xsdParticle3);
            List<EClass> _findESubTypesOf = Ecore2XSDUtil.findESubTypesOf((EClass)typeEClassifier);
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle xsdParticleSubType = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDModelGroupDefinition xsdModelGroupdefSubTypeRef = XSDFactory.eINSTANCE.createXSDModelGroupDefinition();
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDModelGroupDefinition subTypeModelGroupDef = xsdModelGroupdefSubTypeRef.resolveModelGroupDefinitionURI(subTypeURI);
                    xsdModelGroupdefSubTypeRef.setResolvedModelGroupDefinition(subTypeModelGroupDef);
                    xsdParticleSubType.setContent((XSDParticleContent)xsdModelGroupdefSubTypeRef);
                    EList _contents = xsdModelGroup2.getContents();
                    _contents.add((Object)xsdParticleSubType);
                }
            };
            _findESubTypesOf.forEach(_function);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDParticle createXSDParticleForFeatureCase0023(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        XSDParticle _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new EObject[]{feature, eClass, xsdSchema});
        HashMap<ArrayList<?>, XSDParticle> hashMap = this._createCache_createXSDParticleForFeatureCase0023;
        synchronized (hashMap) {
            XSDParticle _createXSDParticle;
            if (this._createCache_createXSDParticleForFeatureCase0023.containsKey(_cacheKey)) {
                return this._createCache_createXSDParticleForFeatureCase0023.get(_cacheKey);
            }
            _result = _createXSDParticle = xsdFactory.createXSDParticle();
            this._createCache_createXSDParticleForFeatureCase0023.put(_cacheKey, _result);
        }
        this._init_createXSDParticleForFeatureCase0023(_result, feature, eClass, xsdSchema);
        return _result;
    }

    private void _init_createXSDParticleForFeatureCase0023(XSDParticle xsdParticle, EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        String roleName = this.xsdExtendedMetaData.getXMLWrapperName(feature);
        xsdParticle.setMinOccurs(0);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(roleName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMaxOccurs(1);
        xsdParticle2.setMinOccurs(0);
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeEClassifier = feature.getEType();
        if (typeEClassifier instanceof EClass) {
            XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
            XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
            String _xMLWrapperName = this.xsdExtendedMetaData.getXMLWrapperName(typeEClassifier);
            xsdElement2.setName(_xMLWrapperName);
            XSDComplexTypeDefinition xsdComplexTypeDefinition2 = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
            XSDParticle xsdParticle4 = XSDFactory.eINSTANCE.createXSDParticle();
            xsdParticle4.setMaxOccurs(1);
            xsdParticle4.setMinOccurs(0);
            XSDModelGroup xsdModelGroup3 = XSDFactory.eINSTANCE.createXSDModelGroup();
            xsdModelGroup3.setCompositor(XSDCompositor.CHOICE_LITERAL);
            XSDParticle xsdParticle5 = XSDFactory.eINSTANCE.createXSDParticle();
            XSDModelGroupDefinition xsdModelGroupdefinitionRef = XSDFactory.eINSTANCE.createXSDModelGroupDefinition();
            String typeURI = this.getElementXSDURI(typeEClassifier);
            XSDModelGroupDefinition typeModelGroupDef = xsdModelGroupdefinitionRef.resolveModelGroupDefinitionURI(typeURI);
            xsdModelGroupdefinitionRef.setResolvedModelGroupDefinition(typeModelGroupDef);
            xsdParticle5.setContent((XSDParticleContent)xsdModelGroupdefinitionRef);
            List<EClass> _findESubTypesOf = Ecore2XSDUtil.findESubTypesOf((EClass)typeEClassifier);
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle subTypeXSDParticle = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration subTypeXSDElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    String _xMLWrapperName = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLWrapperName((EClassifier)it);
                    subTypeXSDElement.setName(_xMLWrapperName);
                    XSDComplexTypeDefinition subTypeXSDComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
                    XSDParticle xsdParticle6 = XSDFactory.eINSTANCE.createXSDParticle();
                    xsdParticle6.setMaxOccurs(1);
                    xsdParticle6.setMinOccurs(0);
                    XSDModelGroup xsdModelGroup4 = XSDFactory.eINSTANCE.createXSDModelGroup();
                    xsdModelGroup4.setCompositor(XSDCompositor.CHOICE_LITERAL);
                    XSDParticle xsdParticle7 = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDModelGroupDefinition xsdModelGroupdefinitionRef2 = XSDFactory.eINSTANCE.createXSDModelGroupDefinition();
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDModelGroupDefinition subTypeModelGroupDef = xsdModelGroupdefinitionRef2.resolveModelGroupDefinitionURI(subTypeURI);
                    xsdModelGroupdefinitionRef2.setResolvedModelGroupDefinition(subTypeModelGroupDef);
                    xsdParticle7.setContent((XSDParticleContent)xsdModelGroupdefinitionRef2);
                    EList _contents = xsdModelGroup4.getContents();
                    _contents.add((Object)xsdParticle7);
                    xsdParticle6.setContent((XSDParticleContent)xsdModelGroup4);
                    subTypeXSDComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle6);
                    subTypeXSDElement.setAnonymousTypeDefinition((XSDTypeDefinition)subTypeXSDComplexTypeDefinition);
                    subTypeXSDParticle.setContent((XSDParticleContent)subTypeXSDElement);
                    EList _contents_1 = xsdModelGroup2.getContents();
                    _contents_1.add((Object)subTypeXSDParticle);
                }
            };
            _findESubTypesOf.forEach(_function);
            EList _contents = xsdModelGroup3.getContents();
            _contents.add((Object)xsdParticle5);
            xsdParticle4.setContent((XSDParticleContent)xsdModelGroup3);
            xsdComplexTypeDefinition2.setContent((XSDComplexTypeContent)xsdParticle4);
            xsdElement2.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition2);
            xsdParticle3.setContent((XSDParticleContent)xsdElement2);
            EList _contents_1 = xsdModelGroup2.getContents();
            _contents_1.add((Object)xsdParticle3);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
    }

    public Boolean isXMLPrimitiveXsdType(EDataType dataType) {
        boolean _not;
        Boolean isPrimitive = true;
        String _xMLXsdSimpleType = this.xsdExtendedMetaData.getXMLXsdSimpleType((EClassifier)dataType);
        Boolean isXsdTypeDefined = !Objects.equal((Object)_xMLXsdSimpleType, (Object)"uninitialized");
        String _xMLCustomSimpleType = this.xsdExtendedMetaData.getXMLCustomSimpleType((EClassifier)dataType);
        Boolean isCustomSimpleTypeDefined = IGeneratorConstants.BOOLEAN_TRUE.equals(_xMLCustomSimpleType);
        Boolean isPatternDefined = false;
        List patterns = ExtendedMetaData.INSTANCE.getPatternFacet(dataType);
        boolean _isEmpty = patterns.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String _get = (String)patterns.get(0);
            boolean _notEquals = !Objects.equal((Object)_get, null);
            isPatternDefined = _notEquals;
        }
        if (isPrimitive.booleanValue() && isXsdTypeDefined.booleanValue() && !isCustomSimpleTypeDefined.booleanValue() && !isPatternDefined.booleanValue()) {
            return true;
        }
        return false;
    }

    protected String getXsdSimpleType(EClassifier typeeClassifier) {
        String xsdSimpleType = this.xsdExtendedMetaData.getXMLXsdSimpleType(typeeClassifier);
        boolean _equals = Objects.equal((Object)xsdSimpleType, null);
        if (_equals) {
            String _get;
            Class instanceClass = typeeClassifier.getInstanceClass();
            xsdSimpleType = _get = JavaXSDPrimitiveTypeMapping.javaXsdPrimitiveTypeMapping.get(instanceClass);
        }
        return xsdSimpleType;
    }
}

