/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.drawing;

import org.eclipse.stardust.ide.simulation.ui.curves.swtutil.SwtResourceCache;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;

public class Configuration {
    SwtResourceCache resourceCache = new SwtResourceCache();
    RGB white = new RGB(255, 255, 255);
    RGB axesColor;
    RGB gridColor;
    RGB textColor;
    RGB[] curveColors;
    FontData unitFont;
    FontData scaleFont;
    FontData textFont;
    FontData notesFont;
    int marginLeft;
    int marginTop;
    int marginRight;
    int marginBottom;
    int arrowSize;
    int smallTickSize;
    int largeTickSize;
    int textOffset;

    public Configuration(RGB axesColor, RGB gridColor, RGB textColor, RGB[] curveColors, FontData unitFont, FontData scaleFont, FontData textFont, FontData notesFont, int marginLeft, int marginTop, int marginRight, int marginBottom, int arrowSize, int smallTickSize, int largeTickSize, int textOffset) {
        this.axesColor = axesColor;
        this.gridColor = gridColor;
        this.textColor = textColor;
        this.curveColors = curveColors;
        this.unitFont = unitFont;
        this.scaleFont = scaleFont;
        this.textFont = textFont;
        this.notesFont = notesFont;
        this.marginLeft = marginLeft;
        this.marginTop = marginTop;
        this.marginRight = marginRight;
        this.marginBottom = marginBottom;
        this.arrowSize = arrowSize;
        this.smallTickSize = smallTickSize;
        this.largeTickSize = largeTickSize;
        this.textOffset = textOffset;
    }

    public SwtResourceCache getResourceCache() {
        return this.resourceCache;
    }

    public int getArrowSize() {
        return this.arrowSize;
    }

    public void setArrowSize(int arrowSize) {
        this.arrowSize = arrowSize;
    }

    public RGB getAxesColor() {
        return this.axesColor;
    }

    public void setAxesColor(RGB axesColor) {
        this.axesColor = axesColor;
    }

    public RGB[] getCurveColors() {
        return this.curveColors;
    }

    public void setCurveColors(RGB[] curveColors) {
        if (this.curveColors != null) {
            int i = 0;
            while (i < this.curveColors.length) {
                this.resourceCache.drop(this.curveColors[i]);
                ++i;
            }
        }
        this.curveColors = curveColors;
    }

    public RGB getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(RGB gridColor) {
        this.resourceCache.drop(this.gridColor);
        this.gridColor = gridColor;
    }

    public int getLargeTickSize() {
        return this.largeTickSize;
    }

    public void setLargeTickSize(int largeTickSize) {
        this.largeTickSize = largeTickSize;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public FontData getNotesFont() {
        return this.notesFont;
    }

    public void setNotesFont(FontData notesFont) {
        this.notesFont = notesFont;
    }

    public FontData getScaleFont() {
        return this.scaleFont;
    }

    public void setScaleFont(FontData scaleFont) {
        this.resourceCache.drop(this.scaleFont);
        this.scaleFont = scaleFont;
    }

    public int getSmallTickSize() {
        return this.smallTickSize;
    }

    public void setSmallTickSize(int smallTickSize) {
        this.smallTickSize = smallTickSize;
    }

    public RGB getTextColor() {
        return this.textColor;
    }

    public void setTextColor(RGB textColor) {
        this.resourceCache.drop(this.textColor);
        this.textColor = textColor;
    }

    public FontData getTextFont() {
        return this.textFont;
    }

    public void setTextFont(FontData textFont) {
        this.resourceCache.drop(this.textFont);
        this.textFont = textFont;
    }

    public int getTextOffset() {
        return this.textOffset;
    }

    public void setTextOffset(int textOffset) {
        this.textOffset = textOffset;
    }

    public FontData getUnitFont() {
        return this.unitFont;
    }

    public void setUnitFont(FontData unitFont) {
        this.resourceCache.drop(this.unitFont);
        this.unitFont = unitFont;
    }

    public Color getAxesColorObject() {
        return this.getColorObject(this.axesColor);
    }

    public Color getGridColorObject() {
        return this.getColorObject(this.gridColor);
    }

    public Color getTextColorObject() {
        return this.getColorObject(this.textColor);
    }

    public Color getCurveColorObject(int curveNr) {
        return this.getColorObject(this.curveColors[curveNr % this.curveColors.length]);
    }

    public Font getUnitFontObject() {
        return this.getFontObject(this.unitFont);
    }

    public Font getScaleFontObject() {
        return this.getFontObject(this.scaleFont);
    }

    public Font getTextFontObject() {
        return this.getFontObject(this.textFont);
    }

    public Font getNotesFontObject() {
        return this.getFontObject(this.notesFont);
    }

    public Color getColorObject(RGB rgb) {
        return this.resourceCache.getColor(rgb);
    }

    public Pattern getGradientPattern(RGB rgb, float w, float h) {
        return this.resourceCache.getGradientPattern(this.white, rgb, w, h, 192);
    }

    public Pattern getShadowPattern(RGB rgb, float w, float h) {
        return this.resourceCache.getGradientPattern(rgb, rgb, w, h, 128);
    }

    public Font getFontObject(FontData fontData) {
        return this.resourceCache.getFont(fontData);
    }

    public void dispose() {
        this.resourceCache.dispose();
    }

    public static Configuration createDefault() {
        return new Configuration(new RGB(0, 0, 0), new RGB(192, 192, 192), new RGB(0, 0, 0), new RGB[]{new RGB(204, 21, 42), new RGB(6, 59, 88), new RGB(204, 21, 42), new RGB(230, 220, 214)}, new FontData("Courier New", 8, 0), new FontData("Courier New", 8, 0), new FontData("Courier New", 8, 1), new FontData("Courier New", 8, 0), 30, 30, 30, 30, 5, 3, 5, 3);
    }

    public static Configuration createTest() {
        return new Configuration(new RGB(0, 0, 255), new RGB(192, 192, 192), new RGB(0, 0, 0), new RGB[]{new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(0, 255, 255), new RGB(255, 0, 255), new RGB(128, 0, 0), new RGB(0, 128, 0), new RGB(0, 0, 128), new RGB(128, 128, 0), new RGB(0, 128, 128), new RGB(128, 0, 128), new RGB(0, 0, 255), new RGB(255, 255, 0)}, new FontData("Courier New", 10, 0), new FontData("Courier New", 10, 0), new FontData("Courier New", 10, 1), new FontData("Courier New", 8, 0), 30, 30, 30, 60, 5, 3, 5, 3);
    }
}

