/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.layers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.draw2d.Graphics;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Layer;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Metrics;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Rectangle2D;
import org.eclipse.stardust.ide.simulation.ui.curves.swtutil.GCDrawingUtils;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;

public class CalendarLayer
implements Layer {
    Calendar startPoint;
    Calendar endPoint;
    int timeUnit;
    DateFormat format;
    static final DateFormat DAY = new SimpleDateFormat("dd");
    static final DateFormat LDAY = new SimpleDateFormat("dd EE");
    static final DateFormat WEEK = new SimpleDateFormat("'W' ww");
    static final DateFormat LMONTH = new SimpleDateFormat("MMMMM");
    static final DateFormat MONTH = new SimpleDateFormat("MMM");

    public CalendarLayer(Calendar startPoint, Calendar endPoint, int timeUnit, String formatPattern) {
        this.startPoint = startPoint;
        this.endPoint = endPoint;
        this.timeUnit = timeUnit;
        this.format = formatPattern != null ? new SimpleDateFormat(formatPattern) : new SimpleDateFormat("dd");
    }

    @Override
    public void draw(Graphics gc, Metrics metrics, Configuration configuration) {
        gc.pushState();
        gc.setFont(configuration.getFontObject(new FontData(gc.getFont().getFontData()[0].getName(), gc.getFont().getFontData()[0].getHeight() - 2, gc.getFont().getFontData()[0].getStyle())));
        Coord2D c0 = new Coord2D(metrics.getValueRectangle().getMinCorner().getX(), 0.0);
        Coord2D cn = new Coord2D(c0.getX() + this.getSpan(this.startPoint, this.endPoint) + 1.0, metrics.getValueRectangle().getMaxCorner().getY());
        Point p0 = Coord2D.model2swt(metrics.transposeToCanvas(c0));
        Point pn = Coord2D.model2swt(metrics.transposeToCanvas(cn));
        Point pM = new Point(p0.x, pn.y);
        Point pW = new Point(p0.x, pn.y + 12);
        Point pD = new Point(p0.x, pn.y + 24);
        double resolution = (double)(pn.x - p0.x) / this.getSpan(this.startPoint, this.endPoint);
        ScaleStrategy strategy = this.getScaleStrategy(resolution);
        gc.setForegroundColor(configuration.getGridColorObject());
        gc.drawLine(p0.x, p0.y, pn.x, p0.y);
        gc.drawLine(p0.x, pn.y, pn.x, pn.y);
        gc.drawLine(p0.x, pW.y, pn.x, pW.y);
        gc.drawLine(p0.x, pD.y, pn.x, pD.y);
        gc.drawLine(pn.x, p0.y, pn.x, pn.y);
        Calendar current = (Calendar)this.startPoint.clone();
        current.setFirstDayOfWeek(2);
        while (!current.after(this.endPoint)) {
            Coord2D cc = new Coord2D(c0.getX() + this.getSpan(this.startPoint, current), cn.getY());
            Point pc = Coord2D.model2swt(metrics.transposeToCanvas(cc));
            Point pMT = new Point(pc.x + 3, pM.y + 2);
            Point pWT = new Point(pc.x + 3, pW.y + 2);
            Point pDT = new Point(pc.x + 3, pD.y + 2);
            gc.setForegroundColor(configuration.getGridColorObject());
            if (strategy.drawDayTicks) {
                gc.drawLine(pc.x, p0.y, pc.x, pD.y);
            } else if (current.get(5) == 1) {
                gc.drawLine(pc.x, p0.y, pc.x, pD.y);
            }
            if (current.get(5) == 1) {
                gc.drawLine(pc.x, pW.y, pc.x, pM.y);
            }
            if (current.get(7) == 2) {
                gc.drawLine(pc.x, pD.y, pc.x, pW.y);
            }
            gc.setForegroundColor(configuration.getAxesColorObject());
            GCDrawingUtils gcutils = new GCDrawingUtils(gc);
            if (strategy.drawDayLabelLong) {
                gcutils.drawText(LDAY.format(current.getTime()), pDT.x, pDT.y, 16512);
            } else if (strategy.drawDayLabel) {
                gcutils.drawText(DAY.format(current.getTime()), pDT.x, pDT.y, 16512);
            }
            if (strategy.drawWeekLabel && current.get(7) == 2) {
                gcutils.drawText(WEEK.format(current.getTime()), pWT.x, pWT.y, 16512);
            }
            if (current.get(5) == 1) {
                if (strategy.drawMonthLabelLong) {
                    gcutils.drawText(LMONTH.format(current.getTime()), pMT.x, pMT.y, 16512);
                } else if (strategy.drawMonthLabel) {
                    gcutils.drawText(MONTH.format(current.getTime()), pMT.x, pMT.y, 16512);
                }
            }
            current.add(this.timeUnit, 1);
        }
        gc.popState();
    }

    public ScaleStrategy getScaleStrategy(double resolution) {
        ScaleStrategy strategy = new ScaleStrategy();
        strategy.drawDayTicks = resolution > 4.0;
        strategy.drawDayLabelLong = resolution > 25.0;
        strategy.drawDayLabel = resolution > 15.0;
        strategy.drawWeekLabel = resolution > 4.0;
        strategy.drawMonthLabelLong = resolution > 1.3;
        strategy.drawMonthLabel = resolution > 0.4;
        return strategy;
    }

    @Override
    public Rectangle2D getBounds() {
        return new Rectangle2D(0.0, 0.0, this.getSpan(this.startPoint, this.endPoint), 1.0);
    }

    protected double getSpan(Calendar s, Calendar e) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(0L);
        c.add(this.timeUnit, 1);
        return (e.getTimeInMillis() - s.getTimeInMillis()) / c.getTimeInMillis();
    }

    public static class ScaleStrategy {
        boolean drawDayTicks;
        boolean drawDayLabelLong;
        boolean drawDayLabel;
        boolean drawWeekLabel;
        boolean drawMonthLabelLong;
        boolean drawMonthLabel;
    }
}

