/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.layers;

import org.eclipse.draw2d.Graphics;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Metrics;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.CurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.CurveLayerBase;
import org.eclipse.stardust.ide.simulation.ui.curves.swtutil.ColorUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public class ChartCurveLayer
extends CurveLayerBase {
    int gap;

    public ChartCurveLayer(DataProvider provider, int curveNr, int gap) {
        super(provider, curveNr);
        this.gap = gap;
    }

    public ChartCurveLayer(DataProvider provider, RGB color, int gap) {
        super(provider, color);
        this.gap = gap;
    }

    public ChartCurveLayer(DataProvider provider) {
        super(provider);
        this.gap = 10;
    }

    public ChartCurveLayer(CurveLayer wrapped, int gap) {
        super(wrapped);
        this.gap = gap;
    }

    public ChartCurveLayer(CurveLayer wrapped) {
        this(wrapped, 10);
    }

    @Override
    public void draw(Graphics gc, Metrics metrics, Configuration configuration) {
        super.draw(gc, metrics, configuration);
        if (this.getCoords().length > 0) {
            gc.pushState();
            gc.setForegroundColor(this.getColor(configuration));
            gc.setBackgroundColor(configuration.getColorObject(ColorUtils.brighter(gc.getForegroundColor())));
            Point zero = Coord2D.model2swt(metrics.transposeToCanvas(new Coord2D(0.0, 0.0)));
            Point[] points = Coord2D.model2swt(metrics.transposeToCanvas(this.getCoords()));
            Point prev = points[0];
            int i = 1;
            while (i < points.length) {
                this.drawChart(gc, i - 1, zero.y, points[i], (points[i].x - prev.x) * (100 - this.gap) / 100);
                prev = points[i];
                ++i;
            }
            gc.popState();
        }
    }

    protected void drawChart(Graphics gc, int index, int y0, Point point, int size) {
        gc.fillRectangle(point.x - size / 2, y0, size, point.y - y0);
        gc.drawRectangle(point.x - size / 2, y0, size, point.y - y0);
    }
}

