/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.layers;

import org.eclipse.draw2d.Graphics;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DynamicData;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Metrics;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Rectangle2D;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.CurveLayer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

class StandaloneCurveLayer
implements CurveLayer {
    int curveNr;
    RGB color;
    DataProvider provider;
    Coord2D[] coords = null;
    Rectangle2D bounds = null;
    boolean nocache = false;

    public StandaloneCurveLayer(DataProvider provider, int curveNr, RGB color) {
        this.provider = provider;
        this.curveNr = curveNr;
        this.color = color;
        this.nocache = provider instanceof DynamicData;
    }

    @Override
    public void draw(Graphics gc, Metrics metrics, Configuration configuration) {
    }

    private void update() {
        if (this.nocache || this.coords == null) {
            this.coords = this.provider.getPoints();
            if (this.coords.length > 0) {
                this.bounds = null;
                if (this.coords[0] != null) {
                    this.bounds = new Rectangle2D(this.coords[0].getX(), this.coords[0].getY(), 0.0, 0.0);
                    int i = 1;
                    while (i < this.coords.length) {
                        if (this.coords[i] != null) {
                            this.bounds = this.bounds.extend(this.coords[i]);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    @Override
    public Coord2D[] getCoords() {
        this.update();
        return this.coords;
    }

    @Override
    public Rectangle2D getBounds() {
        this.update();
        return this.bounds;
    }

    @Override
    public Color getColor(Configuration configuration) {
        return this.color == null ? configuration.getCurveColorObject(this.curveNr) : configuration.getColorObject(this.color);
    }
}

