/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.layers;

import org.eclipse.draw2d.Graphics;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Layer;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Metrics;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Rectangle2D;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public class VerticalMarkerLayer
implements Layer {
    Double[] positions;
    RGB color;

    public VerticalMarkerLayer(Double[] positions, RGB color) {
        this.positions = positions;
        this.color = color;
    }

    public VerticalMarkerLayer(Double[] positions) {
        this.positions = positions;
    }

    @Override
    public void draw(Graphics gc, Metrics metrics, Configuration configuration) {
        gc.pushState();
        if (this.color != null) {
            gc.setForegroundColor(configuration.getColorObject(this.color));
        } else {
            gc.setForegroundColor(configuration.getGridColorObject());
        }
        int i = 0;
        while (i < this.positions.length) {
            if (this.positions[i] != null) {
                Coord2D c0 = new Coord2D(this.positions[i], metrics.getValueRectangle().getMinCorner().getY());
                Coord2D cn = new Coord2D(this.positions[i], metrics.getValueRectangle().getMaxCorner().getY());
                if (metrics.getValueRectangle().inside(c0) && metrics.getValueRectangle().inside(cn)) {
                    Point p0 = Coord2D.model2swt(metrics.transposeToCanvas(c0));
                    Point pn = Coord2D.model2swt(metrics.transposeToCanvas(cn));
                    this.drawMarker(gc, p0, pn);
                }
            }
            ++i;
        }
        gc.popState();
    }

    public void drawMarker(Graphics gc, Point bottom, Point top) {
        gc.setLineStyle(3);
        gc.drawLine(bottom.x, bottom.y, top.x, top.y);
    }

    @Override
    public Rectangle2D getBounds() {
        return null;
    }
}

