/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.swtutil;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;

public class SwtResourceCache {
    Map cache = new HashMap();
    Display display;

    public void initDisplay(Display display) {
        this.display = display;
    }

    public Display getDisplay() {
        return this.display != null ? this.display : Display.getCurrent();
    }

    public void drop(Object requested) {
        if (this.cache.containsKey(requested)) {
            ((Resource)this.cache.remove(requested)).dispose();
        }
    }

    public Color getColor(RGB requested) {
        Color result = (Color)this.cache.get(requested);
        if (result == null) {
            result = new Color((Device)this.getDisplay(), requested);
            this.cache.put(requested, result);
        }
        return result;
    }

    public Font getFont(FontData requested) {
        Font result = (Font)this.cache.get(requested);
        if (result == null) {
            result = new Font((Device)this.getDisplay(), requested);
            this.cache.put(requested, result);
        }
        return result;
    }

    public Pattern getGradientPattern(RGB requested1, RGB requested2, float w, float h, int alpha) {
        String key = Pattern.class + this.toKey(requested1) + this.toKey(requested2) + this.toKey(w) + this.toKey(h);
        Pattern result = (Pattern)this.cache.get(key);
        if (result == null) {
            result = new Pattern((Device)this.getDisplay(), 0.0f, 0.0f, w, h, this.getColor(requested1), alpha, this.getColor(requested2), alpha);
            this.cache.put(key, result);
        }
        return result;
    }

    private String toKey(RGB rgb) {
        return "#" + rgb.red + ";" + rgb.green + ";" + rgb.blue;
    }

    private String toKey(float f) {
        return "#" + f;
    }

    public void dispose() {
        Iterator iterator = this.cache.values().iterator();
        while (iterator.hasNext()) {
            ((Resource)iterator.next()).dispose();
        }
        this.cache.clear();
        this.display = null;
    }
}

