/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.audittrail;

import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.audittrail.IAuditTrailQuery;
import org.eclipse.stardust.ide.simulation.ui.audittrail.IRetrieveFromAuditTrailConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.AvailabilityConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.CustomDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.DistributionFactory;
import org.eclipse.stardust.ide.simulation.ui.distributions.DurationConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.IDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.NormalDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.PoissonDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.ProbabilityConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.UniformDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AvailabilityCalendarUtility;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.TimeUnitHelper;
import org.eclipse.stardust.ide.simulation.ui.timeutils.ClassifiedTimestampList;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Interval;
import org.eclipse.stardust.ide.simulation.ui.timeutils.IntervalList;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Timestamp;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampHelper;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValue;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValueList;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValueListApproximation;
import org.eclipse.stardust.ide.simulation.ui.validation.SimulationFailedException;

public class AuditTrailEvaluator {
    static final boolean BREAK_ON_INSUFFICIENT_DATA = true;
    static final String DEFAULT_RETRIVAL_DISTRIBUTION_ID = "1004";
    IRetrieveFromAuditTrailConfiguration configuration;
    long dailyInterpolationUnit;
    int longtermInterpolationUnit;
    long customDistributionUnit;
    String interpolationMode;
    TimestampValueListApproximation approximationMode;
    List calenderMaster;
    StringBuffer warning = new StringBuffer();

    public AuditTrailEvaluator(IRetrieveFromAuditTrailConfiguration configuration, Date simulationStartDate, Date simulationEndDate) {
        this.configuration = configuration;
        long l = configuration.getDailyAvailabilityInterpolationUnit().equals("15min") ? TimeUnitHelper.toMilisecond("MINUTE", 15.0) : (configuration.getDailyAvailabilityInterpolationUnit().equals("30min") ? TimeUnitHelper.toMilisecond("MINUTE", 30.0) : (configuration.getDailyAvailabilityInterpolationUnit().equals("2hours") ? TimeUnitHelper.toMilisecond("HOUR", 2.0) : (configuration.getDailyAvailabilityInterpolationUnit().equals("4hours") ? TimeUnitHelper.toMilisecond("HOUR", 4.0) : (this.dailyInterpolationUnit = configuration.getDailyAvailabilityInterpolationUnit().equals("8hours") ? TimeUnitHelper.toMilisecond("HOUR", 8.0) : TimeUnitHelper.toMilisecond("HOUR", 1.0)))));
        int n = configuration.getAvailableResourcesInterpolationUnit().equals("month") ? 2 : (this.longtermInterpolationUnit = configuration.getAvailableResourcesInterpolationUnit().equals("week") ? 3 : 6);
        this.customDistributionUnit = configuration.getCustomDistributionInterpolationUnit().equals("15min") ? TimeUnitHelper.toMilisecond("MINUTE", 15.0) : (configuration.getCustomDistributionInterpolationUnit().equals("30min") ? TimeUnitHelper.toMilisecond("MINUTE", 30.0) : (configuration.getCustomDistributionInterpolationUnit().equals("2hours") ? TimeUnitHelper.toMilisecond("HOUR", 2.0) : (configuration.getCustomDistributionInterpolationUnit().equals("4hours") ? TimeUnitHelper.toMilisecond("HOUR", 4.0) : (configuration.getCustomDistributionInterpolationUnit().equals("8hours") ? TimeUnitHelper.toMilisecond("HOUR", 8.0) : TimeUnitHelper.toMilisecond("HOUR", 1.0)))));
        this.interpolationMode = configuration.getDefaultAvailabilityInterpolationMode();
        this.approximationMode = configuration.getDefaultAvailabilityApproximationMode().equals("linear") ? new TimestampValueListApproximation.Linear() : (configuration.getDefaultAvailabilityApproximationMode().equals("repeate") ? new TimestampValueListApproximation.Repeate() : new TimestampValueListApproximation.Continue());
        this.approximationMode.setTargetInterval(simulationStartDate, simulationEndDate);
        this.calenderMaster = configuration.isResetCalendar() ? AvailabilityCalendarUtility.createAvailabilityCalendar(simulationStartDate, simulationEndDate) : null;
    }

    public void retrieveArrivalRate(AvailabilityConfiguration result, IAuditTrailQuery query) {
        int index;
        IntervalList processTimes = query.execute(this.configuration.getDatabase());
        this.verifyEnoughData(Simulation_Modeling_Messages.ARRIVAL_RATE, query.getObjectHint(), 1, 100, processTimes.size());
        ClassifiedTimestampList[] dayGrid = ClassifiedTimestampList.createDayGrid(this.configuration.getStartDate().getTime(), this.configuration.getEndDate().getTime());
        TimestampValue[] numberOfProcessesPerDay = new TimestampValue[dayGrid.length];
        int i = 0;
        while (i < numberOfProcessesPerDay.length) {
            numberOfProcessesPerDay[i] = new TimestampValue(dayGrid[i].getInterval().getStartTimestamp(), 0.0);
            ++i;
        }
        i = 0;
        while (i < processTimes.size()) {
            Interval processTime = processTimes.get(i);
            index = TimestampValueList.findIndex(processTime, dayGrid);
            numberOfProcessesPerDay[index].addValue(1.0);
            dayGrid[index].add(new TimestampValue(processTime.getStartTimestamp(), 1.0));
            ++i;
        }
        ClassifiedTimestampList[] grid = ClassifiedTimestampList.createGrid(this.longtermInterpolationUnit, this.configuration.getStartDate().getTime(), this.configuration.getEndDate().getTime());
        int i2 = 0;
        while (i2 < numberOfProcessesPerDay.length) {
            index = TimestampValueList.findIndex(numberOfProcessesPerDay[i2], grid);
            grid[index].add(numberOfProcessesPerDay[i2]);
            ++i2;
        }
        TimestampValue[] averageNumberOfProcesses = new TimestampValue[grid.length + 1];
        int i3 = 0;
        while (i3 < grid.length) {
            averageNumberOfProcesses[i3] = new TimestampValue(grid[i3].getInterval().getTime(), grid[i3].averageValue());
            ++i3;
        }
        averageNumberOfProcesses[grid.length] = averageNumberOfProcesses[grid.length - 1];
        TimestampValueList oldNumberOfProcessesCurve = new TimestampValueList();
        oldNumberOfProcessesCurve.addAll(averageNumberOfProcesses);
        TimestampValueList newDailyCurve = new TimestampValueList();
        if (dayGrid.length > 0) {
            long offset = dayGrid[0].getInterval().getTime();
            Interval[] dayUnitInterval = TimestampHelper.createGrid(this.dailyInterpolationUnit, offset, offset + TimeUnitHelper.toMilisecond("DAY", 1.0));
            int[] dayUnitValue = new int[dayUnitInterval.length];
            int[] dayUnitCount = new int[dayUnitInterval.length];
            int uhrzeit = 0;
            while (uhrzeit < dayUnitInterval.length) {
                dayUnitValue[uhrzeit] = 0;
                ++uhrzeit;
            }
            int day = 0;
            while (day < dayGrid.length) {
                long dayOffset = dayGrid[day].getInterval().getTime();
                ClassifiedTimestampList[] dayUnitGrid = ClassifiedTimestampList.createGrid(this.dailyInterpolationUnit, dayOffset, dayOffset + TimeUnitHelper.toMilisecond("DAY", 1.0));
                ClassifiedTimestampList[] dayUnitData = dayGrid[day].groupByTimePeriod(dayUnitGrid, false);
                int uhrzeit2 = 0;
                while (uhrzeit2 < dayUnitInterval.length) {
                    int n = uhrzeit2;
                    dayUnitValue[n] = dayUnitValue[n] + dayUnitData[uhrzeit2].size();
                    int n2 = uhrzeit2;
                    dayUnitCount[n2] = dayUnitCount[n2] + (dayUnitData[uhrzeit2].size() > 0 ? 1 : 0);
                    ++uhrzeit2;
                }
                ++day;
            }
            uhrzeit = 0;
            while (uhrzeit < dayUnitInterval.length) {
                if (dayUnitValue[uhrzeit] > 0 && dayUnitCount[uhrzeit] > 0) {
                    newDailyCurve.add(new TimestampValue(dayUnitInterval[uhrzeit].getStartTimestamp().shiftBackwards(offset), (double)dayUnitValue[uhrzeit] / (double)dayUnitCount[uhrzeit]));
                } else {
                    newDailyCurve.add(new TimestampValue(dayUnitInterval[uhrzeit].getStartTimestamp().shiftBackwards(offset), 0.0));
                }
                ++uhrzeit;
            }
        }
        result.setDay(newDailyCurve.toArray());
        TimestampValueList newNumberOfProcessesCurve = this.approximate(oldNumberOfProcessesCurve);
        result.setYear(newNumberOfProcessesCurve.toArray());
    }

    public void retrieve(AvailabilityConfiguration result, IAuditTrailQuery query) {
        double maximum;
        IntervalList activityTimes = query.execute(this.configuration.getDatabase());
        this.verifyEnoughData(Simulation_Modeling_Messages.AVAILABILITY, query.getObjectHint(), 1, 100, activityTimes.size());
        TimestampValueList availabilityCurve = activityTimes.createQuantityCurve();
        ClassifiedTimestampList[] grid = ClassifiedTimestampList.createGrid(this.longtermInterpolationUnit, this.configuration.getStartDate().getTime(), this.configuration.getEndDate().getTime());
        ClassifiedTimestampList[] gridData = availabilityCurve.groupByTimePeriod(grid);
        TimestampValue[] gridAverage = new TimestampValue[gridData.length + 1];
        int i = 0;
        while (i < gridData.length) {
            gridAverage[i] = new TimestampValue(gridData[i].getInterval().getTime(), this.interpolate(gridData[i]));
            ++i;
        }
        gridAverage[gridData.length] = gridAverage[gridData.length - 1];
        TimestampValueList oldAvailabilityCurve = new TimestampValueList();
        oldAvailabilityCurve.addAll(gridAverage);
        ClassifiedTimestampList[] dataPerDay = availabilityCurve.groupByTimePeriod(ClassifiedTimestampList.createDayGrid(this.configuration.getStartDate().getTime(), this.configuration.getEndDate().getTime()));
        TimestampValueList newDailyCurve = new TimestampValueList();
        if (dataPerDay.length > 0) {
            long offset = dataPerDay[0].getInterval().getTime();
            int i2 = 0;
            while (i2 < dataPerDay.length) {
                double numberOfResources = oldAvailabilityCurve.valueAt(dataPerDay[i2].getInterval().getTime());
                dataPerDay[i2] = dataPerDay[i2].getNormalized(numberOfResources);
                dataPerDay[i2] = dataPerDay[i2].getRelative(offset);
                ++i2;
            }
            Interval[] dayUnitInterval = TimestampHelper.createGrid(this.dailyInterpolationUnit, offset, offset + TimeUnitHelper.toMilisecond("DAY", 1.0));
            double[] dayUnitAverage = new double[dayUnitInterval.length];
            int[] dayUnitCount = new int[dayUnitInterval.length];
            int uhrzeit = 0;
            while (uhrzeit < dayUnitInterval.length) {
                dayUnitAverage[uhrzeit] = 0.0;
                dayUnitCount[uhrzeit] = 0;
                ++uhrzeit;
            }
            int day = 0;
            while (day < dataPerDay.length) {
                ClassifiedTimestampList[] dayUnitGrid = ClassifiedTimestampList.createGrid(this.dailyInterpolationUnit, offset, offset + TimeUnitHelper.toMilisecond("DAY", 1.0));
                ClassifiedTimestampList[] dayUnitData = dataPerDay[day].groupByTimePeriod(dayUnitGrid);
                int uhrzeit2 = 0;
                while (uhrzeit2 < dayUnitInterval.length) {
                    int n = uhrzeit2;
                    dayUnitAverage[n] = dayUnitAverage[n] + this.interpolate(dayUnitData[uhrzeit2]) * (double)dayUnitData[uhrzeit2].size();
                    int n2 = uhrzeit2;
                    dayUnitCount[n2] = dayUnitCount[n2] + dayUnitData[uhrzeit2].size();
                    ++uhrzeit2;
                }
                ++day;
            }
            uhrzeit = 0;
            while (uhrzeit < dayUnitInterval.length) {
                if (dayUnitCount[uhrzeit] > 0) {
                    newDailyCurve.add(new TimestampValue(dayUnitInterval[uhrzeit].getStartTimestamp().shiftBackwards(offset), dayUnitAverage[uhrzeit] / (double)dayUnitCount[uhrzeit]));
                } else {
                    newDailyCurve.add(new TimestampValue(dayUnitInterval[uhrzeit].getStartTimestamp().shiftBackwards(offset), 0.0));
                }
                ++uhrzeit;
            }
        }
        if ((maximum = newDailyCurve.maxValue()) > 0.001) {
            newDailyCurve = this.normalize(newDailyCurve, 1.0 / maximum);
            oldAvailabilityCurve = this.normalize(oldAvailabilityCurve, maximum);
        }
        result.setDay(newDailyCurve.toArray());
        TimestampValueList newAvailabilityCurve = this.approximate(oldAvailabilityCurve);
        result.setYear(newAvailabilityCurve.toArray());
        result.getMultiplicator().setValue(1.0);
        if (this.calenderMaster != null) {
            result.setPredefinedCalendars(new String[0]);
            result.setCalendar(this.calenderMaster.toArray(new TimestampValue[this.calenderMaster.size()]));
        }
    }

    public void retrieve(DurationConfiguration result, IAuditTrailQuery query) {
        boolean forced = false;
        IDistributionConfiguration distribution = result.getDistribution();
        if (distribution == null) {
            forced = true;
            DistributionFactory distributionFactory = new DistributionFactory(new SimulationInterval(this.configuration.getStartDate(), this.configuration.getEndDate()));
            distribution = distributionFactory.create(DEFAULT_RETRIVAL_DISTRIBUTION_ID);
            result.setDistribution(distribution);
        }
        if (distribution instanceof PoissonDistributionConfiguration) {
            this.retrieve(result, (PoissonDistributionConfiguration)distribution, query);
        } else if (distribution instanceof NormalDistributionConfiguration) {
            this.retrieve(result, (NormalDistributionConfiguration)distribution, query);
        } else if (distribution instanceof UniformDistributionConfiguration) {
            this.retrieve(result, (UniformDistributionConfiguration)distribution, query);
        } else if (distribution instanceof CustomDistributionConfiguration) {
            this.retrieve(result, (CustomDistributionConfiguration)distribution, query);
        }
        if (forced) {
            CustomDistributionConfiguration test = (CustomDistributionConfiguration)result.getDistribution();
            List points = test.getPoints();
            if (points.size() >= 2) {
                this.addWarning(MessageFormat.format(Simulation_Modeling_Messages.ERROR_DISTRIBUTION_SET_TO_DEFAULT_INFO, query.getObjectHint()));
            } else {
                result.setDistribution(null);
            }
        }
    }

    public void retrieve(DurationConfiguration duration, PoissonDistributionConfiguration result, IAuditTrailQuery query) {
        IntervalList activityTimes = query.execute(this.configuration.getDatabase());
        this.verifyEnoughData(Simulation_Modeling_Messages.DURATION, query.getObjectHint(), 1, 100, activityTimes.size());
        double average = activityTimes.averageDuration();
        String unitId = TimeUnitHelper.getBestUnit(average);
        duration.setUnitId(unitId);
        result.getLambda().setValue(Math.round(average / TimeUnitHelper.getDoubleMultiplicator(unitId)));
    }

    public void retrieve(DurationConfiguration duration, NormalDistributionConfiguration result, IAuditTrailQuery query) {
        IntervalList activityTimes = query.execute(this.configuration.getDatabase());
        this.verifyEnoughData(Simulation_Modeling_Messages.DURATION, query.getObjectHint(), 1, 100, activityTimes.size());
        double average = activityTimes.averageDuration();
        double variance = activityTimes.varianceDuration(average);
        String unitId = TimeUnitHelper.getBestUnit(average);
        duration.setUnitId(unitId);
        result.getMju().setValue(average / TimeUnitHelper.getDoubleMultiplicator(unitId));
        result.getSigmaSqr().setValue(variance / TimeUnitHelper.getDoubleMultiplicatorSqr(unitId));
    }

    public void retrieve(DurationConfiguration duration, UniformDistributionConfiguration result, IAuditTrailQuery query) {
        IntervalList activityTimes = query.execute(this.configuration.getDatabase());
        this.verifyEnoughData(Simulation_Modeling_Messages.DURATION, query.getObjectHint(), 1, 100, activityTimes.size());
        long min = activityTimes.minDuration();
        long max = activityTimes.maxDuration();
        String unitId = TimeUnitHelper.getBestUnit(min);
        duration.setUnitId(unitId);
        result.getStartPoint().setValue((double)min / TimeUnitHelper.getDoubleMultiplicator(unitId));
        result.getEndPoint().setValue((double)max / TimeUnitHelper.getDoubleMultiplicator(unitId));
    }

    public void retrieve(DurationConfiguration duration, CustomDistributionConfiguration result, IAuditTrailQuery query) {
        TimestampValue[] distributionTimes;
        IntervalList activityTimes = query.execute(this.configuration.getDatabase());
        this.verifyEnoughData(Simulation_Modeling_Messages.DURATION, query.getObjectHint(), 1, 100, activityTimes.size());
        long max = activityTimes.maxDuration();
        String unitId = TimeUnitHelper.getBestUnit(max);
        double timeScale = TimeUnitHelper.getDoubleMultiplicator(unitId);
        long interpolationUnit = this.findBestInterpolationUnitInMillis(unitId, max);
        TimestampValueList distributionData = new TimestampValueList();
        int i = 0;
        while (i < activityTimes.size()) {
            Interval interval = activityTimes.get(i);
            distributionData.add(new TimestampValue(this.configuration.getStartDate().getTime() + interval.getDuration(), 1.0));
            ++i;
        }
        if (distributionData.size() > 0) {
            ClassifiedTimestampList[] grid = ClassifiedTimestampList.createGrid(interpolationUnit, this.configuration.getStartDate().getTime(), this.configuration.getStartDate().getTime() + max);
            ClassifiedTimestampList[] gridData = distributionData.groupByTimePeriod(grid, false);
            long offset = this.configuration.getStartDate().getTime();
            distributionTimes = new TimestampValue[gridData.length + 1];
            int i2 = 0;
            while (i2 < gridData.length) {
                Timestamp ts = gridData[i2].getInterval().getStartTimestamp().shiftBackwards(offset);
                distributionTimes[i2] = new TimestampValue(ts, (double)gridData[i2].size() / (double)distributionData.size());
                ++i2;
            }
            Timestamp ts = gridData[gridData.length - 1].getInterval().getEndTimestamp().shiftBackwards(offset);
            distributionTimes[gridData.length] = new TimestampValue(ts, 0.0);
        } else {
            distributionTimes = new TimestampValue[]{new TimestampValue(0L, 1.0), new TimestampValue(max, 0.0)};
        }
        duration.setUnitId(unitId);
        TimestampValue[] distributionCurve = new TimestampValue[distributionTimes.length];
        int i3 = 0;
        while (i3 < distributionCurve.length) {
            distributionCurve[i3] = new TimestampValue((long)((double)distributionTimes[i3].getTime() / timeScale), distributionTimes[i3].getValue());
            ++i3;
        }
        result.setPoints(distributionCurve);
        result.getEndPoint().setValue((double)max / timeScale);
    }

    public void retrieve(ProbabilityConfiguration result, IAuditTrailQuery transitionQuery, IAuditTrailQuery activityQuery) {
        IntervalList transitionTimes = transitionQuery.execute(this.configuration.getDatabase());
        this.verifyEnoughData(Simulation_Modeling_Messages.PROBABILITY, transitionQuery.getObjectHint(), 1, 100, transitionTimes.size());
        IntervalList activityTimes = activityQuery.execute(this.configuration.getDatabase());
        long duration = result.getInterval().getDurationInMillis();
        double probability = 100.0 * (double)transitionTimes.size() / (double)activityTimes.size();
        result.setCurve(new TimestampValue[]{new TimestampValue(0L, probability), new TimestampValue(duration, probability)});
        result.setEndPoint(duration);
        result.getMultiplicator().setValue(1.0);
    }

    protected double interpolate(TimestampValueList curve) {
        if (this.interpolationMode.equals("max")) {
            return curve.maxValue();
        }
        return curve.weightedAverageValue();
    }

    private TimestampValueList normalize(TimestampValueList original, double scale) {
        if (this.interpolationMode.equals("max")) {
            return original;
        }
        TimestampValueList copy = new TimestampValueList();
        int i = 0;
        while (i < original.size()) {
            TimestampValue oldTS = original.get(i);
            TimestampValue newTS = new TimestampValue(oldTS, oldTS.getValue() * scale);
            copy.add(newTS);
            ++i;
        }
        return copy;
    }

    protected TimestampValueList approximate(TimestampValueList curve) {
        return this.approximationMode.transpose(curve, this.longtermInterpolationUnit);
    }

    private long findBestInterpolationUnitInMillis(String unitId, long max) {
        long unitMultiplicator = TimeUnitHelper.getMultiplicator(unitId);
        if (unitId.equals("MILLISECOND")) {
            if (max > 500L) {
                return unitMultiplicator * 100L;
            }
            if (max > 20L) {
                return unitMultiplicator * 10L;
            }
            return unitMultiplicator;
        }
        if (unitId.equals("SECOND")) {
            if (max > 50L * unitMultiplicator) {
                return unitMultiplicator * 10L;
            }
            if (max > 2L * unitMultiplicator) {
                return unitMultiplicator;
            }
            return TimeUnitHelper.getMultiplicator("MILLISECOND") * 100L;
        }
        if (unitId.equals("MINUTE")) {
            if (max > 50L * unitMultiplicator) {
                return unitMultiplicator * 10L;
            }
            if (max > 2L * unitMultiplicator) {
                return unitMultiplicator;
            }
            return TimeUnitHelper.getMultiplicator("SECOND") * 10L;
        }
        if (unitId.equals("HOUR")) {
            if (max > 2L * unitMultiplicator) {
                return unitMultiplicator;
            }
            return TimeUnitHelper.getMultiplicator("MINUTE") * 10L;
        }
        if (unitId.equals("DAY")) {
            if (max > 2L * unitMultiplicator) {
                return unitMultiplicator;
            }
            return TimeUnitHelper.getMultiplicator("HOUR") * 12L;
        }
        return unitMultiplicator;
    }

    public boolean hasWarning() {
        return this.warning.length() > 0;
    }

    public String getWarning() {
        return this.hasWarning() ? this.warning.toString() : null;
    }

    public void addWarning(String text) {
        if (this.hasWarning()) {
            this.warning.append("\n");
        }
        this.warning.append(text);
    }

    public void verifyEnoughData(String parameterName, String elementId, int required, int sufficiend, int found) {
        if (found < required) {
            throw new SimulationFailedException(Simulation_Modeling_Messages.AUDITTRAIL_ERR_INSUFFICIENT_DATA, parameterName, parameterName.toLowerCase(), elementId, null);
        }
        if (found < sufficiend) {
            this.addWarning(MessageFormat.format(Simulation_Modeling_Messages.AUDITTRAIL_ERR_INSUFFICIENT_DATA_WARN, parameterName, parameterName.toLowerCase(), elementId));
        }
    }
}

