/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.audittrail;

import java.util.Arrays;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.stardust.ide.simulation.ui.audittrail.AuditTrailEvaluatorDebug;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProviderForDiscreteArray;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Drawing;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Layer;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.DiscreteCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.XAxisLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.YAxisLayer;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.CurveUtils;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValue;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValueList;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.ViewPart;

public class AuditTrailEvaluatorDebugView
extends ViewPart {
    public static final String ID = "org.eclipse.stardust.ide.simulation.ui.audittrail.AuditTrailEvaluatorDebugView";
    Combo knownObjects;
    Combo curveTypes;
    Canvas drawingPanel;
    Drawing drawing;

    public void createPartControl(Composite parent) {
        Label knownObjectsLabel = FormBuilder.createLabel((Composite)parent, (String)"Objects:");
        this.knownObjects = FormBuilder.createCombo((Composite)parent);
        this.knownObjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuditTrailEvaluatorDebugView.this.updateCurveTypes();
            }
        });
        Label curveTypesLabel = FormBuilder.createLabel((Composite)parent, (String)"Curves:");
        this.curveTypes = FormBuilder.createCombo((Composite)parent);
        this.curveTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuditTrailEvaluatorDebugView.this.updateDrawing();
            }
        });
        this.drawing = new Drawing(Configuration.createDefault());
        this.drawingPanel = new Canvas(parent, 0x20000800);
        this.drawingPanel.addPaintListener((PaintListener)this.drawing);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 5).numColumns(2).applyTo(parent);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)knownObjectsLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.knownObjects);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)curveTypesLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.curveTypes);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)this.drawingPanel);
    }

    public void setFocus() {
        this.updateKnownObjects();
        this.knownObjects.setFocus();
    }

    public void addLayer(Layer layer) {
        this.drawing.addLayer(layer);
        this.drawingPanel.redraw();
    }

    protected void updateKnownObjects() {
        String[] items = AuditTrailEvaluatorDebug.getKnownObjects();
        if (items != null && items.length > 0) {
            this.knownObjects.setItems(items);
        } else {
            this.knownObjects.setItems(new String[]{"empty"});
        }
        this.updateCurveTypes();
    }

    protected void updateCurveTypes() {
        if (this.knownObjects.getSelectionIndex() >= 0) {
            String objectId = this.knownObjects.getItem(this.knownObjects.getSelectionIndex());
            String[] items = AuditTrailEvaluatorDebug.getCurveTypes(objectId);
            if (items != null && items.length > 0) {
                this.curveTypes.setItems(items);
            } else {
                this.curveTypes.setItems(new String[]{"empty"});
            }
        } else {
            this.curveTypes.setItems(new String[]{"empty"});
        }
        this.updateDrawing();
    }

    protected void updateDrawing() {
        this.drawing.removeAllLayers();
        this.drawing.addLayer((Layer)new XAxisLayer("x", null, 1.0, 24.0, 24.0, "####", true));
        this.drawing.addLayer((Layer)new YAxisLayer("y", null, 1.0, 1.0, 1.0, "####", true));
        if (this.knownObjects.getSelectionIndex() >= 0) {
            String curveType;
            TimestampValueList[] curves;
            String objectId = this.knownObjects.getItem(this.knownObjects.getSelectionIndex());
            if (this.curveTypes.getSelectionIndex() >= 0 && (curves = AuditTrailEvaluatorDebug.getCurves(objectId, curveType = this.curveTypes.getItem(this.curveTypes.getSelectionIndex()))) != null) {
                int i = 0;
                while (i < curves.length) {
                    TimestampValue[] timestamps = curves[i].toArray();
                    Coord2D[] coords = CurveUtils.toCurve(3600000.0, Arrays.asList(timestamps));
                    DataProviderForDiscreteArray dataProvider = new DataProviderForDiscreteArray(coords);
                    this.addLayer((Layer)new DiscreteCurveLayer((DataProvider)dataProvider, i + 1));
                    ++i;
                }
            }
        }
    }
}

