/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.commongui;

import org.eclipse.stardust.ide.simulation.ui.commongui.VerificationStatusHandler;
import org.eclipse.stardust.ide.simulation.ui.commongui.VerifyDoubleFormat;

public class VerifyDoubleMinMax
extends VerifyDoubleFormat {
    double min;
    double max;

    public VerifyDoubleMinMax(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public VerifyDoubleMinMax(double min, double max, VerificationStatusHandler errorHandler) {
        super(errorHandler);
        this.min = min;
        this.max = max;
    }

    @Override
    protected boolean isValid(String text) {
        if (this.min >= 0.0 && text.startsWith("-")) {
            return false;
        }
        return super.isValid(text);
    }

    @Override
    protected boolean isReady(String text) {
        return super.isReady(text) && this.isInRange(Double.parseDouble(text));
    }

    private boolean isInRange(double i) {
        return this.min <= i && i <= this.max;
    }

    @Override
    public double fromString(String text) {
        return Math.max(this.min, Math.min(this.max, super.fromString(text)));
    }
}

