/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.datagen;

import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.datagen.NormalDistributionDataGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.NormalDistributionDoubleGeneratorPanel;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGeneratorPanel;
import org.eclipse.swt.widgets.Composite;

public class NormalDistributionDoubleGenerator
extends NormalDistributionDataGenerator {
    public static final String OPTION_PRECISION = "precision";

    public NormalDistributionDoubleGenerator(SimulationInterval interval) {
        super(interval);
        this.options.put(OPTION_PRECISION, "2");
    }

    @Override
    public Object getRandom() {
        return this.applyPrecision(this.getRandomImpl());
    }

    @Override
    public Class getResultClass() {
        return Double.class;
    }

    private Double applyPrecision(Double r) {
        double precisonFactor = Math.pow(10.0, this.getPrecision());
        return new Double((double)Math.round(r * precisonFactor) / precisonFactor);
    }

    private int getPrecision() {
        return Math.abs(Integer.parseInt(this.getOption(OPTION_PRECISION)));
    }

    @Override
    public RandomDataGeneratorPanel createPanel(Composite parent) {
        return new NormalDistributionDoubleGeneratorPanel(parent, this);
    }
}

