/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.datagen;

import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.datagen.NormalDistributionDataGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.NormalDistributionIntegerGeneratorPanel;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGeneratorPanel;
import org.eclipse.swt.widgets.Composite;

public class NormalDistributionIntegerGenerator
extends NormalDistributionDataGenerator {
    public static final String OPTION_MULTIPLICATOR = "multiplicator";

    public NormalDistributionIntegerGenerator(SimulationInterval interval) {
        super(interval);
        this.options.put("mju", "0");
        this.options.put("sigma", "100");
        this.options.put(OPTION_MULTIPLICATOR, "1");
    }

    @Override
    public Object getRandom() {
        return this.applyMultiplicator(this.getRandomImpl().intValue());
    }

    @Override
    public Class getResultClass() {
        return Integer.class;
    }

    public int getMultiplicator() {
        try {
            return Integer.parseInt(this.getOption(OPTION_MULTIPLICATOR));
        }
        catch (NumberFormatException numberFormatException) {
            return 1;
        }
    }

    private Integer applyMultiplicator(int r) {
        return new Integer(r * this.getMultiplicator());
    }

    @Override
    public RandomDataGeneratorPanel createPanel(Composite parent) {
        return new NormalDistributionIntegerGeneratorPanel(parent, this);
    }
}

