/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.datagen;

import java.util.Random;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.datagen.PoissonDistributionDataGeneratorPanel;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGeneratorPanel;
import org.eclipse.swt.widgets.Composite;

public class PoissonDistributionDataGenerator
extends RandomDataGenerator {
    public static final String NAME = Simulation_Modeling_Messages.DATA_GENERATOR_POISSON_INTEGER;
    public static final String OPTION_LAMBDA = "lambda";
    public static final String OPTION_MULTIPLICATOR = "multiplicator";
    Random random = new Random(System.currentTimeMillis());

    public PoissonDistributionDataGenerator(SimulationInterval interval) {
        super(interval);
        this.options.put(OPTION_LAMBDA, "10");
        this.options.put(OPTION_MULTIPLICATOR, "1");
    }

    @Override
    public Object getRandom() {
        return this.applyMultiplicator(this.getRandomImpl());
    }

    private int getRandomImpl() {
        double elambda = Math.exp(-1.0 * this.getLambda());
        double product = 1.0;
        int count = 0;
        int result = 0;
        while (product >= elambda) {
            product *= Math.random();
            result = count++;
        }
        return result;
    }

    @Override
    public Class getResultClass() {
        return Integer.class;
    }

    protected double getLambda() {
        return Double.parseDouble(this.getOption(OPTION_LAMBDA));
    }

    public int getMultiplicator() {
        try {
            return Integer.parseInt(this.getOption(OPTION_MULTIPLICATOR));
        }
        catch (NumberFormatException numberFormatException) {
            return 1;
        }
    }

    private Integer applyMultiplicator(int r) {
        return new Integer(r * this.getMultiplicator());
    }

    @Override
    public RandomDataGeneratorPanel createPanel(Composite parent) {
        return new PoissonDistributionDataGeneratorPanel(parent, this);
    }

    @Override
    public boolean isComplete() {
        try {
            Integer.parseInt(this.getOption(OPTION_MULTIPLICATOR));
            return this.getLambda() > 0.0;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

