/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.datagen;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGeneratorPanel;
import org.eclipse.stardust.ide.simulation.ui.datagen.ResourceFileDataGenerator;
import org.eclipse.stardust.ide.simulation.ui.validation.ValidationUtils;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

public class ResourceFileDataGeneratorPanel
extends RandomDataGeneratorPanel {
    static final String SUPPORTED_FILE_EXTENSIONS = "txt, csv, dat";
    static final Set SUPPORTED_FILE_EXTENSIONS_SET = new HashSet<String>(Arrays.asList("txt, csv, dat".split(" *, *")));
    LabeledText fileName;
    Button fileNameBrowse;
    Button withHeader;

    protected ResourceFileDataGeneratorPanel(Composite parent, ResourceFileDataGenerator configuration) {
        super(parent, configuration);
        LabelWithStatus fileNameLabel = FormBuilder.createLabelWithLeftAlignedStatus((Composite)this.getInnerBody(), (String)Simulation_Modeling_Messages.DATA_GENERATION_RESOURCE_FILE_RESOURCE_FILE_LABEL);
        Composite composite1 = new Composite(this.getInnerBody(), 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(0, 0).spacing(5, 0).applyTo(composite1);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)composite1);
        Text fileNameText = FormBuilder.createText((Composite)composite1);
        this.fileNameBrowse = FormBuilder.createButton((Composite)composite1, (String)Simulation_Modeling_Messages.FILE_SELECTION_BROWSE_BUTTON, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String result = ResourceFileDataGeneratorPanel.this.browseFiles();
                if (result != null) {
                    ResourceFileDataGeneratorPanel.this.fileName.getText().setText(result);
                }
            }
        });
        this.fileName = new LabeledText(fileNameText, fileNameLabel);
        this.fileName.getText().setText(configuration.getOption("filename"));
        this.fileName.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceFileDataGeneratorPanel.this.verifyFile();
            }
        });
        FormBuilder.createLabel((Composite)this.getInnerBody(), (String)"");
        this.withHeader = FormBuilder.createCheckBox((Composite)this.getInnerBody(), (String)Simulation_Modeling_Messages.DATA_GENERATION_RESOURCE_FILE_FIRST_LINE_IN_HEADER);
        this.withHeader.setSelection("true".equals(configuration.getOption("header")));
        this.verifyFile();
    }

    @Override
    protected void syncUiToModel() {
        this.configuration.getOptions().put("filename", this.fileName.getText().getText());
        this.configuration.getOptions().put("header", Boolean.toString(this.withHeader.getSelection()));
        super.syncUiToModel();
    }

    protected void verifyFile() {
        String fileNameValue = this.fileName.getText().getText();
        if (StringUtils.isEmpty((String)fileNameValue)) {
            this.fileName.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
            this.fileName.getLabel().setToolTipText(ValidationUtils.format(Simulation_Modeling_Messages.ERROR_VALUE_IS_NOT_VALID, Simulation_Modeling_Messages.DATA_GENERATION_RESOURCE_FILE_RESOURCE_FILE_LABEL, this.fileName.getText().getText()));
        } else {
            try {
                if (!ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileNameValue)).exists()) {
                    this.fileName.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
                    this.fileName.getLabel().setToolTipText(ValidationUtils.format(Simulation_Modeling_Messages.ERROR_FILE_NOT_FOUND, Simulation_Modeling_Messages.DATA_GENERATION_RESOURCE_FILE_RESOURCE_FILE_LABEL, this.fileName.getText().getText()));
                } else {
                    this.fileName.getLabel().setValidationStatus(IQuickValidationStatus.OK);
                    this.fileName.getLabel().setToolTipText(null);
                }
            }
            catch (RuntimeException runtimeException) {
                this.fileName.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
                this.fileName.getLabel().setToolTipText(ValidationUtils.format(Simulation_Modeling_Messages.ERROR_VALUE_IS_NOT_VALID, Simulation_Modeling_Messages.DATA_GENERATION_RESOURCE_FILE_RESOURCE_FILE_LABEL, this.fileName.getText().getText()));
            }
        }
    }

    protected String browseFiles() {
        Object[] files;
        ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1){

            protected boolean select(IResource resource) {
                if (resource instanceof IFile) {
                    return SUPPORTED_FILE_EXTENSIONS_SET.contains(((IFile)resource).getFileExtension());
                }
                return super.select(resource);
            }
        };
        dialog.setTitle(MessageFormat.format(Simulation_Modeling_Messages.FILE_SELECTION_MESSAGE, SUPPORTED_FILE_EXTENSIONS));
        if (dialog.open() == 0 && (files = dialog.getResult()) != null && files.length > 0) {
            return ((IFile)files[0]).getFullPath().toString();
        }
        return null;
    }
}

