/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.datagen;

import java.util.Calendar;
import java.util.Random;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGeneratorPanel;
import org.eclipse.stardust.ide.simulation.ui.datagen.TimestampBaseGeneratorPanel;
import org.eclipse.swt.widgets.Composite;

public abstract class TimestampBaseGenerator
extends RandomDataGenerator {
    public static final String NAME = Simulation_Modeling_Messages.DATA_GENERATOR_DATE;
    public static final String OPTION_START_POINT = "startPoint";
    public static final String OPTION_END_POINT = "endPoint";
    Random random = new Random(System.currentTimeMillis());

    public TimestampBaseGenerator(SimulationInterval interval) {
        super(interval);
        Calendar c = Calendar.getInstance();
        this.options.put(OPTION_START_POINT, Long.toString(c.getTime().getTime()));
        c.add(1, 1);
        this.options.put(OPTION_END_POINT, Long.toString(c.getTime().getTime()));
    }

    public long getRandomImpl() {
        return this.getStartPoint() + Math.round((double)this.getRange() * this.random.nextDouble());
    }

    private long getStartPoint() {
        return Long.parseLong(this.getOption(OPTION_START_POINT));
    }

    private long getEndPoint() {
        return Long.parseLong(this.getOption(OPTION_END_POINT));
    }

    private long getRange() {
        return this.getEndPoint() - this.getStartPoint();
    }

    @Override
    public RandomDataGeneratorPanel createPanel(Composite parent) {
        return new TimestampBaseGeneratorPanel(parent, this);
    }

    @Override
    public boolean isComplete() {
        try {
            this.getStartPoint();
            this.getEndPoint();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

