/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.datagen;

import java.util.Random;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGeneratorPanel;
import org.eclipse.stardust.ide.simulation.ui.datagen.UniformDistributionDataGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.UniformDistributionDoubleGeneratorPanel;
import org.eclipse.swt.widgets.Composite;

public class UniformDistributionDoubleGenerator
extends UniformDistributionDataGenerator {
    public static final String NAME = Simulation_Modeling_Messages.DATA_GENERATOR_UNIFORM_DOUBLE;
    Random random = new Random(System.currentTimeMillis());

    public UniformDistributionDoubleGenerator(SimulationInterval interval) {
        super(interval);
        this.options.put("endPoint", "99999");
    }

    @Override
    public Object getRandom() {
        return new Double(this.getStartPoint() + this.getRange() * this.random.nextDouble());
    }

    @Override
    public Class getResultClass() {
        return Double.class;
    }

    private double getStartPoint() {
        return Double.parseDouble(this.getOption("startPoint"));
    }

    private double getEndPoint() {
        return Double.parseDouble(this.getOption("endPoint"));
    }

    private double getRange() {
        return this.getEndPoint() - this.getStartPoint();
    }

    @Override
    public RandomDataGeneratorPanel createPanel(Composite parent) {
        return new UniformDistributionDoubleGeneratorPanel(parent, this);
    }
}

