/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.distributions.utils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.stardust.ide.simulation.ui.timeutils.HolidaysExtension;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimeCalculator;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValue;

public class AvailabilityCalendarUtility {
    public static final long HOUR_IN_MILLISEC = 3600000L;
    public static final long DAY_IN_MILLISEC = 86400000L;
    private static Map holidayExtensionCache = new HashMap();

    public static List createAvailabilityCalendar(Date startDate, Date endDate) {
        TimeCalculator start = new TimeCalculator(startDate).moveToBeginOfDay();
        TimeCalculator itr = new TimeCalculator(startDate).moveToBeginOfDay();
        TimeCalculator end = new TimeCalculator(endDate).moveToBeginOfDay();
        ArrayList<TimestampValue> result = new ArrayList<TimestampValue>(366);
        while (!itr.after(end)) {
            result.add(new TimestampValue(itr.toLong() - start.toLong(), 1.0));
            itr.add(6, 1);
        }
        return result;
    }

    public static List addToAvailabilityCalendar(Date dateOffset, List result, String listName) {
        long milisOffset = dateOffset.getTime();
        ArrayList old = new ArrayList(result);
        result.clear();
        for (TimestampValue availability : old) {
            if (availability.getValue() >= 1.1) {
                result.add(new TimestampValue(availability.getTime(), availability.getValue()));
                continue;
            }
            if (AvailabilityCalendarUtility.isOnList(listName, milisOffset + availability.getTime())) {
                result.add(new TimestampValue(availability.getTime(), 0.0));
                continue;
            }
            result.add(new TimestampValue(availability.getTime(), availability.getValue()));
        }
        return result;
    }

    public static List removeFromAvailabilityCalendar(long offset, List result, String listName) {
        ArrayList old = new ArrayList(result);
        result.clear();
        for (TimestampValue availability : old) {
            if (AvailabilityCalendarUtility.isOnList(listName, offset + availability.getTime())) {
                result.add(new TimestampValue(availability.getTime(), 1.0));
                continue;
            }
            result.add(new TimestampValue(availability.getTime(), availability.getValue()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isOnList(String holidaysExtensionClassName, Calendar calendar) {
        HolidaysExtension holidaysExtension;
        if (!holidayExtensionCache.containsKey(holidaysExtensionClassName)) {
            Map map = holidayExtensionCache;
            synchronized (map) {
                if (!holidayExtensionCache.containsKey(holidaysExtensionClassName)) {
                    try {
                        HolidaysExtension holidaysExtension2 = (HolidaysExtension)Class.forName(holidaysExtensionClassName).newInstance();
                        holidayExtensionCache.put(holidaysExtensionClassName, holidaysExtension2);
                    }
                    catch (Exception exception) {
                        holidayExtensionCache.put(holidaysExtensionClassName, null);
                        System.out.println("Holiday Extension Class <" + holidaysExtensionClassName + "> can not be loaded, check the classname/classpath");
                        return false;
                    }
                }
            }
        }
        if ((holidaysExtension = (HolidaysExtension)holidayExtensionCache.get(holidaysExtensionClassName)) == null) {
            return false;
        }
        return holidaysExtension.isHoliday(calendar);
    }

    public static boolean isOnList(String holidayListId, long timestamp) {
        Calendar calendar = new TimeCalculator(timestamp).toCalendar();
        return AvailabilityCalendarUtility.isOnList(holidayListId, calendar);
    }

    public static boolean isOnOneOfLists(String[] lists, Calendar calendar) {
        int i = 0;
        while (i < lists.length) {
            if (AvailabilityCalendarUtility.isOnList(lists[i], calendar)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List markUncommonWorkdays(Date dateOffset, List result, List predefinedHolidays) {
        String[] predefinedHolidaysArray = predefinedHolidays.toArray(new String[predefinedHolidays.size()]);
        long milisOffset = dateOffset.getTime();
        ArrayList old = new ArrayList(result);
        result.clear();
        for (TimestampValue availability : old) {
            Calendar calendar = new TimeCalculator(milisOffset + availability.getTime()).toCalendar();
            if (availability.getValue() >= 0.1 && AvailabilityCalendarUtility.isOnOneOfLists(predefinedHolidaysArray, calendar)) {
                result.add(new TimestampValue(availability.getTime(), 2.0));
                continue;
            }
            result.add(new TimestampValue(availability.getTime(), availability.getValue()));
        }
        return result;
    }

    public static List unmarkUncommonWorkdays(List result) {
        ArrayList old = new ArrayList(result);
        result.clear();
        for (TimestampValue availability : old) {
            if (availability.getValue() >= 1.1) {
                result.add(new TimestampValue(availability.getTime(), 1.0));
                continue;
            }
            result.add(new TimestampValue(availability.getTime(), availability.getValue()));
        }
        return result;
    }
}

