/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.gui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.stardust.ide.simulation.ui.SimulationPlugin;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.commongui.VerifyDoubleFormat;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDoubleRange;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateSliderDialog
extends TitleAreaDialog {
    Text labelText;
    Text minText;
    Text maxText;
    Text incText;
    String title;
    String message;
    AdjustableDoubleRange slider;
    boolean withDelete;

    public CreateSliderDialog(Shell parentShell, String title, String message, AdjustableDoubleRange initialValues, boolean withDelete) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.slider = initialValues;
        this.withDelete = withDelete;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.title);
        this.setMessage(this.message);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite panel = FormBuilder.createComposite((Composite)area, (int)2);
        Label labelLabel = FormBuilder.createLabel((Composite)panel, (String)Simulation_Modeling_Messages.CREATE_SLIDER_LABEL);
        this.labelText = FormBuilder.createText((Composite)panel);
        this.labelText.setText(this.slider.getLabel());
        VerifyDoubleFormat verifyFormat = new VerifyDoubleFormat();
        LabelWithStatus minLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)panel, (String)Simulation_Modeling_Messages.CREATE_SLIDER_LOWER_VALUE);
        this.minText = FormBuilder.createText((Composite)panel);
        this.minText.setText(Double.toString(this.slider.getMinValue()));
        this.minText.addVerifyListener((VerifyListener)verifyFormat);
        this.minText.addFocusListener((FocusListener)verifyFormat);
        LabelWithStatus maxLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)panel, (String)Simulation_Modeling_Messages.CREATE_SLIDER_UPPER_VALUE);
        this.maxText = FormBuilder.createText((Composite)panel);
        this.maxText.setText(Double.toString(this.slider.getMaxValue()));
        this.maxText.addVerifyListener((VerifyListener)verifyFormat);
        this.maxText.addFocusListener((FocusListener)verifyFormat);
        LabelWithStatus incLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)panel, (String)Simulation_Modeling_Messages.CREATE_SLIDER_RESOLUTION);
        this.incText = FormBuilder.createText((Composite)panel);
        this.incText.setText(Double.toString(this.slider.getIncrement()));
        this.incText.addVerifyListener((VerifyListener)verifyFormat);
        this.incText.addFocusListener((FocusListener)verifyFormat);
        this.slider = null;
        CreateSliderDialog.setDialogHelpAvailable((boolean)false);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)panel);
        GridLayoutFactory.fillDefaults().margins(10, 10).spacing(5, 5).numColumns(2).applyTo(panel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)labelLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.labelText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)minLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.minText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)maxLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.maxText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)incLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.incText);
        return area;
    }

    protected void okPressed() {
        try {
            this.slider = new AdjustableDoubleRange(this.labelText.getText(), Double.parseDouble(this.minText.getText()), Double.parseDouble(this.maxText.getText()), Double.parseDouble(this.incText.getText()));
        }
        catch (NumberFormatException e) {
            SimulationPlugin.getDefault().getLog().log((IStatus)new Status(1, SimulationPlugin.getDefault().getBundle().getSymbolicName(), 0, null, (Throwable)e));
            this.slider = null;
        }
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.withDelete) {
            this.createButton(parent, 0, Simulation_Modeling_Messages.CREATE_SLIDER_DELETE_BUTTON, false).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CreateSliderDialog.this.slider = null;
                }
            });
        }
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public AdjustableDoubleRange getSlider() {
        return this.slider;
    }
}

