/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.gui;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProviderForDiscreteArray;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProviderForDoubleFunction;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DynamicRange;
import org.eclipse.stardust.ide.simulation.ui.curves.data.PositiveRange;
import org.eclipse.stardust.ide.simulation.ui.curves.data.Range;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Drawing;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Layer;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.DragListener;
import org.eclipse.stardust.ide.simulation.ui.curves.functions.NormalDistribution;
import org.eclipse.stardust.ide.simulation.ui.curves.functions.PoissonDistribution;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.AxisLabeling;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.ChartCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.CurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.DefaultDynamicAxisLabeling;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.DiscreteCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.DottedCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.GuaranteeVisibility;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.PCentLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.StrokedCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.TimeXAxisLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.WrapperLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.XAxisLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.timeline.TimelineCurveEditor;
import org.eclipse.stardust.ide.simulation.ui.curves.timeline.TimelineEditor;
import org.eclipse.stardust.ide.simulation.ui.distributions.CustomDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.DistributionFactory;
import org.eclipse.stardust.ide.simulation.ui.distributions.DurationConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.IDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.NormalDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.PoissonDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.UniformDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDoubleRange;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AbstractSimulationPanel;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AdapterForDoubleWidget;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AdapterForSliderButton;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AdapterForTimeUnitWidget;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.StackLayoutComposite;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.TimelineWidgetTooltips;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.CurveUtils;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValue;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DurationPanel
extends AbstractSimulationPanel {
    Combo distributionCombo;
    AdapterForDoubleWidget normalMju;
    AdapterForSliderButton normalMjuSlider;
    AdapterForDoubleWidget normalSigmaSqr;
    AdapterForSliderButton normalSigmaSqrSlider;
    AdapterForTimeUnitWidget normalUnit;
    Canvas normalCanvas;
    WrapperLayer normalCurve;
    Composite normalPanel;
    AdapterForDoubleWidget poissonLambda;
    AdapterForSliderButton poissonLambdaSlider;
    AdapterForTimeUnitWidget poissonUnit;
    Canvas poissonCanvas;
    WrapperLayer poissonCurve;
    Composite poissonPanel;
    AdapterForDoubleWidget uniformStart;
    AdapterForSliderButton uniformStartSlider;
    AdapterForDoubleWidget uniformEnd;
    AdapterForSliderButton uniformEndSlider;
    AdapterForTimeUnitWidget uniformUnit;
    Canvas uniformCanvas;
    WrapperLayer uniformCurve;
    WrapperLayer uniformScala;
    Composite uniformPanel;
    AdapterForDoubleWidget customEnd;
    AdapterForSliderButton customEndSlider;
    AdapterForTimeUnitWidget customUnit;
    TimelineEditor customEditor;
    Composite customPanel;
    NumberFormat doubleFormat = new DecimalFormat("####.###", new DecimalFormatSymbols(Locale.ENGLISH));
    DurationConfiguration configuration;

    public DurationPanel(Composite parent, int style) {
        super(parent, style);
        Composite distributionPanel = new Composite(this.configPanel, 0);
        Label distributionLabel = FormBuilder.createLabel((Composite)distributionPanel, (String)Simulation_Modeling_Messages.DISTRIBUTION_TYPE);
        this.distributionCombo = new Combo(distributionPanel, 12);
        this.distributionCombo.setItems(new String[]{Simulation_Modeling_Messages.EMPTY_DISTRIBUTION, Simulation_Modeling_Messages.NORMAL_DISTRIBUTION, Simulation_Modeling_Messages.POISSON_DISTRIBUTION, Simulation_Modeling_Messages.UNIFORM_DISTRIBUTION, Simulation_Modeling_Messages.CUSTOM_DISTRIBUTION});
        this.distributionCombo.select(0);
        this.distributionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DurationPanel.this.selectDistribution(DurationPanel.this.distributionCombo.getSelectionIndex());
            }
        });
        this.detailsStackBox = new StackLayoutComposite(this.configPanel, 0);
        this.emptyDetailsPanel = this.buildEmptyPanel(this.detailsStackBox);
        this.normalPanel = this.buildNormalPanel(this.detailsStackBox);
        this.poissonPanel = this.buildPoissonPanel(this.detailsStackBox);
        this.uniformPanel = this.buildUniformPanel(this.detailsStackBox);
        this.customPanel = this.buildCustomPanel(this.detailsStackBox);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)distributionPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.detailsStackBox);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(8, 8).numColumns(2).applyTo(distributionPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)distributionLabel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.distributionCombo);
        this.detailsStackBox.setTopControl(this.emptyDetailsPanel);
        this.initDrawings();
        this.initDefaultValues();
    }

    protected Composite buildEmptyPanel(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        this.createFill(mainPanel);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(0, 0).numColumns(1).applyTo(mainPanel);
        return mainPanel;
    }

    protected Composite buildNormalPanel(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        Label hr0 = FormBuilder.createHorizontalSeparator((Composite)mainPanel, (int)1);
        Label headline = FormBuilder.createLabel((Composite)mainPanel, (String)(String.valueOf(Simulation_Modeling_Messages.NORMAL_DISTRIBUTION) + Simulation_Modeling_Messages.DISTRIBUTION_SETTINGS));
        headline.setFont(this.bold(headline.getFont(), headline.getDisplay()));
        Composite settingsPanel = new Composite(mainPanel, 0);
        this.normalMju = new AdapterForDoubleWidget(settingsPanel, 133120, Simulation_Modeling_Messages.MJU);
        this.normalMju.configure(1, 0.0, 100.0, 1.0);
        this.normalMju.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DurationPanel.this.selectNormalDistribution();
            }
        });
        this.normalMjuSlider = new AdapterForSliderButton(settingsPanel, new AdjustableDoubleRange(Simulation_Modeling_Messages.MJU, 0.0, 10.0, 1.0));
        this.normalMjuSlider.addDependentComponent(this.normalMju.getControl());
        Label normalUnitLabel = FormBuilder.createLabel((Composite)settingsPanel, (String)Simulation_Modeling_Messages.UNIT);
        this.normalUnit = new AdapterForTimeUnitWidget(settingsPanel, 0);
        this.createFill(settingsPanel);
        this.normalSigmaSqr = new AdapterForDoubleWidget(settingsPanel, 133120, Simulation_Modeling_Messages.SIGMA);
        this.normalSigmaSqr.configure(1, 0.1, 100.0, 1.0);
        this.normalSigmaSqr.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DurationPanel.this.selectNormalDistribution();
            }
        });
        this.normalSigmaSqrSlider = new AdapterForSliderButton(settingsPanel, new AdjustableDoubleRange(Simulation_Modeling_Messages.SIGMA, 1.0, 5.0, 1.0));
        this.normalSigmaSqrSlider.addDependentComponent(this.normalSigmaSqr.getControl());
        this.normalCanvas = new Canvas(mainPanel, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)mainPanel);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 5).applyTo(mainPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)hr0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(-1, 20).applyTo((Control)headline);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)settingsPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.normalCanvas);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(6).spacing(5, 5).applyTo(settingsPanel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.normalMju.getLabel());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(this.normalMju.getControl());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).applyTo((Control)this.normalMjuSlider.getControl());
        GridDataFactory.fillDefaults().align(131072, 0x1000000).grab(true, false).applyTo((Control)normalUnitLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo(this.normalUnit.getControl());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.normalSigmaSqr.getLabel());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(this.normalSigmaSqr.getControl());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).applyTo((Control)this.normalSigmaSqrSlider.getControl());
        return mainPanel;
    }

    protected Composite buildPoissonPanel(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        Label hr0 = FormBuilder.createHorizontalSeparator((Composite)mainPanel, (int)1);
        Label headline = FormBuilder.createLabel((Composite)mainPanel, (String)(String.valueOf(Simulation_Modeling_Messages.POISSON_DISTRIBUTION) + Simulation_Modeling_Messages.DISTRIBUTION_SETTINGS));
        headline.setFont(this.bold(headline.getFont(), headline.getDisplay()));
        Composite settingsPanel = new Composite(mainPanel, 0);
        this.poissonLambda = new AdapterForDoubleWidget(settingsPanel, 133120, Simulation_Modeling_Messages.LAMBDA);
        this.poissonLambda.configure(1, 0.1, 100.0, 1.0);
        this.poissonLambda.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DurationPanel.this.selectPoissonDistribution();
            }
        });
        this.poissonLambdaSlider = new AdapterForSliderButton(settingsPanel, new AdjustableDoubleRange(Simulation_Modeling_Messages.LAMBDA, 1.0, 10.0, 1.0));
        this.poissonLambdaSlider.addDependentComponent(this.poissonLambda.getControl());
        Label poissonUnitLabel = FormBuilder.createLabel((Composite)settingsPanel, (String)Simulation_Modeling_Messages.UNIT);
        poissonUnitLabel.setAlignment(131072);
        this.poissonUnit = new AdapterForTimeUnitWidget(settingsPanel, 0);
        this.createFill(settingsPanel);
        this.poissonCanvas = new Canvas(mainPanel, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)mainPanel);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).spacing(0, 5).applyTo(mainPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)hr0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(-1, 20).applyTo((Control)headline);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)settingsPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.poissonCanvas);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(6).spacing(5, 5).applyTo(settingsPanel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.poissonLambda.getLabel());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(this.poissonLambda.getControl());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).applyTo((Control)this.poissonLambdaSlider.getControl());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)poissonUnitLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo(this.poissonUnit.getControl());
        return mainPanel;
    }

    protected Composite buildUniformPanel(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        Label hr0 = FormBuilder.createHorizontalSeparator((Composite)mainPanel, (int)1);
        Label headline = FormBuilder.createLabel((Composite)mainPanel, (String)(String.valueOf(Simulation_Modeling_Messages.UNIFORM_DISTRIBUTION) + Simulation_Modeling_Messages.DISTRIBUTION_SETTINGS));
        headline.setFont(this.bold(headline.getFont(), headline.getDisplay()));
        Composite settingsPanel = new Composite(mainPanel, 0);
        this.uniformStart = new AdapterForDoubleWidget(settingsPanel, 133120, Simulation_Modeling_Messages.START_POINT);
        this.uniformStart.configure(1, 0.0, 500.0, 1.0);
        this.uniformStart.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DurationPanel.this.uniformEnd.reconfigure(DurationPanel.this.uniformStart.getValue(), 500.0);
                DurationPanel.this.selectUniformDistribution();
            }
        });
        this.uniformStartSlider = new AdapterForSliderButton(settingsPanel, new AdjustableDoubleRange(Simulation_Modeling_Messages.START_POINT, 0.0, 10.0, 1.0));
        this.uniformStartSlider.addDependentComponent(this.uniformStart.getControl());
        Label uniformUnitLabel = FormBuilder.createLabel((Composite)settingsPanel, (String)Simulation_Modeling_Messages.UNIT);
        uniformUnitLabel.setAlignment(131072);
        this.uniformUnit = new AdapterForTimeUnitWidget(settingsPanel, 0);
        this.uniformUnit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DurationPanel.this.selectUniformDistribution();
            }
        });
        this.createFill(settingsPanel);
        this.uniformEnd = new AdapterForDoubleWidget(settingsPanel, 133120, Simulation_Modeling_Messages.END_POINT);
        this.uniformEnd.configure(1, 0.0, 1500.0, 1.0);
        this.uniformEnd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DurationPanel.this.uniformStart.reconfigure(0.1, DurationPanel.this.uniformEnd.getValue());
                DurationPanel.this.selectUniformDistribution();
            }
        });
        this.uniformEndSlider = new AdapterForSliderButton(settingsPanel, new AdjustableDoubleRange(Simulation_Modeling_Messages.END_POINT, 0.0, 10.0, 1.0));
        this.uniformEndSlider.addDependentComponent(this.uniformEnd.getControl());
        this.uniformCanvas = new Canvas(mainPanel, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)mainPanel);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).spacing(0, 5).applyTo(mainPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)hr0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(-1, 20).applyTo((Control)headline);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)settingsPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.uniformCanvas);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(6).spacing(5, 5).applyTo(settingsPanel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.uniformStart.getLabel());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(this.uniformStart.getControl());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).applyTo((Control)this.uniformStartSlider.getControl());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)uniformUnitLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo(this.uniformUnit.getControl());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.uniformEnd.getLabel());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(this.uniformEnd.getControl());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).applyTo((Control)this.uniformEndSlider.getControl());
        return mainPanel;
    }

    protected Composite buildCustomPanel(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        Label hr0 = FormBuilder.createHorizontalSeparator((Composite)mainPanel, (int)1);
        Label headline = FormBuilder.createLabel((Composite)mainPanel, (String)(String.valueOf(Simulation_Modeling_Messages.CUSTOM_DISTRIBUTION) + Simulation_Modeling_Messages.DISTRIBUTION_SETTINGS));
        headline.setFont(this.bold(headline.getFont(), headline.getDisplay()));
        Composite settingsPanel = new Composite(mainPanel, 0);
        this.customEnd = new AdapterForDoubleWidget(settingsPanel, 133120, Simulation_Modeling_Messages.END_POINT);
        this.customEnd.configure(1, 0.1, 1500.0, 1.0);
        this.customEnd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DurationPanel.this.selectCustomDistribution();
            }
        });
        this.customEndSlider = new AdapterForSliderButton(settingsPanel, new AdjustableDoubleRange(Simulation_Modeling_Messages.END_POINT, 1.0, 10.0, 1.0));
        this.customEndSlider.addDependentComponent(this.customEnd.getControl());
        Label customUnitLabel = FormBuilder.createLabel((Composite)settingsPanel, (String)Simulation_Modeling_Messages.UNIT);
        customUnitLabel.setAlignment(131072);
        this.customUnit = new AdapterForTimeUnitWidget(settingsPanel, 0);
        this.customUnit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DurationPanel.this.selectCustomDistribution();
            }
        });
        this.createFill(settingsPanel);
        this.customEditor = new TimelineCurveEditor(mainPanel, 0x20000800, Configuration.createDefault());
        this.customEditor.setType(4);
        this.customEditor.setTimeline(null, null, "", this.customUnit.getCalendarType(), 1.0, new Coord2D(0.0, 0.0));
        this.customEditor.addDragListener((DragListener)new TimelineWidgetTooltips(this.customEditor));
        this.customEditor.setBackground(ColorConstants.listBackground);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)mainPanel);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).spacing(0, 5).applyTo(mainPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)hr0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(-1, 20).applyTo((Control)headline);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)settingsPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.customEditor);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(6).spacing(5, 5).applyTo(settingsPanel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.customEnd.getLabel());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(this.customEnd.getControl());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).applyTo((Control)this.customEndSlider.getControl());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)customUnitLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo(this.customUnit.getControl());
        return mainPanel;
    }

    private void initDrawings() {
        Drawing drawing = new Drawing(Configuration.createDefault());
        this.normalCurve = new WrapperLayer();
        drawing.addLayer((Layer)this.normalCurve);
        drawing.addLayer((Layer)new XAxisLayer("t", null, 10.0, 100.0, 10.0, "####", true));
        drawing.addLayer((Layer)new PCentLayer());
        drawing.addLayer((Layer)new GuaranteeVisibility(new Coord2D(0.0, 0.0)));
        drawing.addLayer((Layer)new GuaranteeVisibility(new Coord2D(0.0, 0.4)));
        this.normalCanvas.addPaintListener((PaintListener)drawing);
        this.normalCanvas.setBackground(ColorConstants.listBackground);
        drawing = new Drawing(Configuration.createDefault());
        this.poissonCurve = new WrapperLayer();
        drawing.addLayer((Layer)this.poissonCurve);
        drawing.addLayer((Layer)new XAxisLayer("t", null, (AxisLabeling)new DefaultDynamicAxisLabeling(), true));
        drawing.addLayer((Layer)new PCentLayer());
        drawing.addLayer((Layer)new GuaranteeVisibility(new Coord2D(0.0, 0.0)));
        this.poissonCanvas.addPaintListener((PaintListener)drawing);
        this.poissonCanvas.setBackground(ColorConstants.listBackground);
        drawing = new Drawing(Configuration.createDefault());
        this.uniformCurve = new WrapperLayer();
        drawing.addLayer((Layer)this.uniformCurve);
        this.uniformScala = new WrapperLayer();
        drawing.addLayer((Layer)this.uniformScala);
        drawing.addLayer((Layer)new PCentLayer());
        drawing.addLayer((Layer)new GuaranteeVisibility(new Coord2D(0.0, 0.0)));
        drawing.addLayer((Layer)new GuaranteeVisibility(new Coord2D(0.0, 1.05)));
        this.uniformCanvas.addPaintListener((PaintListener)drawing);
        this.uniformCanvas.setBackground(ColorConstants.listBackground);
    }

    private void initDefaultValues() {
        this.normalMju.setValue(10.0);
        this.normalSigmaSqr.setValue(1.0);
        this.normalUnit.setSelection(1);
        this.poissonLambda.setValue(1.0);
        this.poissonUnit.setSelection(3);
        this.uniformStart.setValue(8.0);
        this.uniformEnd.setValue(16.0);
        this.uniformUnit.setSelection(3);
        this.customEnd.setValue(60.0);
        this.customUnit.setSelection(1);
    }

    @Override
    public void dispose() {
        if (this.normalMjuSlider != null) {
            this.normalMjuSlider.dispose();
        }
        if (this.normalSigmaSqrSlider != null) {
            this.normalSigmaSqrSlider.dispose();
        }
        if (this.poissonLambdaSlider != null) {
            this.poissonLambdaSlider.dispose();
        }
        if (this.uniformStartSlider != null) {
            this.uniformStartSlider.dispose();
        }
        if (this.uniformEndSlider != null) {
            this.uniformEndSlider.dispose();
        }
        if (this.customEndSlider != null) {
            this.customEndSlider.dispose();
        }
        super.dispose();
    }

    @Override
    protected void onAuditCheckBoxChange() {
        this.setChildrenEnabled(!this.auditCheckBox.getSelection());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setConfiguration(DurationConfiguration configuration) {
        this.configuration = configuration;
        if (configuration != null) {
            IDistributionConfiguration distribution = configuration.getDistribution();
            if (distribution != null && !distribution.isNull()) {
                String distributionTypeId = distribution.getDistributionTypeId();
                this.distributionCombo.setText(DistributionFactory.getDistributionNameById(distributionTypeId));
                if (distributionTypeId.equals("1001")) {
                    NormalDistributionConfiguration theDistribution = (NormalDistributionConfiguration)distribution;
                    this.getNormalUnit().setUnitId(configuration.getUnitId());
                    this.getNormalMju().setValue(theDistribution.getMju().getValue());
                    this.getNormalMjuSlider().setSliderRange(theDistribution.getMju().getRange());
                    this.getNormalSigmaSqr().setValue(theDistribution.getSigmaSqr().getValue());
                    this.getNormalSigmaSqrSlider().setSliderRange(theDistribution.getSigmaSqr().getRange());
                    this.selectNormalDistribution();
                } else if (distributionTypeId.equals("1002")) {
                    PoissonDistributionConfiguration theDistribution = (PoissonDistributionConfiguration)distribution;
                    this.getPoissonUnit().setUnitId(configuration.getUnitId());
                    this.getPoissonLambda().setValue(theDistribution.getLambda().getValue());
                    this.getPoissonLambdaSlider().setSliderRange(theDistribution.getLambda().getRange());
                    this.selectPoissonDistribution();
                } else if (distributionTypeId.equals("1003")) {
                    UniformDistributionConfiguration theDistribution = (UniformDistributionConfiguration)distribution;
                    this.getUniformUnit().setUnitId(configuration.getUnitId());
                    this.getUniformStart().setValue(theDistribution.getStartPoint().getValue());
                    this.getUniformStartSlider().setSliderRange(theDistribution.getStartPoint().getRange());
                    this.getUniformEnd().setValue(theDistribution.getEndPoint().getValue());
                    this.getUniformEndSlider().setSliderRange(theDistribution.getEndPoint().getRange());
                    this.selectUniformDistribution();
                } else {
                    if (!distributionTypeId.equals("1004")) throw new RuntimeException("Unsupported distribution type id <" + distributionTypeId + ">");
                    CustomDistributionConfiguration theDistribution = (CustomDistributionConfiguration)distribution;
                    this.getCustomUnit().setUnitId(configuration.getUnitId());
                    this.getCustomEnd().setValue(theDistribution.getEndPoint().getValue());
                    this.getCustomEndSlider().setSliderRange(theDistribution.getEndPoint().getRange());
                    this.setCustomPoints(theDistribution.getPoints());
                    this.selectCustomDistribution();
                }
            } else {
                this.selectDistribution(-1);
            }
            this.setFromAuditTrailMode(configuration.isFromAuditTrail());
            return;
        } else {
            this.selectDistribution(-1);
        }
    }

    public DurationConfiguration getConfiguration() {
        if (this.configuration != null) {
            String distributionId = DistributionFactory.getDistributionIdByName(this.getSelectedDistribution());
            if (distributionId != null) {
                if (distributionId.equals("1001")) {
                    this.configuration.setFromAuditTrail(this.isFromAuditTrailMode());
                    this.configuration.setUnitId(this.getNormalUnit().getUnitId());
                    NormalDistributionConfiguration distribution = new NormalDistributionConfiguration(this.configuration.getInterval());
                    distribution.getMju().setValue(this.getNormalMju().getValue());
                    distribution.getMju().setRange(this.getNormalMjuSlider().getSliderRange());
                    distribution.getSigmaSqr().setValue(this.getNormalSigmaSqr().getValue());
                    distribution.getSigmaSqr().setRange(this.getNormalSigmaSqrSlider().getSliderRange());
                    this.configuration.setDistribution(distribution);
                } else if (distributionId.equals("1002")) {
                    this.configuration.setFromAuditTrail(this.isFromAuditTrailMode());
                    this.configuration.setUnitId(this.getPoissonUnit().getUnitId());
                    PoissonDistributionConfiguration distribution = new PoissonDistributionConfiguration(this.configuration.getInterval());
                    distribution.getLambda().setValue(this.getPoissonLambda().getValue());
                    distribution.getLambda().setRange(this.getPoissonLambdaSlider().getSliderRange());
                    this.configuration.setDistribution(distribution);
                } else if (distributionId.equals("1003")) {
                    this.configuration.setFromAuditTrail(this.isFromAuditTrailMode());
                    this.configuration.setUnitId(this.getUniformUnit().getUnitId());
                    UniformDistributionConfiguration distribution = new UniformDistributionConfiguration(this.configuration.getInterval());
                    distribution.getStartPoint().setValue(this.getUniformStart().getValue());
                    distribution.getStartPoint().setRange(this.getUniformStartSlider().getSliderRange());
                    distribution.getEndPoint().setValue(this.getUniformEnd().getValue());
                    distribution.getEndPoint().setRange(this.getUniformEndSlider().getSliderRange());
                    this.configuration.setDistribution(distribution);
                } else if (distributionId.equals("1004")) {
                    this.configuration.setFromAuditTrail(this.isFromAuditTrailMode());
                    this.configuration.setUnitId(this.getCustomUnit().getUnitId());
                    CustomDistributionConfiguration distribution = new CustomDistributionConfiguration(this.configuration.getInterval());
                    distribution.getEndPoint().setValue(this.getCustomEnd().getValue());
                    distribution.getEndPoint().setRange(this.getCustomEndSlider().getSliderRange());
                    distribution.setPoints(this.getCustomPoints());
                    this.configuration.setDistribution(distribution);
                } else {
                    this.configuration.setFromAuditTrail(this.isFromAuditTrailMode());
                    this.configuration.setDistribution(null);
                }
            } else {
                this.configuration.setFromAuditTrail(this.isFromAuditTrailMode());
                this.configuration.setDistribution(null);
            }
        }
        return this.configuration;
    }

    public void selectDistribution(int n) {
        switch (n) {
            case 1: {
                this.selectNormalDistribution();
                break;
            }
            case 2: {
                this.selectPoissonDistribution();
                break;
            }
            case 3: {
                this.selectUniformDistribution();
                break;
            }
            case 4: {
                this.selectCustomDistribution();
                break;
            }
            default: {
                this.detailsStackBox.setTopControl(this.emptyDetailsPanel);
            }
        }
        this.layout();
    }

    public void selectNormalDistribution() {
        this.detailsStackBox.setTopControl(this.normalPanel);
        this.setFromAuditTrailEnabled(true);
        double mju = this.normalMju.getValue();
        double sigmaSqr = this.normalSigmaSqr.getValue();
        NormalDistribution f = new NormalDistribution(mju, sigmaSqr);
        PositiveRange range = new PositiveRange((Range)new DynamicRange((DataProviderForDoubleFunction.Function)f, 0.01, 0.001 * f.f(mju), mju));
        this.normalCurve.setDelegate((Layer)new StrokedCurveLayer((DataProvider)new DataProviderForDoubleFunction((Range)range, (DataProviderForDoubleFunction.Function)f), 0));
        this.normalCanvas.redraw();
        this.redraw();
    }

    public void selectPoissonDistribution() {
        this.detailsStackBox.setTopControl(this.poissonPanel);
        this.setFromAuditTrailEnabled(true);
        double lambda = this.poissonLambda.getValue();
        PoissonDistribution f = new PoissonDistribution(lambda);
        DynamicRange range = new DynamicRange((DataProviderForDoubleFunction.Function)f, 1.0, 0.001 * f.f(lambda), lambda);
        this.poissonCurve.setDelegate((Layer)new ChartCurveLayer((DataProvider)new DataProviderForDoubleFunction((Range)range, (DataProviderForDoubleFunction.Function)f), 0, 30));
        this.poissonCanvas.redraw();
        this.redraw();
    }

    public void selectUniformDistribution() {
        this.detailsStackBox.setTopControl(this.uniformPanel);
        this.setFromAuditTrailEnabled(true);
        double start = this.uniformStart.getValue();
        double end = this.uniformEnd.getValue();
        double endend = (long)((int)(end * 1.2 / (double)this.uniformUnit.getPreferredMaxValue() + 1.0)) * this.uniformUnit.getPreferredMaxValue();
        Coord2D[] data = new Coord2D[]{new Coord2D(0.0, 0.0), new Coord2D(start, 1.0), new Coord2D(end, 0.0), new Coord2D(endend, 0.0)};
        this.uniformScala.setDelegate((Layer)new TimeXAxisLayer("t", this.uniformUnit.getCalendarType()));
        this.uniformCurve.setDelegate((Layer)new DottedCurveLayer((CurveLayer)new DiscreteCurveLayer((DataProvider)new DataProviderForDiscreteArray(data))));
        this.uniformCanvas.redraw();
        this.redraw();
    }

    public void selectCustomDistribution() {
        this.detailsStackBox.setTopControl(this.customPanel);
        this.setFromAuditTrailEnabled(true);
        double end = this.customEnd.getValue();
        Coord2D[] data = this.customEditor.getCurveData();
        data = data.length == 0 ? new Coord2D[]{new Coord2D(end, 1.0)} : CurveUtils.reduceXAxis(0.0, end, data);
        if (this.configuration != null && this.configuration.getInterval() != null) {
            this.customEditor.setTimeline(this.configuration.getInterval().getStartDate(), this.configuration.getInterval().getEndDate(), "", this.customUnit.getCalendarType(), 1.0, new Coord2D(0.0, 0.0));
        } else {
            this.customEditor.setTimeline(null, null, "", this.customUnit.getCalendarType(), 1.0, new Coord2D(0.0, 0.0));
        }
        this.customEditor.setCurveData(data);
        this.customEditor.redraw();
        this.redraw();
    }

    public String getSelectedDistribution() {
        return this.distributionCombo.getItem(this.distributionCombo.getSelectionIndex());
    }

    public void setSelectedDistribution(String text) {
        this.distributionCombo.setText(text);
        this.selectDistribution(this.distributionCombo.getSelectionIndex());
    }

    public AdapterForDoubleWidget getNormalMju() {
        return this.normalMju;
    }

    public AdapterForSliderButton getNormalMjuSlider() {
        return this.normalMjuSlider;
    }

    public AdapterForDoubleWidget getNormalSigmaSqr() {
        return this.normalSigmaSqr;
    }

    public AdapterForSliderButton getNormalSigmaSqrSlider() {
        return this.normalSigmaSqrSlider;
    }

    public AdapterForTimeUnitWidget getNormalUnit() {
        return this.normalUnit;
    }

    public AdapterForDoubleWidget getPoissonLambda() {
        return this.poissonLambda;
    }

    public AdapterForSliderButton getPoissonLambdaSlider() {
        return this.poissonLambdaSlider;
    }

    public AdapterForTimeUnitWidget getPoissonUnit() {
        return this.poissonUnit;
    }

    public AdapterForDoubleWidget getUniformStart() {
        return this.uniformStart;
    }

    public AdapterForSliderButton getUniformStartSlider() {
        return this.uniformStartSlider;
    }

    public AdapterForDoubleWidget getUniformEnd() {
        return this.uniformEnd;
    }

    public AdapterForSliderButton getUniformEndSlider() {
        return this.uniformEndSlider;
    }

    public AdapterForTimeUnitWidget getUniformUnit() {
        return this.uniformUnit;
    }

    public AdapterForDoubleWidget getCustomEnd() {
        return this.customEnd;
    }

    public AdapterForSliderButton getCustomEndSlider() {
        return this.customEndSlider;
    }

    public AdapterForTimeUnitWidget getCustomUnit() {
        return this.customUnit;
    }

    public TimestampValue[] getCustomPoints() {
        return CurveUtils.fromCurve(1L, this.customEditor.getCurveData());
    }

    public void setCustomPoints(List points) {
        this.customEditor.setCurveData(CurveUtils.toCurve(1.0, points));
    }

    public void layout() {
        this.detailsStackBox.layout();
    }

    private void setChildrenEnabled(boolean enabled) {
        this.getNormalMju().getControl().setEnabled(enabled && this.getNormalMjuSlider().getSliderRange() == null);
        this.getNormalMjuSlider().getControl().setEnabled(enabled);
        this.getNormalSigmaSqr().getControl().setEnabled(enabled && this.getNormalSigmaSqrSlider().getSliderRange() == null);
        this.getNormalSigmaSqrSlider().getControl().setEnabled(enabled);
        this.getNormalUnit().getControl().setEnabled(enabled);
        this.normalCanvas.setBackground(ColorConstants.button);
        this.getPoissonLambda().getControl().setEnabled(enabled && this.getPoissonLambdaSlider().getSliderRange() == null);
        this.getPoissonLambdaSlider().getControl().setEnabled(enabled);
        this.getPoissonUnit().getControl().setEnabled(enabled);
        this.poissonCanvas.setBackground(ColorConstants.button);
        this.getUniformStart().getControl().setEnabled(enabled && this.getUniformStartSlider().getSliderRange() == null);
        this.getUniformStartSlider().getControl().setEnabled(enabled);
        this.getUniformEnd().getControl().setEnabled(enabled && this.getUniformEndSlider().getSliderRange() == null);
        this.getUniformEndSlider().getControl().setEnabled(enabled);
        this.getUniformUnit().getControl().setEnabled(enabled);
        this.uniformCanvas.setBackground(ColorConstants.button);
        this.getCustomEnd().getControl().setEnabled(enabled && this.getCustomEndSlider().getSliderRange() == null);
        this.getCustomEndSlider().getControl().setEnabled(enabled);
        this.getCustomUnit().getControl().setEnabled(enabled);
        this.customEditor.setEnabled(enabled);
        this.customEditor.setBackground(enabled ? ColorConstants.listBackground : ColorConstants.button);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("DistributionPanel Test");
        shell.setLayout((Layout)new FillLayout());
        new DurationPanel((Composite)shell, 0);
        shell.setSize(600, 600);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

