/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.gui;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProviderForDiscreteArray;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProviderForDoubleFunction;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DynamicRange;
import org.eclipse.stardust.ide.simulation.ui.curves.data.PositiveRange;
import org.eclipse.stardust.ide.simulation.ui.curves.data.Range;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Drawing;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Layer;
import org.eclipse.stardust.ide.simulation.ui.curves.functions.NormalDistribution;
import org.eclipse.stardust.ide.simulation.ui.curves.functions.PoissonDistribution;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.AxisLabeling;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.ChartCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.CurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.DefaultDynamicAxisLabeling;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.DiscreteCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.DottedCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.GuaranteeVisibility;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.PCentLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.StrokedCurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.WrapperLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.XAxisLayer;
import org.eclipse.stardust.ide.simulation.ui.distributions.DistributionFactory;
import org.eclipse.stardust.ide.simulation.ui.distributions.IDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.NormalDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.PoissonDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.UniformDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDoubleRange;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AdapterForDoubleWidget;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AdapterForIntegerWidget;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AdapterForSliderButton;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.StackLayoutComposite;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class EmbeddedDistributionPanel
extends Composite {
    Combo distributionCombo;
    StackLayoutComposite detailsStackBox;
    Composite emptyDetailsPanel;
    AdapterForDoubleWidget normalMju;
    AdapterForSliderButton normalMjuSlider;
    AdapterForDoubleWidget normalSigmaSqr;
    AdapterForSliderButton normalSigmaSqrSlider;
    Canvas normalCanvas;
    WrapperLayer normalCurve;
    Composite normalPanel;
    AdapterForIntegerWidget poissonLambda;
    AdapterForSliderButton poissonLambdaSlider;
    Canvas poissonCanvas;
    WrapperLayer poissonCurve;
    Composite poissonPanel;
    AdapterForIntegerWidget uniformStart;
    AdapterForSliderButton uniformStartSlider;
    AdapterForIntegerWidget uniformEnd;
    AdapterForSliderButton uniformEndSlider;
    Canvas uniformCanvas;
    WrapperLayer uniformCurve;
    Composite uniformPanel;
    DistributionFactory factory;
    IDistributionConfiguration configuration;

    public EmbeddedDistributionPanel(Composite parent, int style) {
        super(parent, style);
        Label distributionLabel = FormBuilder.createLabel((Composite)this, (String)Simulation_Modeling_Messages.DISTRIBUTION_TYPE);
        this.distributionCombo = new Combo((Composite)this, 12);
        this.distributionCombo.setItems(new String[]{Simulation_Modeling_Messages.UNLIMITED_DISTRIBUTION, Simulation_Modeling_Messages.NORMAL_DISTRIBUTION, Simulation_Modeling_Messages.POISSON_DISTRIBUTION, Simulation_Modeling_Messages.UNIFORM_DISTRIBUTION});
        this.distributionCombo.select(0);
        this.distributionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EmbeddedDistributionPanel.this.selectDistribution(EmbeddedDistributionPanel.this.distributionCombo.getSelectionIndex());
            }
        });
        Label hr0 = FormBuilder.createHorizontalSeparator((Composite)this, (int)1);
        this.detailsStackBox = new StackLayoutComposite(this, 0);
        this.emptyDetailsPanel = this.buildEmptyPanel(this.detailsStackBox);
        this.normalPanel = this.buildNormalPanel(this.detailsStackBox);
        this.poissonPanel = this.buildPoissonPanel(this.detailsStackBox);
        this.uniformPanel = this.buildUniformPanel(this.detailsStackBox);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 5).numColumns(2).applyTo((Composite)this);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)distributionLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.distributionCombo);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 1).applyTo((Control)hr0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)this.detailsStackBox);
        this.initDrawings();
        this.initDefaultValues();
    }

    private void initDrawings() {
        Drawing drawing = new Drawing(Configuration.createDefault());
        this.normalCurve = new WrapperLayer();
        drawing.addLayer((Layer)this.normalCurve);
        drawing.addLayer((Layer)new XAxisLayer("t", null, 10.0, 100.0, 10.0, "####", true));
        drawing.addLayer((Layer)new PCentLayer());
        drawing.addLayer((Layer)new GuaranteeVisibility(new Coord2D(0.0, 0.0)));
        drawing.addLayer((Layer)new GuaranteeVisibility(new Coord2D(0.0, 0.4)));
        this.normalCanvas.addPaintListener((PaintListener)drawing);
        this.normalCanvas.setBackground(ColorConstants.listBackground);
        drawing = new Drawing(Configuration.createDefault());
        this.poissonCurve = new WrapperLayer();
        drawing.addLayer((Layer)this.poissonCurve);
        drawing.addLayer((Layer)new XAxisLayer("t", null, (AxisLabeling)new DefaultDynamicAxisLabeling(), true));
        drawing.addLayer((Layer)new PCentLayer());
        drawing.addLayer((Layer)new GuaranteeVisibility(new Coord2D(0.0, 0.0)));
        this.poissonCanvas.addPaintListener((PaintListener)drawing);
        this.poissonCanvas.setBackground(ColorConstants.listBackground);
        drawing = new Drawing(Configuration.createDefault());
        this.uniformCurve = new WrapperLayer();
        drawing.addLayer((Layer)this.uniformCurve);
        drawing.addLayer((Layer)new PCentLayer());
        drawing.addLayer((Layer)new XAxisLayer("", "", 10.0, 100.0, 0.0, null, false));
        drawing.addLayer((Layer)new GuaranteeVisibility(new Coord2D(0.0, 0.0)));
        drawing.addLayer((Layer)new GuaranteeVisibility(new Coord2D(0.0, 1.05)));
        this.uniformCanvas.addPaintListener((PaintListener)drawing);
        this.uniformCanvas.setBackground(ColorConstants.listBackground);
    }

    private void initDefaultValues() {
        this.normalMju.setValue(10.0);
        this.normalSigmaSqr.setValue(1.0);
        this.poissonLambda.setValue(10.0);
        this.uniformStart.setValue(1.0);
        this.uniformEnd.setValue(10.0);
    }

    protected Composite buildEmptyPanel(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        new Label(mainPanel, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(0, 0).numColumns(1).applyTo(mainPanel);
        return mainPanel;
    }

    protected Composite buildNormalPanel(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        Composite settingsPanel = new Composite(mainPanel, 0);
        this.normalMju = new AdapterForDoubleWidget(settingsPanel, 133120, Simulation_Modeling_Messages.MJU);
        this.normalMju.configure(1, 1.0, 100.0, 1.0);
        this.normalMju.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EmbeddedDistributionPanel.this.selectNormalDistribution();
            }
        });
        this.normalMjuSlider = new AdapterForSliderButton(settingsPanel, new AdjustableDoubleRange(Simulation_Modeling_Messages.MJU, 0.0, 10.0, 1.0));
        this.normalMjuSlider.addDependentComponent(this.normalMju.getControl());
        this.normalSigmaSqr = new AdapterForDoubleWidget(settingsPanel, 133120, Simulation_Modeling_Messages.SIGMA);
        this.normalSigmaSqr.configure(1, 0.1, 100.0, 1.0);
        this.normalSigmaSqr.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EmbeddedDistributionPanel.this.selectNormalDistribution();
            }
        });
        this.normalSigmaSqrSlider = new AdapterForSliderButton(settingsPanel, new AdjustableDoubleRange(Simulation_Modeling_Messages.SIGMA, 1.0, 5.0, 1.0));
        this.normalSigmaSqrSlider.addDependentComponent(this.normalSigmaSqr.getControl());
        this.normalCanvas = new Canvas(mainPanel, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)mainPanel);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(15, 5).numColumns(2).applyTo(mainPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)settingsPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.normalCanvas);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(3).spacing(5, 5).applyTo(settingsPanel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(120, -1).applyTo((Control)this.normalMju.getLabel());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(150, -1).applyTo(this.normalMju.getControl());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).hint(22, 20).applyTo((Control)this.normalMjuSlider.getControl());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(120, -1).applyTo((Control)this.normalSigmaSqr.getLabel());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(150, -1).applyTo(this.normalSigmaSqr.getControl());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).hint(22, 20).applyTo((Control)this.normalSigmaSqrSlider.getControl());
        return mainPanel;
    }

    protected Composite buildPoissonPanel(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        Composite settingsPanel = new Composite(mainPanel, 0);
        this.poissonLambda = new AdapterForIntegerWidget(settingsPanel, 133120, Simulation_Modeling_Messages.LAMBDA);
        this.poissonLambda.configure(1.0, 100.0, 1.0);
        this.poissonLambda.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EmbeddedDistributionPanel.this.selectPoissonDistribution();
            }
        });
        this.poissonLambdaSlider = new AdapterForSliderButton(settingsPanel, new AdjustableDoubleRange(Simulation_Modeling_Messages.LAMBDA, 1.0, 10.0, 1.0));
        this.poissonLambdaSlider.addDependentComponent(this.poissonLambda.getControl());
        this.poissonCanvas = new Canvas(mainPanel, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)mainPanel);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(15, 5).numColumns(2).applyTo(mainPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)settingsPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.poissonCanvas);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(3).spacing(5, 5).applyTo(settingsPanel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(200, -1).applyTo((Control)this.poissonLambda.getLabel());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(150, -1).applyTo(this.poissonLambda.getControl());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).hint(22, 20).applyTo((Control)this.poissonLambdaSlider.getControl());
        return mainPanel;
    }

    protected Composite buildUniformPanel(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        Composite settingsPanel = new Composite(mainPanel, 0);
        this.uniformStart = new AdapterForIntegerWidget(settingsPanel, 133120, Simulation_Modeling_Messages.MAX_TRAVERSAL_COUNT_MIN);
        this.uniformStart.configure(1.0, 500.0, 1.0);
        this.uniformStart.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EmbeddedDistributionPanel.this.uniformEnd.reconfigure(EmbeddedDistributionPanel.this.uniformStart.getValue(), 500.0);
                EmbeddedDistributionPanel.this.selectUniformDistribution();
            }
        });
        this.uniformStartSlider = new AdapterForSliderButton(settingsPanel, new AdjustableDoubleRange(String.valueOf(Simulation_Modeling_Messages.MAX_TRAVERSAL_COUNT) + " " + Simulation_Modeling_Messages.MAX_TRAVERSAL_COUNT_MIN, 0.0, 10.0, 1.0));
        this.uniformStartSlider.addDependentComponent(this.uniformStart.getControl());
        this.uniformEnd = new AdapterForIntegerWidget(settingsPanel, 133120, Simulation_Modeling_Messages.MAX_TRAVERSAL_COUNT_MAX);
        this.uniformEnd.configure(1.0, 1500.0, 1.0);
        this.uniformEnd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EmbeddedDistributionPanel.this.uniformStart.reconfigure(0.1, EmbeddedDistributionPanel.this.uniformEnd.getValue());
                EmbeddedDistributionPanel.this.selectUniformDistribution();
            }
        });
        this.uniformEndSlider = new AdapterForSliderButton(settingsPanel, new AdjustableDoubleRange(String.valueOf(Simulation_Modeling_Messages.MAX_TRAVERSAL_COUNT) + " " + Simulation_Modeling_Messages.MAX_TRAVERSAL_COUNT_MAX, 0.0, 10.0, 1.0));
        this.uniformEndSlider.addDependentComponent(this.uniformEnd.getControl());
        this.uniformCanvas = new Canvas(mainPanel, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)mainPanel);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(15, 5).numColumns(2).applyTo(mainPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)settingsPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.uniformCanvas);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(3).spacing(5, 5).applyTo(settingsPanel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(120, -1).applyTo((Control)this.uniformStart.getLabel());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(150, -1).applyTo(this.uniformStart.getControl());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).hint(22, 20).applyTo((Control)this.uniformStartSlider.getControl());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(120, -1).applyTo((Control)this.uniformEnd.getLabel());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(150, -1).applyTo(this.uniformEnd.getControl());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).hint(22, 20).applyTo((Control)this.uniformEndSlider.getControl());
        return mainPanel;
    }

    public IDistributionConfiguration getConfiguration() {
        String distributionId = DistributionFactory.getDistributionIdByName(this.getSelectedDistribution());
        if (distributionId != null) {
            if (distributionId.equals("1001")) {
                NormalDistributionConfiguration distribution = (NormalDistributionConfiguration)this.factory.create(distributionId);
                distribution.getMju().setValue(this.getNormalMju().getValue());
                distribution.getMju().setRange(this.getNormalMjuSlider().getSliderRange());
                distribution.getSigmaSqr().setValue(this.getNormalSigmaSqr().getValue());
                distribution.getSigmaSqr().setRange(this.getNormalSigmaSqrSlider().getSliderRange());
                return distribution;
            }
            if (distributionId.equals("1002")) {
                PoissonDistributionConfiguration distribution = (PoissonDistributionConfiguration)this.factory.create(distributionId);
                distribution.getLambda().setValue(this.getPoissonLambda().getValue());
                distribution.getLambda().setRange(this.getPoissonLambdaSlider().getSliderRange());
                return distribution;
            }
            if (distributionId.equals("1003")) {
                UniformDistributionConfiguration distribution = (UniformDistributionConfiguration)this.factory.create(distributionId);
                distribution.getStartPoint().setValue(this.getUniformStart().getValue());
                distribution.getStartPoint().setRange(this.getUniformStartSlider().getSliderRange());
                distribution.getEndPoint().setValue(this.getUniformEnd().getValue());
                distribution.getEndPoint().setRange(this.getUniformEndSlider().getSliderRange());
                return distribution;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setConfiguration(IDistributionConfiguration configuration) {
        this.configuration = configuration;
        if (configuration != null) {
            String distributionTypeId = configuration.getDistributionTypeId();
            this.distributionCombo.setText(DistributionFactory.getDistributionNameById(distributionTypeId));
            if (distributionTypeId.equals("1001")) {
                NormalDistributionConfiguration theDistribution = (NormalDistributionConfiguration)configuration;
                this.getNormalMju().setValue(theDistribution.getMju().getValue());
                this.getNormalMjuSlider().setSliderRange(theDistribution.getMju().getRange());
                this.getNormalSigmaSqr().setValue(theDistribution.getSigmaSqr().getValue());
                this.getNormalSigmaSqrSlider().setSliderRange(theDistribution.getSigmaSqr().getRange());
                this.selectNormalDistribution();
            } else if (distributionTypeId.equals("1002")) {
                PoissonDistributionConfiguration theDistribution = (PoissonDistributionConfiguration)configuration;
                this.getPoissonLambda().setValue(theDistribution.getLambda().getValue());
                this.getPoissonLambdaSlider().setSliderRange(theDistribution.getLambda().getRange());
                this.selectPoissonDistribution();
            } else {
                if (!distributionTypeId.equals("1003")) throw new RuntimeException("Unsupported distribution type id <" + distributionTypeId + ">");
                UniformDistributionConfiguration theDistribution = (UniformDistributionConfiguration)configuration;
                this.getUniformStart().setValue(theDistribution.getStartPoint().getValue());
                this.getUniformStartSlider().setSliderRange(theDistribution.getStartPoint().getRange());
                this.getUniformEnd().setValue(theDistribution.getEndPoint().getValue());
                this.getUniformEndSlider().setSliderRange(theDistribution.getEndPoint().getRange());
                this.selectUniformDistribution();
            }
        } else {
            this.selectDistribution(-1);
        }
        this.detailsStackBox.layout();
    }

    public DistributionFactory getDistributionFactory() {
        return this.factory;
    }

    public void setDistributionFactory(DistributionFactory factory) {
        this.factory = factory;
    }

    public void selectDistribution(int n) {
        switch (n) {
            case 1: {
                this.selectNormalDistribution();
                break;
            }
            case 2: {
                this.selectPoissonDistribution();
                break;
            }
            case 3: {
                this.selectUniformDistribution();
                break;
            }
            default: {
                this.detailsStackBox.setTopControl(this.emptyDetailsPanel);
            }
        }
        this.layout();
    }

    public void selectNormalDistribution() {
        this.detailsStackBox.setTopControl(this.normalPanel);
        double mju = this.normalMju.getValue();
        double sigmaSqr = this.normalSigmaSqr.getValue();
        NormalDistribution f = new NormalDistribution(mju, sigmaSqr);
        PositiveRange range = new PositiveRange((Range)new DynamicRange((DataProviderForDoubleFunction.Function)f, 0.01, 0.001 * f.f(mju), mju));
        this.normalCurve.setDelegate((Layer)new StrokedCurveLayer((DataProvider)new DataProviderForDoubleFunction((Range)range, (DataProviderForDoubleFunction.Function)f), 0));
        this.normalCanvas.redraw();
        this.redraw();
    }

    public void selectPoissonDistribution() {
        this.detailsStackBox.setTopControl(this.poissonPanel);
        double lambda = this.poissonLambda.getValue();
        PoissonDistribution f = new PoissonDistribution(lambda);
        DynamicRange range = new DynamicRange((DataProviderForDoubleFunction.Function)f, 1.0, 0.001 * f.f(lambda), lambda);
        this.poissonCurve.setDelegate((Layer)new ChartCurveLayer((DataProvider)new DataProviderForDoubleFunction((Range)range, (DataProviderForDoubleFunction.Function)f), 0, 30));
        this.poissonCanvas.redraw();
        this.redraw();
    }

    public void selectUniformDistribution() {
        this.detailsStackBox.setTopControl(this.uniformPanel);
        double start = this.uniformStart.getValue();
        double end = this.uniformEnd.getValue();
        double endend = (int)(end * 1.2);
        Coord2D[] data = new Coord2D[]{new Coord2D(0.0, 0.0), new Coord2D(start, 1.0), new Coord2D(end, 0.0), new Coord2D(endend, 0.0)};
        this.uniformCurve.setDelegate((Layer)new DottedCurveLayer((CurveLayer)new DiscreteCurveLayer((DataProvider)new DataProviderForDiscreteArray(data))));
        this.uniformCanvas.redraw();
        this.redraw();
    }

    public void setEnabled(boolean enabled) {
        this.setChildrenEnabled(enabled);
    }

    private void setChildrenEnabled(boolean enabled) {
        this.getNormalMju().getControl().setEnabled(enabled && this.getNormalMjuSlider().getSliderRange() == null);
        this.getNormalMjuSlider().getControl().setEnabled(enabled);
        this.getNormalSigmaSqr().getControl().setEnabled(enabled && this.getNormalSigmaSqrSlider().getSliderRange() == null);
        this.getNormalSigmaSqrSlider().getControl().setEnabled(enabled);
        this.normalCanvas.setBackground(ColorConstants.button);
        this.getPoissonLambda().getControl().setEnabled(enabled && this.getPoissonLambdaSlider().getSliderRange() == null);
        this.getPoissonLambdaSlider().getControl().setEnabled(enabled);
        this.poissonCanvas.setBackground(ColorConstants.button);
        this.getUniformStart().getControl().setEnabled(enabled && this.getUniformStartSlider().getSliderRange() == null);
        this.getUniformStartSlider().getControl().setEnabled(enabled);
        this.getUniformEnd().getControl().setEnabled(enabled && this.getUniformEndSlider().getSliderRange() == null);
        this.getUniformEndSlider().getControl().setEnabled(enabled);
        this.uniformCanvas.setBackground(ColorConstants.button);
    }

    public String getSelectedDistribution() {
        return this.distributionCombo.getItem(this.distributionCombo.getSelectionIndex());
    }

    public void setSelectedDistribution(String text) {
        this.distributionCombo.setText(text);
        this.selectDistribution(this.distributionCombo.getSelectionIndex());
    }

    public AdapterForDoubleWidget getNormalMju() {
        return this.normalMju;
    }

    public AdapterForSliderButton getNormalMjuSlider() {
        return this.normalMjuSlider;
    }

    public AdapterForDoubleWidget getNormalSigmaSqr() {
        return this.normalSigmaSqr;
    }

    public AdapterForSliderButton getNormalSigmaSqrSlider() {
        return this.normalSigmaSqrSlider;
    }

    public AdapterForIntegerWidget getPoissonLambda() {
        return this.poissonLambda;
    }

    public AdapterForSliderButton getPoissonLambdaSlider() {
        return this.poissonLambdaSlider;
    }

    public AdapterForIntegerWidget getUniformStart() {
        return this.uniformStart;
    }

    public AdapterForSliderButton getUniformStartSlider() {
        return this.uniformStartSlider;
    }

    public AdapterForIntegerWidget getUniformEnd() {
        return this.uniformEnd;
    }

    public AdapterForSliderButton getUniformEndSlider() {
        return this.uniformEndSlider;
    }
}

