/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.gui;

import java.util.Date;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.DragListener;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.timeline.CalendarEditor;
import org.eclipse.stardust.ide.simulation.ui.curves.timeline.TimelineCurveEditor;
import org.eclipse.stardust.ide.simulation.ui.curves.timeline.TimelineEditor;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.TimelineWidgetTooltips;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;

public class TimelineWidget
extends Composite {
    private static final int EXP_WIDTH = 500;
    private static final int DRAWING_HEIGHT = 80;
    private static final int MAX_ZOOM = 20;
    Composite titleSlot;
    ScrolledComposite scrollPane;
    TimelineEditor editor;
    Label titleLabel;
    Scale zoomScale;
    Font boldFont;

    public TimelineWidget(Composite parent, int style, int type) {
        super(parent, style & 0xFFFFFBFF);
        int zoom = (style & 0x400) != 0 ? 20 : 1;
        Composite titlePanel = new Composite((Composite)this, 0);
        this.titleLabel = FormBuilder.createLabel((Composite)titlePanel, (String)"", (int)1);
        this.titleLabel.setFont(this.bold(this.titleLabel.getFont(), this.titleLabel.getDisplay()));
        this.titleSlot = new Composite(titlePanel, 0);
        FormBuilder.createLabel((Composite)this.titleSlot, (String)"");
        this.zoomScale = new Scale(titlePanel, 0x1000100);
        this.zoomScale.setMinimum(1);
        this.zoomScale.setMaximum(20);
        this.zoomScale.setSelection(zoom);
        this.zoomScale.setIncrement(1);
        this.zoomScale.setPageIncrement(20);
        this.zoomScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimelineWidget.this.updateZoom();
            }
        });
        this.scrollPane = new ScrolledComposite((Composite)this, 256);
        Configuration configuration = Configuration.createDefault();
        switch (type) {
            case 1: {
                configuration.setMarginLeft(36);
                configuration.setMarginTop(6);
                configuration.setMarginRight(3);
                configuration.setMarginBottom(18);
                this.editor = new TimelineCurveEditor((Composite)this.scrollPane, 0x20000800, configuration);
                this.editor.addDragListener((DragListener)new TimelineWidgetTooltips(this.editor));
                break;
            }
            case 4: 
            case 6: {
                configuration.setMarginLeft(6);
                configuration.setMarginTop(6);
                configuration.setMarginRight(3);
                configuration.setMarginBottom(18);
                this.editor = new TimelineCurveEditor((Composite)this.scrollPane, 0x20000800, configuration);
                this.editor.addDragListener((DragListener)new TimelineWidgetTooltips(this.editor));
                break;
            }
            case 2: {
                configuration.setMarginLeft(30);
                configuration.setMarginTop(6);
                configuration.setMarginRight(3);
                configuration.setMarginBottom(6);
                this.editor = new CalendarEditor((Composite)this.scrollPane, 0x20000800, configuration);
                this.editor.addDragListener((DragListener)new TimelineWidgetTooltips(this.editor));
                break;
            }
            default: {
                configuration.setMarginLeft(30);
                configuration.setMarginTop(6);
                configuration.setMarginRight(3);
                configuration.setMarginBottom(6);
                this.editor = new TimelineCurveEditor((Composite)this.scrollPane, 0x20000800, configuration);
                this.editor.addDragListener((DragListener)new TimelineWidgetTooltips(this.editor));
            }
        }
        this.editor.setType(type);
        this.editor.setSize(500 * zoom, 80);
        this.editor.setBackground(ColorConstants.listBackground);
        this.scrollPane.setContent((Control)this.editor);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(1).applyTo((Composite)this);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)titlePanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.scrollPane);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(15, 0).numColumns(3).applyTo(titlePanel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.titleLabel);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)this.titleSlot);
        GridDataFactory.fillDefaults().align(4, 1024).grab(false, false).hint(200, -1).applyTo((Control)this.zoomScale);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(3).applyTo(this.titleSlot);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TimelineWidget.this.updateZoom();
            }
        });
    }

    public void setTitleLabel(String label) {
        this.titleLabel.setText(label);
    }

    public void setTimeline(Date startDate, Date endDate, int unitType, double unitSize, Coord2D snapSize) {
        this.editor.setTimeline(startDate, endDate, "", unitType, unitSize, snapSize);
    }

    public Composite getTitleSlot() {
        return this.titleSlot;
    }

    public TimelineEditor getEditor() {
        return this.editor;
    }

    public void setPopupMenu(Menu menu) {
        this.editor.setMenu(menu);
    }

    public void setCurveData(Coord2D[] data) {
        this.editor.setCurveData(data);
    }

    public Coord2D[] getCurveData() {
        return this.editor.getCurveData();
    }

    public void setEnabled(boolean enabled) {
        this.editor.setEnabled(enabled);
        this.editor.setBackground(enabled ? ColorConstants.listBackground : ColorConstants.button);
    }

    private void updateZoom() {
        double d = ((double)this.scrollPane.getOrigin().x + (double)this.scrollPane.getSize().x / 2.0) / (double)this.editor.getSize().x;
        this.editor.setSize(this.zoomScale.getSelection() * this.getSize().x, Math.max(80, this.getClientArea().height - 60));
        this.scrollPane.setOrigin((int)(d * (double)this.editor.getSize().x - (double)this.scrollPane.getSize().x / 2.0), this.scrollPane.getOrigin().y);
    }

    private Font bold(Font f, Display d) {
        if (this.boldFont == null) {
            FontData[] fd = f.getFontData();
            int i = 0;
            while (i < fd.length) {
                fd[i].setStyle(1);
                ++i;
            }
            this.boldFont = new Font((Device)d, fd);
        }
        return this.boldFont;
    }

    public void dispose() {
        this.boldFont.dispose();
        super.dispose();
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("Timeline Test");
        shell.setLayout((Layout)new FillLayout());
        TimelineWidget widget = new TimelineWidget((Composite)shell, 0, 1);
        Coord2D[] data = new Coord2D[]{new Coord2D(31.0, 0.0), new Coord2D(302.0, 1.0), new Coord2D(365.0, 0.0)};
        widget.setTitleLabel("Availability");
        widget.setTimeline(null, null, 6, 1.0, new Coord2D(0.25, 0.1));
        widget.setCurveData(data);
        shell.setSize(600, 600);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

