/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.utils;

import java.util.List;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2DList;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValue;

public class CurveUtils {
    public static Coord2D[] toCurve(double unit, List availabilityList) {
        TimestampValue[] source = availabilityList.toArray(new TimestampValue[availabilityList.size()]);
        Coord2DList result = new Coord2DList();
        int i = 1;
        while (i < source.length) {
            result.add(new Coord2D((double)source[i].getTime() / unit, source[i - 1].getValue()));
            ++i;
        }
        return result.toArray();
    }

    public static TimestampValue[] fromCurve(long unit, Coord2D[] source) {
        TimestampValue[] result = new TimestampValue[source.length + 1];
        if (result.length > 1) {
            result[0] = new TimestampValue(unit, 0.0, source[0].getY());
            int i = 1;
            while (i < result.length - 1) {
                result[i] = new TimestampValue(unit, source[i - 1].getX(), source[i].getY());
                ++i;
            }
            result[result.length - 1] = new TimestampValue(unit, source[source.length - 1].getX(), 0.0);
        } else {
            result[0] = new TimestampValue(unit, 0.0, 100.0);
        }
        return result;
    }

    public static Coord2D[] reduceXAxis(double min, double max, Coord2D[] data) {
        Coord2DList correctedData = new Coord2DList();
        int i = 0;
        while (i < data.length - 1) {
            if (min < data[i].getX() && data[i].getX() < max) {
                correctedData.add(data[i]);
            }
            ++i;
        }
        correctedData.add(new Coord2D(max, data[data.length - 1].getY()));
        return correctedData.toArray();
    }

    public static long findOverflow(List list, double threshold) {
        for (TimestampValue tv : list) {
            if (!(tv.getValue() > threshold)) continue;
            return tv.getTime();
        }
        return -1L;
    }
}

