/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.timeutils;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Interval;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Timestamp;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampComparator;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValue;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValueList;

public class IntervalList {
    List impl = new ArrayList();

    public Interval get(int index) {
        return (Interval)this.impl.get(index);
    }

    public Interval getFirst() {
        return (Interval)this.impl.get(0);
    }

    public Interval getLast() {
        return (Interval)this.impl.get(this.impl.size() - 1);
    }

    public void add(Interval t) {
        this.impl.add(t);
    }

    public void addAll(IntervalList list) {
        this.impl.addAll(list.impl);
    }

    public void remove(Interval t) {
        this.impl.remove(t);
    }

    public int size() {
        return this.impl.size();
    }

    public Interval[] toArray() {
        return this.impl.toArray(new Interval[this.size()]);
    }

    public double averageDuration(int offset, int length) {
        double sum = 0.0;
        int n = offset;
        while (n < offset + length) {
            sum += (double)this.get((int)n).duration;
            ++n;
        }
        return sum / (double)length;
    }

    public double averageDuration() {
        return this.averageDuration(0, this.size());
    }

    public double varianceDuration(double average) {
        double result = 0.0;
        int n = 0;
        while (n < this.size()) {
            double diff = average - (double)this.get((int)n).duration;
            result += diff * diff;
            ++n;
        }
        return result / (double)this.size();
    }

    public long minDuration() {
        long result = this.get((int)0).duration;
        int n = 1;
        while (n < this.size()) {
            result = Math.min(result, this.get((int)n).duration);
            ++n;
        }
        return result;
    }

    public long maxDuration() {
        long result = this.get((int)0).duration;
        int n = 1;
        while (n < this.size()) {
            result = Math.max(result, this.get((int)n).duration);
            ++n;
        }
        return result;
    }

    public TimestampValueList createQuantityCurve() {
        int valueChange;
        TreeMap<Timestamp, Integer> growthCurve = new TreeMap<Timestamp, Integer>(new TimestampComparator());
        int i = 0;
        while (i < this.size()) {
            Interval interval = this.get(i);
            Timestamp t = interval.getStartTimestamp();
            valueChange = 1;
            if (growthCurve.containsKey(t)) {
                valueChange += ((Integer)growthCurve.get(t)).intValue();
            }
            growthCurve.put(t, new Integer(valueChange));
            t = interval.getEndTimestamp();
            valueChange = -1;
            if (growthCurve.containsKey(t)) {
                valueChange += ((Integer)growthCurve.get(t)).intValue();
            }
            growthCurve.put(t, new Integer(valueChange));
            ++i;
        }
        TimestampValueList result = new TimestampValueList();
        double previousValue = 0.0;
        for (Timestamp t : growthCurve.keySet()) {
            valueChange = (Integer)growthCurve.get(t);
            if (valueChange == 0) continue;
            double currentValue = previousValue + (double)valueChange;
            result.add(new TimestampValue(t, currentValue));
            previousValue = currentValue;
        }
        return result;
    }
}

