/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.common;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.AbstractSymbolSourceProviderFactory;
import org.eclipse.jst.jsf.context.symbol.source.ISymbolSourceProvider;
import org.eclipse.jst.jsf.designtime.symbols.FileContextUtil;
import org.eclipse.jst.jsf.designtime.symbols.SymbolUtil;
import org.eclipse.stardust.common.CollectionUtils;

public class SymbolSourceProviderFactory
extends AbstractSymbolSourceProviderFactory {
    private static final ISymbolSourceProvider INSTANCE = new AdditionalSymbolSourceProvider();

    protected ISymbolSourceProvider create(IProject project) {
        return INSTANCE;
    }

    private static class AdditionalSymbolSourceProvider
    implements ISymbolSourceProvider {
        private AdditionalSymbolSourceProvider() {
        }

        public ISymbol[] getSymbols(IAdaptable context, int symbolScopeMask) {
            IFile file = FileContextUtil.deriveIFileFromContext((IAdaptable)context);
            if (file != null) {
                List symbols = CollectionUtils.newList();
                Map<String, String> mapSource = this.getInitializedPageFlowMap();
                IMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIMapTypeDescriptor();
                typeDesc.setMapSource(mapSource);
                typeDesc.setImmutable(false);
                IInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIInstanceSymbol();
                symbol.setName("pageFlowScope");
                symbol.setRuntimeSource(ERuntimeSource.MANAGED_BEAN_SYMBOL_LITERAL);
                symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
                symbols.add(symbol);
                symbol = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
                symbol.setName("rowItem");
                symbol.setRuntimeSource(ERuntimeSource.MANAGED_BEAN_SYMBOL_LITERAL);
                symbols.add(symbol);
                return symbols.toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
            }
            return ISymbol.EMPTY_SYMBOL_ARRAY;
        }

        public ISymbol getSymbol(String name, IAdaptable context, int symbolScopeMask) {
            return SymbolUtil.findSymbolByName((ISymbol[])this.getSymbols(context, symbolScopeMask), (String)name);
        }

        public ISymbol[] getSymbols(String prefix, IAdaptable context, int symbolScopeMask) {
            return SymbolUtil.filterSymbolsByPrefix((ISymbol[])this.getSymbols(context, symbolScopeMask), (String)prefix);
        }

        public boolean isProvider(IAdaptable context) {
            return context.getAdapter(IStructuredDocumentContext.class) != null;
        }

        private Map<String, String> getInitializedPageFlowMap() {
            Map pageFlowMap = CollectionUtils.newMap();
            pageFlowMap.put("activityNotes", "");
            pageFlowMap.put("hideDetailTable", "");
            pageFlowMap.put("logEntry", "");
            pageFlowMap.put("rowSelectionTypeForSearchTable", "");
            pageFlowMap.put("selectedActivityInstance", "");
            pageFlowMap.put("selectedProcessInstance", "");
            pageFlowMap.put("selectedRole", "");
            pageFlowMap.put("selectedSubMenuId", "");
            pageFlowMap.put("selectedTabId", "");
            pageFlowMap.put("selectedUser", "");
            pageFlowMap.put("title", "");
            pageFlowMap.put("userOid", "");
            pageFlowMap.put("typeOfSearch", "");
            return pageFlowMap;
        }
    }
}

