/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.common.context;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.IBeanInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.AbstractContextSymbolFactory;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.ide.wst.common.Common_Messages;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AdditionalBeanFactory
extends AbstractContextSymbolFactory {
    private static final Set varElements = CollectionUtils.newSet();

    static {
        varElements.add("treeTable");
        varElements.add("table");
        varElements.add("iterator");
        varElements.add("navigationPane");
        varElements.add("forEach");
    }

    protected ISymbol internalCreate(String symbolName, int scope, IAdaptable context, List problems) {
        IWorkspaceContextResolver workspaceResolver;
        IProject iProject;
        Attr attr;
        Element owningElement;
        Node curNode;
        IStructuredDocumentContext sContext = (IStructuredDocumentContext)context.getAdapter(IStructuredDocumentContext.class);
        IDOMContextResolver domResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(sContext);
        if (domResolver != null && (curNode = domResolver.getNode()) instanceof Attr && (owningElement = (attr = (Attr)curNode).getOwnerElement()) != null && (iProject = (workspaceResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(sContext)).getProject()) != null) {
            return this.handleSymbolCreation(symbolName, sContext, attr, owningElement, iProject);
        }
        return null;
    }

    public boolean supports(IAdaptable context) {
        return context.getAdapter(IStructuredDocumentContext.class) != null;
    }

    private ISymbol handleSymbolCreation(String symbolName, IStructuredDocumentContext context, Attr attr, Node owningElement, IProject project) {
        ITaglibContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context);
        if (resolver == null || !resolver.canResolveContext((IModelContext)context)) {
            return null;
        }
        String uri = resolver.getTagURIForNodeName(owningElement);
        IBeanInstanceSymbol beanSymbol = null;
        if ("http://myfaces.apache.org/trinidad".equals(uri) || "http://java.sun.com/jstl/core".equals(uri)) {
            String elementName = owningElement.getLocalName();
            String attrName = attr.getName();
            if (varElements.contains(elementName) && "var".equals(attrName)) {
                beanSymbol = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
                beanSymbol.setName(attr.getValue());
                beanSymbol.setDetailedDescription(MessageFormat.format(Common_Messages.DESC_LOCALLY_DEFINED_VARIABLE_FOR, elementName));
            }
        }
        return beanSymbol;
    }
}

