/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.common.utils;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class ArtifactUtils {
    public static IVirtualReference addWebLibraryFromVar(ArtifactEdit artifact, String libraryPath) {
        return ArtifactUtils.addExternalLibraryFromVar(artifact, libraryPath, "/WEB-INF/lib");
    }

    public static IVirtualReference addExternalLibraryFromVar(ArtifactEdit artifact, String libraryPath, String runtimePath) {
        IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)artifact.getProject(), (String)("var/" + libraryPath));
        IVirtualReference ref = ComponentCore.createReference((IVirtualComponent)artifact.getComponent(), (IVirtualComponent)archive, (IPath)new Path(runtimePath));
        artifact.getComponent().addReferences(new IVirtualReference[]{ref});
        return ref;
    }

    public static boolean removeWebLibraryFromVar(ArtifactEdit artifact, String libraryPath) {
        IVirtualReference[] refs;
        boolean deleted = false;
        libraryPath = "var/" + libraryPath;
        boolean isJar = false;
        if (libraryPath.endsWith(".jar")) {
            libraryPath = libraryPath.substring(0, libraryPath.length() - ".jar".length());
        }
        if ((refs = artifact.getComponent().getReferences()) != null) {
            ArrayList<IVirtualReference> updatedRefs = new ArrayList<IVirtualReference>(refs.length);
            int i = 0;
            while (i < refs.length) {
                IVirtualReference ref = refs[i];
                String name = ref.getReferencedComponent().getName();
                if (!StringUtils.isEmpty((String)name) && name.startsWith(libraryPath) && !isJar && name.endsWith(".jar")) {
                    deleted = true;
                } else {
                    updatedRefs.add(ref);
                }
                ++i;
            }
            if (refs.length > updatedRefs.size()) {
                artifact.getComponent().setReferences(updatedRefs.toArray(new IVirtualReference[0]));
            }
        }
        return deleted;
    }

    public static IVirtualReference findExternalLibraryFromRef(ArtifactEdit artifact, String libraryPath) {
        IVirtualReference result = null;
        boolean isJar = false;
        if (libraryPath.endsWith(".jar")) {
            libraryPath = libraryPath.substring(0, libraryPath.length() - ".jar".length());
        }
        IVirtualReference[] references = artifact.getComponent().getReferences();
        int i = 0;
        while (i < references.length) {
            IVirtualReference reference = references[i];
            String name = reference.getReferencedComponent().getName();
            if (!StringUtils.isEmpty((String)name) && name.startsWith(libraryPath) && !isJar && name.endsWith(".jar")) break;
            ++i;
        }
        return result;
    }
}

